/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.chunker;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.ChunkerME;
import chalk.tools.chunker.ChunkerModel;
import chalk.tools.util.ObjectStreamUtils;
import chalk.uima.util.CasConsumerUtil;
import chalk.uima.util.ContainingConstraint;
import chalk.uima.util.OpennlpUtil;
import chalk.uima.util.UimaUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nak.maxent.GIS;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public class ChunkerTrainer
extends CasConsumer_ImplBase {
    private List<ChunkSample> mChunkSamples = new ArrayList<ChunkSample>();
    private UimaContext mContext;
    private String mModelName;
    private Type mSentenceType;
    private Type mTokenType;
    private Feature mPOSFeature;
    private Type mChunkType;
    private Feature mChunkTagFeature;
    private Logger mLogger;
    private String language;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Chunker Trainer.");
        }
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
        this.language = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.Language");
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String string = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, string);
        String string2 = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.ChunkType");
        this.mChunkType = CasConsumerUtil.getType(typeSystem, string2);
        String string3 = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.ChunkTagFeature");
        this.mChunkTagFeature = this.mChunkType.getFeatureByBaseName(string3);
        CasConsumerUtil.checkFeatureType(this.mChunkTagFeature, "uima.cas.String");
        String string4 = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.TokenType");
        this.mTokenType = CasConsumerUtil.getType(typeSystem, string4);
        String string5 = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.POSFeature");
        this.mPOSFeature = this.mTokenType.getFeatureByBaseName(string5);
        CasConsumerUtil.checkFeatureType(this.mPOSFeature, "uima.cas.String");
    }

    public void processCas(CAS cAS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS annotationFS : annotationIndex) {
            this.processSentence(cAS, annotationFS);
        }
    }

    private void processSentence(CAS cAS, AnnotationFS annotationFS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mChunkType);
        ContainingConstraint containingConstraint = new ContainingConstraint(annotationFS);
        FSIterator fSIterator = cAS.createFilteredIterator(annotationIndex.iterator(), (FSMatchConstraint)containingConstraint);
        while (fSIterator.hasNext()) {
            AnnotationFS annotationFS2 = (AnnotationFS)fSIterator.next();
            this.processChunk(cAS, annotationFS2);
        }
    }

    private void processChunk(CAS cAS, AnnotationFS annotationFS) {
        String string = annotationFS.getFeatureValueAsString(this.mChunkTagFeature);
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mTokenType);
        ContainingConstraint containingConstraint = new ContainingConstraint(annotationFS);
        FSIterator fSIterator = cAS.createFilteredIterator(annotationIndex.iterator(), (FSMatchConstraint)containingConstraint);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (fSIterator.hasNext()) {
            AnnotationFS annotationFS2 = (AnnotationFS)fSIterator.next();
            arrayList.add(annotationFS2.getCoveredText().trim());
            arrayList2.add(annotationFS2.getFeatureValueAsString(this.mPOSFeature));
            arrayList3.add(string);
        }
        this.mChunkSamples.add(new ChunkSample(arrayList, arrayList2, arrayList3));
    }

    public void collectionProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        ChunkerModel chunkerModel = ChunkerME.train(this.language, ObjectStreamUtils.createObjectStream(this.mChunkSamples), 100, 5);
        this.mChunkSamples = null;
        File file = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(chunkerModel, file);
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.mChunkSamples = null;
    }
}

