/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.namefind;

import chalk.tools.util.Span;
import chalk.uima.util.AnnotationComboIterator;
import chalk.uima.util.AnnotationIteratorPair;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

abstract class AbstractNameFinder
extends CasAnnotator_ImplBase {
    protected final String name;
    protected Type mSentenceType;
    protected Type mTokenType;
    protected Type mNameType;
    protected UimaContext context;
    protected Logger mLogger;
    private Boolean isRemoveExistingAnnotations;

    AbstractNameFinder(String string) {
        this.name = string;
    }

    protected void initialize() throws ResourceInitializationException {
    }

    public final void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        this.context = uimaContext;
        this.mLogger = uimaContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the " + this.name + ".");
        }
        this.isRemoveExistingAnnotations = AnnotatorUtil.getOptionalBooleanParameter(uimaContext, "opennlp.uima.IsRemoveExistingAnnotations");
        if (this.isRemoveExistingAnnotations == null) {
            this.isRemoveExistingAnnotations = false;
        }
        this.initialize();
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mSentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.mNameType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.NameType");
    }

    protected void postProcessAnnotations(Span[] spanArray, AnnotationFS[] annotationFSArray) {
    }

    protected void documentDone(CAS cAS) {
    }

    protected abstract Span[] find(CAS var1, String[] var2);

    public final void process(CAS cAS) {
        Object object22;
        AnnotationComboIterator annotationComboIterator;
        if (this.isRemoveExistingAnnotations.booleanValue()) {
            annotationComboIterator = new AnnotationComboIterator(cAS, this.mSentenceType, this.mNameType);
            LinkedList linkedList = new LinkedList();
            for (Object object22 : annotationComboIterator) {
                for (AnnotationFS spanArray : ((AnnotationIteratorPair)object22).getSubIterator()) {
                    linkedList.add(spanArray);
                }
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object22 = (AnnotationFS)iterator.next();
                cAS.removeFsFromIndexes((FeatureStructure)object22);
            }
        }
        annotationComboIterator = new AnnotationComboIterator(cAS, this.mSentenceType, this.mTokenType);
        for (Iterator iterator : annotationComboIterator) {
            object22 = new LinkedList();
            LinkedList linkedList = new LinkedList();
            for (AnnotationFS annotationFS : ((AnnotationIteratorPair)((Object)iterator)).getSubIterator()) {
                object22.add(annotationFS);
                linkedList.add(annotationFS.getCoveredText());
            }
            Span[] spanArray = this.find(cAS, linkedList.toArray(new String[linkedList.size()]));
            AnnotationFS[] annotationFSArray = new AnnotationFS[spanArray.length];
            for (int i = 0; i < spanArray.length; ++i) {
                int n = ((AnnotationFS)object22.get(spanArray[i].getStart())).getBegin();
                int n2 = ((AnnotationFS)object22.get(spanArray[i].getEnd() - 1)).getEnd();
                annotationFSArray[i] = cAS.createAnnotation(this.mNameType, n, n2);
                cAS.getIndexRepository().addFS((FeatureStructure)annotationFSArray[i]);
            }
            this.postProcessAnnotations(spanArray, annotationFSArray);
        }
        this.documentDone(cAS);
    }
}

