/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.namefind;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.namefind.TokenNameFinder;
import chalk.tools.util.Span;
import chalk.uima.namefind.AbstractNameFinder;
import chalk.uima.util.AnnotatorUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;

public class DictionaryNameFinder
extends AbstractNameFinder {
    private TokenNameFinder mNameFinder;

    public DictionaryNameFinder() {
        super("OpenNLP Dictionary Name annotator");
    }

    @Override
    public void initialize() throws ResourceInitializationException {
        Dictionary dictionary;
        try {
            String string = AnnotatorUtil.getRequiredStringParameter(this.context, "opennlp.uima.Dictionary");
            InputStream inputStream = AnnotatorUtil.getResourceAsStream(this.context, string);
            dictionary = new Dictionary(inputStream);
        }
        catch (IOException iOException) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_dictionary_reading", new Object[]{iOException.getMessage()});
        }
        this.mNameFinder = new chalk.tools.namefind.DictionaryNameFinder(dictionary);
    }

    @Override
    protected Span[] find(CAS cAS, String[] stringArray) {
        return this.mNameFinder.find(stringArray);
    }

    public void destroy() {
        this.mNameFinder = null;
    }
}

