/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.postag;

import chalk.tools.postag.POSModel;
import chalk.tools.postag.POSTaggerME;
import chalk.uima.postag.POSModelResource;
import chalk.uima.util.AnnotationComboIterator;
import chalk.uima.util.AnnotationIteratorPair;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class POSTagger
extends CasAnnotator_ImplBase {
    private POSTaggerME posTagger;
    private Type sentenceType;
    private Type tokenType;
    private Feature posFeature;
    private Feature probabilityFeature;
    private UimaContext context;
    private Logger logger;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        POSModel pOSModel;
        Object object;
        super.initialize(uimaContext);
        this.context = uimaContext;
        this.logger = uimaContext.getLogger();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Initializing the OpenNLP Part of Speech annotator.");
        }
        try {
            object = (POSModelResource)uimaContext.getResourceObject(UimaUtil.MODEL_PARAMETER);
            pOSModel = object.getModel();
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException((Throwable)resourceAccessException);
        }
        object = AnnotatorUtil.getOptionalIntegerParameter(uimaContext, "opennlp.uima.BeamSize");
        if (object == null) {
            object = 3;
        }
        this.posTagger = new POSTaggerME(pOSModel, (Integer)object, 0);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.sentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.tokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.posFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.tokenType, "opennlp.uima.POSFeature", "uima.cas.String");
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.tokenType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
    }

    public void process(CAS cAS) {
        AnnotationComboIterator annotationComboIterator = new AnnotationComboIterator(cAS, this.sentenceType, this.tokenType);
        for (AnnotationIteratorPair annotationIteratorPair : annotationComboIterator) {
            CharSequence charSequence;
            Object object2;
            LinkedList<AnnotationFS> linkedList = new LinkedList<AnnotationFS>();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            for (Object object2 : annotationIteratorPair.getSubIterator()) {
                linkedList.add((AnnotationFS)object2);
                linkedList2.add(object2.getCoveredText());
            }
            List<String> list = this.posTagger.tag(linkedList2);
            object2 = null;
            if (this.probabilityFeature != null) {
                object2 = this.posTagger.probs();
            }
            Iterator iterator = list.iterator();
            Iterator iterator2 = linkedList.iterator();
            int n = 0;
            while (iterator.hasNext() && iterator2.hasNext()) {
                charSequence = (String)iterator.next();
                AnnotationFS annotationFS = (AnnotationFS)iterator2.next();
                annotationFS.setStringValue(this.posFeature, (String)charSequence);
                if (object2 != null) {
                    annotationFS.setDoubleValue(this.posFeature, (double)object2[n]);
                }
                ++n;
            }
            if (!this.logger.isLoggable(Level.FINER)) continue;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("\"");
            for (AnnotationFS annotationFS : linkedList) {
                ((StringBuilder)charSequence).append(annotationFS.getCoveredText());
                ((StringBuilder)charSequence).append('\\');
                ((StringBuilder)charSequence).append(annotationFS.getStringValue(this.posFeature));
                ((StringBuilder)charSequence).append(' ');
            }
            if (((StringBuilder)charSequence).length() > 1) {
                ((StringBuilder)charSequence).setLength(((StringBuilder)charSequence).length() - 1);
            }
            ((StringBuilder)charSequence).append("\"");
            this.logger.log(Level.FINER, ((StringBuilder)charSequence).toString());
        }
    }

    public void destroy() {
        this.posTagger = null;
    }
}

