/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.sentdetect;

import chalk.tools.util.Span;
import chalk.uima.util.AnnotatorUtil;
import chalk.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public abstract class AbstractSentenceDetector
extends CasAnnotator_ImplBase {
    protected UimaContext context;
    protected Logger logger;
    protected Type containerType;
    protected Type sentenceType;
    private Boolean isRemoveExistingAnnotations;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this.context = uimaContext;
        this.logger = uimaContext.getLogger();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Initializing the OpenNLP Sentence annotator.");
        }
        this.isRemoveExistingAnnotations = AnnotatorUtil.getOptionalBooleanParameter(uimaContext, "opennlp.uima.IsRemoveExistingAnnotations");
        if (this.isRemoveExistingAnnotations == null) {
            this.isRemoveExistingAnnotations = false;
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.containerType = AnnotatorUtil.getOptionalTypeParameter(this.context, typeSystem, "opennlp.uima.ContainerType");
        if (this.containerType == null) {
            this.containerType = typeSystem.getType("uima.tcas.DocumentAnnotation");
        }
        this.sentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
    }

    protected abstract Span[] detectSentences(String var1);

    protected void postProcessAnnotations(AnnotationFS[] annotationFSArray) {
    }

    public void process(CAS cAS) throws AnalysisEngineProcessException {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.containerType);
        for (AnnotationFS annotationFS : annotationIndex) {
            String string = annotationFS.getCoveredText();
            if (this.isRemoveExistingAnnotations.booleanValue()) {
                UimaUtil.removeAnnotations(cAS, annotationFS, this.sentenceType);
            }
            Span[] spanArray = this.detectSentences(string);
            AnnotationFS[] annotationFSArray = new AnnotationFS[spanArray.length];
            for (int i = 0; i < spanArray.length; ++i) {
                annotationFSArray[i] = cAS.createAnnotation(this.sentenceType, spanArray[i].getStart() + annotationFS.getBegin(), spanArray[i].getEnd() + annotationFS.getBegin());
                cAS.getIndexRepository().addFS((FeatureStructure)annotationFSArray[i]);
                if (!this.logger.isLoggable(Level.FINER)) continue;
                this.logger.log(Level.FINER, "\"" + annotationFSArray[i].getCoveredText() + "\"");
            }
            this.postProcessAnnotations(annotationFSArray);
        }
    }
}

