/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.sentdetect;

import chalk.tools.sentdetect.SentenceDetectorFactory;
import chalk.tools.sentdetect.SentenceDetectorME;
import chalk.tools.sentdetect.SentenceModel;
import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.ObjectStreamUtils;
import chalk.tools.util.Span;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.model.ModelUtil;
import chalk.uima.util.CasConsumerUtil;
import chalk.uima.util.OpennlpUtil;
import chalk.uima.util.SampleTraceStream;
import chalk.uima.util.UimaUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import nak.maxent.GIS;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public final class SentenceDetectorTrainer
extends CasConsumer_ImplBase {
    private List<SentenceSample> sentenceSamples = new ArrayList<SentenceSample>();
    private Type mSentenceType;
    private String mModelName;
    private String language = "en";
    private Logger mLogger;
    private UimaContext mContext;
    private String eosChars;
    private File sampleTraceFile;
    private String sampleTraceFileEncoding;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        this.mContext = this.getUimaContext();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP SentenceDetector trainer.");
        }
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
        this.language = CasConsumerUtil.getRequiredStringParameter(this.mContext, "opennlp.uima.Language");
        this.eosChars = CasConsumerUtil.getOptionalStringParameter(this.mContext, "opennlp.uima.EOSChars");
        String string = CasConsumerUtil.getOptionalStringParameter(this.getUimaContext(), "opennlp.uima.SampleTraceFile");
        if (string != null) {
            this.sampleTraceFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + string);
            this.sampleTraceFileEncoding = CasConsumerUtil.getRequiredStringParameter(this.getUimaContext(), "opennlp.uima.SampleTraceFileEncoding");
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String string = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, string);
    }

    public void processCas(CAS cAS) {
        AnnotationIndex annotationIndex = cAS.getAnnotationIndex(this.mSentenceType);
        Span[] spanArray = new Span[annotationIndex.size()];
        int n = 0;
        for (AnnotationFS annotationFS : annotationIndex) {
            spanArray[n++] = new Span(annotationFS.getBegin(), annotationFS.getEnd());
        }
        this.sentenceSamples.add(new SentenceSample(cAS.getDocumentText().replace('\n', ' '), spanArray));
    }

    public void collectionProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = false;
        char[] cArray = null;
        if (this.eosChars != null) {
            cArray = this.eosChars.toCharArray();
        }
        SentenceDetectorFactory sentenceDetectorFactory = SentenceDetectorFactory.create(null, this.language, true, null, cArray);
        TrainingParameters trainingParameters = ModelUtil.createTrainingParameters(100, 5);
        ObjectStream<SentenceSample> objectStream = ObjectStreamUtils.createObjectStream(this.sentenceSamples);
        OutputStreamWriter outputStreamWriter = null;
        if (this.sampleTraceFile != null) {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.sampleTraceFile), this.sampleTraceFileEncoding);
            objectStream = new SampleTraceStream<SentenceSample>(objectStream, outputStreamWriter);
        }
        SentenceModel sentenceModel = SentenceDetectorME.train(this.language, objectStream, sentenceDetectorFactory, trainingParameters);
        this.sentenceSamples = null;
        File file = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(sentenceModel, file);
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.sentenceSamples = null;
    }
}

