/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.util;

import chalk.tools.dictionary.Dictionary;
import chalk.uima.util.OpenNlpAnnotatorProcessException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class AnnotatorUtil {
    private AnnotatorUtil() {
    }

    public static Type getType(TypeSystem typeSystem, String string) throws AnalysisEngineProcessException {
        Type type = typeSystem.getType(string);
        if (type == null) {
            throw new OpenNlpAnnotatorProcessException("type_not_found", new Object[]{string});
        }
        return type;
    }

    private static void checkFeatureType(Feature feature, String string) throws AnalysisEngineProcessException {
        if (!feature.getRange().getName().equals(string)) {
            throw new OpenNlpAnnotatorProcessException("wrong_feature_type", new Object[]{feature.getName(), string});
        }
    }

    public static Feature getRequiredFeature(Type type, String string) throws AnalysisEngineProcessException {
        Feature feature = type.getFeatureByBaseName(string);
        if (feature == null) {
            throw new OpenNlpAnnotatorProcessException("feature_not_found", new Object[]{type.getName(), string});
        }
        return feature;
    }

    public static Feature getRequiredFeature(Type type, String string, String string2) throws AnalysisEngineProcessException {
        Feature feature = AnnotatorUtil.getRequiredFeature(type, string);
        AnnotatorUtil.checkFeatureType(feature, string2);
        return feature;
    }

    public static Feature getRequiredFeatureParameter(UimaContext uimaContext, Type type, String string) throws AnalysisEngineProcessException {
        String string2;
        try {
            string2 = AnnotatorUtil.getRequiredStringParameter(uimaContext, string);
        }
        catch (ResourceInitializationException resourceInitializationException) {
            throw new OpenNlpAnnotatorProcessException(resourceInitializationException);
        }
        return AnnotatorUtil.getRequiredFeature(type, string2);
    }

    public static Feature getRequiredFeatureParameter(UimaContext uimaContext, Type type, String string, String string2) throws AnalysisEngineProcessException {
        String string3;
        try {
            string3 = AnnotatorUtil.getRequiredStringParameter(uimaContext, string);
        }
        catch (ResourceInitializationException resourceInitializationException) {
            throw new OpenNlpAnnotatorProcessException(resourceInitializationException);
        }
        return AnnotatorUtil.getRequiredFeature(type, string3, string2);
    }

    public static Type getRequiredTypeParameter(UimaContext uimaContext, TypeSystem typeSystem, String string) throws AnalysisEngineProcessException {
        String string2;
        try {
            string2 = AnnotatorUtil.getRequiredStringParameter(uimaContext, string);
        }
        catch (ResourceInitializationException resourceInitializationException) {
            throw new OpenNlpAnnotatorProcessException(resourceInitializationException);
        }
        return AnnotatorUtil.getType(typeSystem, string2);
    }

    public static String getRequiredStringParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        String string2 = AnnotatorUtil.getOptionalStringParameter(uimaContext, string);
        AnnotatorUtil.checkForNull(string2, string);
        return string2;
    }

    public static Integer getRequiredIntegerParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Integer n = AnnotatorUtil.getOptionalIntegerParameter(uimaContext, string);
        AnnotatorUtil.checkForNull(n, string);
        return n;
    }

    public static Float getRequiredFloatParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Float f = AnnotatorUtil.getOptionalFloatParameter(uimaContext, string);
        AnnotatorUtil.checkForNull(f, string);
        return f;
    }

    public static Boolean getRequiredBooleanParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Boolean bl = AnnotatorUtil.getOptionalBooleanParameter(uimaContext, string);
        AnnotatorUtil.checkForNull(bl, string);
        return bl;
    }

    private static void checkForNull(Object object, String string) throws ResourceInitializationException {
        if (object == null) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "parameter_not_found", new Object[]{string});
        }
    }

    public static Feature getOptionalFeatureParameter(UimaContext uimaContext, Type type, String string, String string2) throws AnalysisEngineProcessException {
        String string3;
        try {
            string3 = AnnotatorUtil.getOptionalStringParameter(uimaContext, string);
        }
        catch (ResourceInitializationException resourceInitializationException) {
            throw new OpenNlpAnnotatorProcessException(resourceInitializationException);
        }
        if (string3 != null) {
            return AnnotatorUtil.getOptionalFeature(type, string3, string2);
        }
        return null;
    }

    public static Feature getOptionalFeature(Type type, String string, String string2) throws AnalysisEngineProcessException {
        Feature feature = type.getFeatureByBaseName(string);
        AnnotatorUtil.checkFeatureType(feature, string2);
        return feature;
    }

    public static Type getOptionalTypeParameter(UimaContext uimaContext, TypeSystem typeSystem, String string) throws AnalysisEngineProcessException {
        String string2;
        try {
            string2 = AnnotatorUtil.getOptionalStringParameter(uimaContext, string);
        }
        catch (ResourceInitializationException resourceInitializationException) {
            throw new OpenNlpAnnotatorProcessException(resourceInitializationException);
        }
        if (string2 != null) {
            return AnnotatorUtil.getType(typeSystem, string2);
        }
        return null;
    }

    public static String getOptionalStringParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = AnnotatorUtil.getOptionalParameter(uimaContext, string);
        if (object instanceof String) {
            return (String)object;
        }
        if (object == null) {
            return null;
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{string, "String"});
    }

    public static String[] getOptionalStringArrayParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = AnnotatorUtil.getOptionalParameter(uimaContext, string);
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object == null) {
            return new String[0];
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{string, "String array"});
    }

    public static Integer getOptionalIntegerParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = AnnotatorUtil.getOptionalParameter(uimaContext, string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object == null) {
            return null;
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{string, "Integer"});
    }

    public static Float getOptionalFloatParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = AnnotatorUtil.getOptionalParameter(uimaContext, string);
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object == null) {
            return null;
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{string, "Float"});
    }

    public static Boolean getOptionalBooleanParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = AnnotatorUtil.getOptionalParameter(uimaContext, string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object == null) {
            return null;
        }
        throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "wrong_parameter_type", new Object[]{string, "Boolean"});
    }

    private static Object getOptionalParameter(UimaContext uimaContext, String string) throws ResourceInitializationException {
        Object object = uimaContext.getConfigParameterValue(string);
        Logger logger = uimaContext.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, string + " = " + (object != null ? object.toString() : "not set"));
        }
        return object;
    }

    public static InputStream getResourceAsStream(UimaContext uimaContext, String string) throws ResourceInitializationException {
        InputStream inputStream = AnnotatorUtil.getOptionalResourceAsStream(uimaContext, string);
        if (inputStream == null) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_model_reading", new Object[]{string + " could not be found!"});
        }
        return inputStream;
    }

    public static InputStream getOptionalResourceAsStream(UimaContext uimaContext, String string) throws ResourceInitializationException {
        InputStream inputStream;
        try {
            inputStream = uimaContext.getResourceAsStream(string);
        }
        catch (ResourceAccessException resourceAccessException) {
            throw new ResourceInitializationException((Throwable)resourceAccessException);
        }
        return inputStream;
    }

    public static Dictionary createOptionalDictionary(UimaContext uimaContext, String string) throws ResourceInitializationException {
        String string2 = AnnotatorUtil.getOptionalStringParameter(uimaContext, string);
        Dictionary dictionary = null;
        if (string2 != null) {
            block5: {
                Logger logger = uimaContext.getLogger();
                try {
                    InputStream inputStream = AnnotatorUtil.getOptionalResourceAsStream(uimaContext, string2);
                    if (inputStream == null) {
                        String string3 = "The dictionary file " + string2 + " does not exist!";
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, string3);
                        }
                        return null;
                    }
                    dictionary = new Dictionary(inputStream);
                }
                catch (IOException iOException) {
                    String string4 = "IOException during dictionary reading, running without dictionary: " + iOException.getMessage();
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, string4);
                }
            }
            return dictionary;
        }
        return null;
    }
}

