/*
 * Decompiled with CFR 0.152.
 */
package chalk.uima.util;

import chalk.tools.util.TrainingParameters;
import chalk.tools.util.model.BaseModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nak.core.TrainUtil;
import org.apache.uima.resource.ResourceInitializationException;

public final class OpennlpUtil {
    private OpennlpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(BaseModel baseModel, File file) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            baseModel.serialize(outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadBytes(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final TrainingParameters loadTrainingParams(String string, boolean bl) throws ResourceInitializationException {
        TrainingParameters trainingParameters;
        if (string != null) {
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(string));
                trainingParameters = new TrainingParameters(inputStream);
            }
            catch (IOException iOException) {
                throw new ResourceInitializationException((Throwable)iOException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (!TrainUtil.isValid(trainingParameters.getSettings())) {
                throw new ResourceInitializationException((Throwable)new Exception("Training parameters file is invalid!"));
            }
            if (!bl && TrainUtil.isSequenceTraining(trainingParameters.getSettings())) {
                throw new ResourceInitializationException((Throwable)new Exception("Sequence training is not supported!"));
            }
        } else {
            trainingParameters = TrainingParameters.defaultParams();
        }
        return trainingParameters;
    }
}

