/*
 * Decompiled with CFR 0.152.
 */
package epic.sequences;

import breeze.config.CommandLineParser$;
import breeze.config.Configuration$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableVectorField;
import breeze.optimize.BatchDiffFunction;
import breeze.optimize.CachedBatchDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.GradientTester$;
import breeze.util.Implicits$;
import breeze.util.package$;
import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import epic.features.SurfaceFeaturizer;
import epic.features.WordFeaturizer;
import epic.framework.Feature;
import epic.framework.ModelObjective;
import epic.ontonotes.ConllOntoReader$;
import epic.ontonotes.Document;
import epic.ontonotes.NerType$;
import epic.ontonotes.Sentence;
import epic.sequences.Segmentation;
import epic.sequences.SegmentationEval$;
import epic.sequences.SegmentationModelFactory;
import epic.sequences.SegmentationModelFactory$;
import epic.sequences.SemiCRFInference;
import epic.sequences.SemiCRFModel;
import epic.sequences.SemiNerPipeline;
import epic.util.NotProvided$;
import epic.util.Optional;
import epic.util.Optional$;
import java.io.File;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SemiNerPipeline$
implements LazyLogging {
    public static final SemiNerPipeline$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SemiNerPipeline$();
    }

    private Logger logger$lzycompute() {
        SemiNerPipeline$ semiNerPipeline$ = this;
        synchronized (semiNerPipeline$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void main(String[] args) {
        Segmentation[] instances;
        Tuple2 tuple2;
        SemiNerPipeline.Params params = (SemiNerPipeline.Params)CommandLineParser$.MODULE$.readIn((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])args), CommandLineParser$.MODULE$.readIn$default$2(), CommandLineParser$.MODULE$.readIn$default$3(), CommandLineParser$.MODULE$.readIn$default$4(), CommandLineParser$.MODULE$.readIn$default$5(), CommandLineParser$.MODULE$.readIn$default$6(), ManifestFactory$.MODULE$.classType(SemiNerPipeline.Params.class));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Command line arguments for recovery:\n").append((Object)Configuration$.MODULE$.fromObject((Object)params, Configuration$.MODULE$.fromObject$default$2(), ManifestFactory$.MODULE$.classType(SemiNerPipeline.Params.class)).toCommandLineString()).toString());
        }
        if ((tuple2 = Predef$.MODULE$.refArrayOps((Object[])(instances = (Segmentation[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])params.path().listFiles()).take(params.nfiles())).flatMap((Function1)new Serializable(){

            public final IndexedSeq<Segmentation<Enumeration.Value, String>> apply(File file) {
                return (IndexedSeq)ConllOntoReader$.MODULE$.readDocuments(file).flatMap((Function1)new Serializable(this){

                    public final IndexedSeq<Segmentation<Enumeration.Value, String>> apply(Document doc) {
                        return (IndexedSeq)doc.sentences().map((Function1)new Serializable(this){

                            public final Segmentation<Enumeration.Value, String> apply(Sentence s) {
                                return s.nerSegmentation();
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Segmentation.class))))).splitAt(instances.length * 9 / 10)) != null) {
            Object object;
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            Segmentation[] train2 = (Segmentation[])tuple22._1();
            Segmentation[] test = (Segmentation[])tuple22._2();
            None$ gazetteer = None$.MODULE$;
            Enumeration.Value x$6 = NerType$.MODULE$.OutsideSentence();
            Product x$7 = Optional$.MODULE$.liftOption(gazetteer);
            Optional<WordFeaturizer<String>> x$8 = SegmentationModelFactory$.MODULE$.$lessinit$greater$default$2();
            Optional<SurfaceFeaturizer<String>> x$9 = SegmentationModelFactory$.MODULE$.$lessinit$greater$default$3();
            NotProvided$ x$10 = SegmentationModelFactory$.MODULE$.$lessinit$greater$default$4();
            Function1<Feature, Object> x$11 = SegmentationModelFactory$.MODULE$.$lessinit$greater$default$6();
            SemiCRFModel<Enumeration.Value, String> model = new SegmentationModelFactory<Enumeration.Value>(x$6, x$8, x$9, x$10, (Optional)x$7, x$11).makeModel((IndexedSeq<Segmentation<Enumeration.Value, String>>)Predef$.MODULE$.wrapRefArray((Object[])train2));
            ModelObjective obj = new ModelObjective(model, Predef$.MODULE$.wrapRefArray((Object[])train2), params.nthreads());
            CachedBatchDiffFunction cached = new CachedBatchDiffFunction(obj, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double()));
            if (params.checkGradient()) {
                DenseVector<Object> x$13 = obj.initialWeightVector(true);
                Serializable x$14 = new Serializable(model){
                    private final SemiCRFModel model$1;

                    public final String apply(int x) {
                        return this.model$1.featureIndex().get(x).toString();
                    }
                    {
                        this.model$1 = model$1;
                    }
                };
                double x$15 = GradientTester$.MODULE$.test$default$3();
                boolean x$16 = GradientTester$.MODULE$.test$default$4();
                double x$17 = GradientTester$.MODULE$.test$default$5();
                double x$18 = GradientTester$.MODULE$.test$default$6();
                object = GradientTester$.MODULE$.test((DiffFunction)cached, x$13, x$15, x$16, x$17, x$18, (Function1)x$14, Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double()), DenseVector$.MODULE$.canNorm((Field)Field.fieldDouble$.MODULE$), DenseVector$.MODULE$.canSubD());
            } else {
                object = BoxedUnit.UNIT;
            }
            FirstOrderMinimizer.State finalState = (FirstOrderMinimizer.State)Implicits$.MODULE$.scEnrichIterator(Implicits$.MODULE$.scEnrichIterator(params.opt().iterations((BatchDiffFunction)cached, obj.initialWeightVector(false), (MutableVectorField)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()))).tee((Function1)new Serializable(params, test, model){
                private final SemiNerPipeline.Params params$1;
                private final Segmentation[] test$1;
                private final SemiCRFModel model$1;

                public final void apply(FirstOrderMinimizer.State state) {
                    if ((state.iter() + 1) % this.params$1.iterPerEval() == 0) {
                        SemiNerPipeline$.MODULE$.epic$sequences$SemiNerPipeline$$eval$1(state, this.test$1, this.model$1);
                    }
                }
                {
                    this.params$1 = params$1;
                    this.test$1 = test$1;
                    this.model$1 = model$1;
                }
            }).take(params.opt().maxIterations())).last();
            this.epic$sequences$SemiNerPipeline$$eval$1(finalState, test, model);
            package$.MODULE$.writeObject(params.modelOut(), model.extractCRF((DenseVector<Object>)((DenseVector)finalState.x())));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public final void epic$sequences$SemiNerPipeline$$eval$1(FirstOrderMinimizer.State state, Segmentation[] test$1, SemiCRFModel model$1) {
        SemiCRFInference crf = model$1.extractCRF((DenseVector<Object>)((DenseVector)state.x()));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Eval + ").append((Object)BoxesRunTime.boxToInteger((int)(state.iter() + 1))).append((Object)" ").append((Object)SegmentationEval$.MODULE$.eval(crf, Predef$.MODULE$.wrapRefArray((Object[])test$1), SegmentationEval$.MODULE$.eval$default$3())).toString());
    }

    private SemiNerPipeline$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

