package epic.features

/**
 * Generates "word-shapes" that track capitalization patterns and character type
 * patterns. e.g.
 * @author dlwh
 */
object WordShapeGenerator extends (String=>String) with Serializable {

  def apply(v1: String) = signatureFor(v1)

  def signatureFor(word: String) = {
    val result = new StringBuilder(word.length);
    var i = 0;
    while (i < word.length) {
      val c = word(i);
      val x = if (c.isLetter && c.isUpper) 'X' else if (c.isLetter) 'x' else if (c.isDigit) 'd' else c;
      if (result.length > 1 && (result.last == x) && result(result.length - 2) == x) {
        result += 'e'
      } else if (result.length > 1 && result.last == 'e' && result(result.length - 2) == x) {
        () // nothing
      } else {
        result += x;
      }
      i += 1;
    }
    result.toString
  }
}
