/*
 * Decompiled with CFR 0.152.
 */
package epic.sequences;

import breeze.config.CommandLineParser$;
import breeze.config.Configuration$;
import breeze.optimize.FirstOrderMinimizer;
import breeze.util.package$;
import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import epic.features.WordFeaturizer;
import epic.sequences.CRF;
import epic.sequences.CRF$;
import epic.sequences.Gazetteer;
import epic.sequences.TaggedSequence;
import epic.sequences.TaggedSequenceEval;
import epic.sequences.TaggedSequenceEval$;
import epic.sequences.TrainPosTagger;
import epic.trees.AnnotatedLabel;
import epic.trees.AnnotatedLabel$;
import epic.trees.TreeInstance;
import epic.util.CacheBroker;
import epic.util.Optional;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class TrainPosTagger$
implements LazyLogging {
    public static final TrainPosTagger$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TrainPosTagger$();
    }

    private Logger logger$lzycompute() {
        TrainPosTagger$ trainPosTagger$ = this;
        synchronized (trainPosTagger$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        TrainPosTagger.Params params = (TrainPosTagger.Params)CommandLineParser$.MODULE$.readIn((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])args), CommandLineParser$.MODULE$.readIn$default$2(), CommandLineParser$.MODULE$.readIn$default$3(), CommandLineParser$.MODULE$.readIn$default$4(), CommandLineParser$.MODULE$.readIn$default$5(), CommandLineParser$.MODULE$.readIn$default$6(), ManifestFactory$.MODULE$.classType(TrainPosTagger.Params.class));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Command line arguments for recovery:\n").append((Object)Configuration$.MODULE$.fromObject((Object)params, Configuration$.MODULE$.fromObject$default$2(), ManifestFactory$.MODULE$.classType(TrainPosTagger.Params.class)).toCommandLineString()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        IndexedSeq train2 = (IndexedSeq)((TraversableLike)params.treebank().trainTrees().map((Function1)new Serializable(){

            public final TreeInstance<AnnotatedLabel, String> apply(TreeInstance<AnnotatedLabel, String> x$1) {
                return x$1.mapLabels(new Serializable(this){

                    public final AnnotatedLabel apply(AnnotatedLabel x$2) {
                        return x$2.baseAnnotatedLabel();
                    }
                });
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){

            public final TaggedSequence<AnnotatedLabel, String> apply(TreeInstance<AnnotatedLabel, String> x$3) {
                return x$3.asTaggedSequence();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq test = (IndexedSeq)((TraversableLike)params.treebank().devTrees().map((Function1)new Serializable(){

            public final TreeInstance<AnnotatedLabel, String> apply(TreeInstance<AnnotatedLabel, String> x$4) {
                return x$4.mapLabels(new Serializable(this){

                    public final AnnotatedLabel apply(AnnotatedLabel x$5) {
                        return x$5.baseAnnotatedLabel();
                    }
                });
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){

            public final TaggedSequence<AnnotatedLabel, String> apply(TreeInstance<AnnotatedLabel, String> x$6) {
                return x$6.asTaggedSequence();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        AnnotatedLabel x$10 = AnnotatedLabel$.MODULE$.apply("TOP");
        FirstOrderMinimizer.OptParams x$11 = params.opt();
        Gazetteer<Object, String> x$12 = CRF$.MODULE$.buildSimple$default$3();
        Optional<WordFeaturizer<String>> x$13 = CRF$.MODULE$.buildSimple$default$4();
        Optional<WordFeaturizer<String>> x$14 = CRF$.MODULE$.buildSimple$default$5();
        double x$15 = CRF$.MODULE$.buildSimple$default$7();
        CacheBroker x$23 = CRF$.MODULE$.buildSimple$default$8(train2, x$10, x$12, x$13, x$14, x$11, x$15);
        CRF<AnnotatedLabel, String> crf = CRF$.MODULE$.buildSimple(train2, x$10, x$12, x$13, x$14, x$11, x$15, x$23);
        package$.MODULE$.writeObject(params.modelOut(), crf);
        TaggedSequenceEval.Stats<AnnotatedLabel> stats = TaggedSequenceEval$.MODULE$.eval(crf, test, TaggedSequenceEval$.MODULE$.eval$default$3());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final Stats: ").append(stats).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Confusion Matrix:\n").append(stats.confusion()).toString());
    }

    private TrainPosTagger$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

