/*
 * Decompiled with CFR 0.152.
 */
package epic.sentiment;

import breeze.collection.mutable.TriangularArray;
import breeze.collection.mutable.TriangularArray$;
import breeze.config.CommandLineParser$;
import breeze.linalg.Counter;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.optimize.BatchDiffFunction;
import breeze.optimize.CachedBatchDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import epic.constraints.ChartConstraints;
import epic.constraints.ChartConstraints$Factory$class;
import epic.constraints.LabeledSpanConstraints;
import epic.constraints.SpanConstraints;
import epic.constraints.SpanConstraints$;
import epic.constraints.SpanConstraints$Factory$class;
import epic.framework.Inference;
import epic.framework.Model;
import epic.framework.ModelObjective;
import epic.framework.ModelObjective$;
import epic.lexicon.Lexicon;
import epic.parser.GenerativeParser$;
import epic.parser.GrammarAnchoring;
import epic.parser.MaxConstituentDecoder;
import epic.parser.ParseMarginal;
import epic.parser.Parser;
import epic.parser.RuleTopology;
import epic.parser.models.LatentParserInference;
import epic.parser.models.SpanModel;
import epic.sentiment.SentimentEvaluator$;
import epic.sentiment.SentimentLossAugmentation;
import epic.sentiment.SentimentLossAugmentation$;
import epic.sentiment.SentimentTreebankPipeline;
import epic.sentiment.SentimentTreebankPipeline$DecodeType$;
import epic.trees.AnnotatedLabel;
import epic.trees.AnnotatedLabel$;
import epic.trees.BinarizedTree;
import epic.trees.Debinarizer$AnnotatedLabelDebinarizer$;
import epic.trees.ProcessedTreebank;
import epic.trees.ProcessedTreebank$;
import epic.trees.Span;
import epic.trees.Tree;
import epic.trees.TreeInstance;
import java.io.File;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class SentimentTreebankPipeline$
implements LazyLogging {
    public static final SentimentTreebankPipeline$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SentimentTreebankPipeline$();
    }

    private Logger logger$lzycompute() {
        SentimentTreebankPipeline$ sentimentTreebankPipeline$ = this;
        synchronized (sentimentTreebankPipeline$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void main(String[] args) {
        Object object;
        SentimentTreebankPipeline.Options params = (SentimentTreebankPipeline.Options)CommandLineParser$.MODULE$.readIn((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])args), CommandLineParser$.MODULE$.readIn$default$2(), CommandLineParser$.MODULE$.readIn$default$3(), CommandLineParser$.MODULE$.readIn$default$4(), CommandLineParser$.MODULE$.readIn$default$5(), CommandLineParser$.MODULE$.readIn$default$6(), ManifestFactory$.MODULE$.classType(SentimentTreebankPipeline.Options.class));
        File x$27 = params.path();
        int x$29 = ProcessedTreebank$.MODULE$.$lessinit$greater$default$2();
        boolean x$30 = ProcessedTreebank$.MODULE$.$lessinit$greater$default$3();
        String x$31 = ProcessedTreebank$.MODULE$.$lessinit$greater$default$4();
        int x$32 = ProcessedTreebank$.MODULE$.$lessinit$greater$default$6();
        boolean x$33 = ProcessedTreebank$.MODULE$.$lessinit$greater$default$7();
        boolean x$34 = ProcessedTreebank$.MODULE$.$lessinit$greater$default$8();
        String x$35 = ProcessedTreebank$.MODULE$.$lessinit$greater$default$9();
        String x$36 = ProcessedTreebank$.MODULE$.$lessinit$greater$default$10();
        ProcessedTreebank treebank = new ProcessedTreebank(x$27, x$29, x$30, x$31, "simple", x$32, x$33, x$34, x$35, x$36);
        ObjectRef trainTrees2 = ObjectRef.create(treebank.trainTrees());
        if (params.evalOnTest() && params.includeDevInTrain()) {
            trainTrees2.elem = (IndexedSeq)((IndexedSeq)trainTrees2.elem).$plus$plus(treebank.devTrees(), IndexedSeq$.MODULE$.canBuildFrom());
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append(((IndexedSeq)trainTrees2.elem).size()).append((Object)" train trees, ").append((Object)BoxesRunTime.boxToInteger((int)treebank.devTrees().size())).append((Object)" dev trees, ").append((Object)BoxesRunTime.boxToInteger((int)treebank.testTrees().size())).append((Object)" test trees").toString());
        Parser gen = GenerativeParser$.MODULE$.fromTrees((IndexedSeq)trainTrees2.elem, Debinarizer$AnnotatedLabelDebinarizer$.MODULE$);
        String string = params.lossType();
        if (string != null && string.equals("defaultLoss")) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(int gold, int guess) {
                    return SentimentLossAugmentation$.MODULE$.defaultLoss(gold, guess);
                }

                public double apply$mcDII$sp(int gold, int guess) {
                    return SentimentLossAugmentation$.MODULE$.defaultLoss(gold, guess);
                }
            };
        } else {
            String string2 = params.lossType();
            if (string2 != null && string2.equals("posNegLoss")) {
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int gold, int guess) {
                        return SentimentLossAugmentation$.MODULE$.posNegLoss(gold, guess);
                    }

                    public double apply$mcDII$sp(int gold, int guess) {
                        return SentimentLossAugmentation$.MODULE$.posNegLoss(gold, guess);
                    }
                };
            } else {
                String string3 = params.lossType();
                object = string3 != null && string3.equals("hammingLoss") ? new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int gold, int guess) {
                        return SentimentLossAugmentation$.MODULE$.hammingLoss(gold, guess);
                    }

                    public double apply$mcDII$sp(int gold, int guess) {
                        return SentimentLossAugmentation$.MODULE$.hammingLoss(gold, guess);
                    }
                } : new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int gold, int guess) {
                        return SentimentLossAugmentation$.MODULE$.noLoss(gold, guess);
                    }

                    public double apply$mcDII$sp(int gold, int guess) {
                        return SentimentLossAugmentation$.MODULE$.noLoss(gold, guess);
                    }
                };
            }
        }
        Serializable sentimentLoss = object;
        public class Epic_sentiment_SentimentTreebankPipeline$GoldBracketingsConstraints$1
        implements ChartConstraints.Factory<AnnotatedLabel, String> {
            private final Map<IndexedSeq<String>, BinarizedTree<AnnotatedLabel>> trees;
            public final Parser gen$1;

            public ChartConstraints.OrFactory<AnnotatedLabel, String> $bar(ChartConstraints.Factory<AnnotatedLabel, String> cf) {
                return ChartConstraints$Factory$class.$bar(this, cf);
            }

            public SpanConstraints get(IndexedSeq<String> h) {
                return SpanConstraints$Factory$class.get(this, h);
            }

            public SpanConstraints.UnionFactory<String> $bar(SpanConstraints.Factory<String> other) {
                return SpanConstraints$Factory$class.$bar(this, other);
            }

            public Map<IndexedSeq<String>, BinarizedTree<AnnotatedLabel>> trees() {
                return this.trees;
            }

            public ChartConstraints<AnnotatedLabel> constraints(IndexedSeq<String> w) {
                SpanConstraints constraints2 = SpanConstraints$.MODULE$.fromTree((BinarizedTree)this.trees().getOrElse(w, (Function0)new Serializable(this, w){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Epic_sentiment_SentimentTreebankPipeline$GoldBracketingsConstraints$1 $outer;
                    private final IndexedSeq w$1;

                    public final BinarizedTree<AnnotatedLabel> apply() {
                        return this.$outer.gen$1.bestBinarizedTree(this.w$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.w$1 = w$1;
                    }
                }));
                LabeledSpanConstraints.PromotedSpanConstraints cons = new LabeledSpanConstraints.PromotedSpanConstraints(constraints2);
                return new ChartConstraints<Object>(cons, cons);
            }

            public Epic_sentiment_SentimentTreebankPipeline$GoldBracketingsConstraints$1(ProcessedTreebank treebank$1, ObjectRef trainTrees$1, Parser gen$1) {
                this.gen$1 = gen$1;
                SpanConstraints$Factory$class.$init$(this);
                ChartConstraints$Factory$class.$init$(this);
                this.trees = ((TraversableOnce)((TraversableLike)((TraversableLike)((IndexedSeq)trainTrees$1.elem).$plus$plus(treebank$1.devTrees(), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus(treebank$1.testTrees(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<IndexedSeq<String>, BinarizedTree<AnnotatedLabel>> apply(TreeInstance<AnnotatedLabel, String> ti) {
                        BinarizedTree<AnnotatedLabel> binarizedTree = ti.tree();
                        Object object = Predef$.MODULE$.ArrowAssoc(ti.words());
                        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                        return new Tuple2(object, binarizedTree);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
        }
        new SentimentLossAugmentation<String>((IndexedSeq)trainTrees2.elem, gen.topology(), gen.lexicon(), new Epic_sentiment_SentimentTreebankPipeline$GoldBracketingsConstraints$1(treebank, trainTrees2, gen), (Function2<Object, Object, Object>)sentimentLoss, params.rootLossScaling());
        Model model = params.modelFactory().make((IndexedSeq)trainTrees2.elem, (RuleTopology)gen.topology(), gen.lexicon(), (ChartConstraints.Factory)new Epic_sentiment_SentimentTreebankPipeline$GoldBracketingsConstraints$1(treebank, trainTrees2, gen));
        ModelObjective obj = new ModelObjective(model, (IndexedSeq)trainTrees2.elem, ModelObjective$.MODULE$.$lessinit$greater$default$3());
        CachedBatchDiffFunction cachedObj = new CachedBatchDiffFunction(obj, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double()));
        DenseVector<Object> init = obj.initialWeightVector(true);
        Iterator itr = params.opt().iterations((BatchDiffFunction)cachedObj, init, DenseVector$.MODULE$.space_Double());
        String name = params.name();
        itr.take(params.maxIterations()).zipWithIndex().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<FirstOrderMinimizer.State<DenseVector<Object>, Object, Object>, Object> check$ifrefutable$1) {
                boolean bl = check$ifrefutable$1 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final SentimentTreebankPipeline.Options params$1;

            public final boolean apply(Tuple2<FirstOrderMinimizer.State<DenseVector<Object>, Object, Object>, Object> x$1) {
                if (x$1 != null) {
                    return x$1._2$mcI$sp() % this.params$1.iterationsPerEval() == 0;
                }
                throw new MatchError(x$1);
            }
            {
                this.params$1 = params$1;
            }
        }).foreach((Function1)new Serializable(params, treebank, trainTrees2, (SpanModel)model, name){
            public static final long serialVersionUID = 0L;
            private final SentimentTreebankPipeline.Options params$1;
            private final ProcessedTreebank treebank$1;
            private final ObjectRef trainTrees$1;
            private final SpanModel model$1;
            private final String name$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<FirstOrderMinimizer.State<DenseVector<Object>, Object, Object>, Object> x$2) {
                if (x$2 == null) throw new MatchError(x$2);
                try {
                    Parser<AnnotatedLabel, W> qual$1 = this.model$1.extractParser((DenseVector<Object>)((DenseVector)((FirstOrderMinimizer.State)x$2._1()).x()), Debinarizer$AnnotatedLabelDebinarizer$.MODULE$);
                    MaxConstituentDecoder<L, W> x$37 = new MaxConstituentDecoder<L, W>();
                    RuleTopology<AnnotatedLabel> x$38 = qual$1.copy$default$1();
                    Lexicon<AnnotatedLabel, W> x$39 = qual$1.copy$default$2();
                    ChartConstraints.Factory<AnnotatedLabel, W> x$40 = qual$1.copy$default$3();
                    ParseMarginal.Factory<AnnotatedLabel, W> x$41 = qual$1.copy$default$4();
                    Parser<AnnotatedLabel, String> parser = qual$1.copy(x$38, x$39, x$40, x$41, x$37, Debinarizer$AnnotatedLabelDebinarizer$.MODULE$);
                    if (this.params$1.computeTrainLL()) {
                        SentimentTreebankPipeline$.MODULE$.computeLL((IndexedSeq<TreeInstance<AnnotatedLabel, String>>)((IndexedSeq)this.trainTrees$1.elem), this.model$1, (DenseVector<Object>)((DenseVector)((FirstOrderMinimizer.State)x$2._1()).x()));
                    }
                    if (this.params$1.evalOnTest()) {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"NORMAL DECODE: Eval: ").append((Object)SentimentTreebankPipeline$.MODULE$.evaluate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp())})), parser, this.treebank$1.testTrees(), SentimentTreebankPipeline$DecodeType$.MODULE$.Normal())).toString());
                        return;
                    } else {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"NORMAL DECODE: Eval: ").append((Object)SentimentTreebankPipeline$.MODULE$.evaluate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp())})), parser, this.treebank$1.devTrees(), SentimentTreebankPipeline$DecodeType$.MODULE$.Normal())).toString());
                        if (!this.params$1.alsoEvalOnTest()) return;
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"TEST SET: Eval: ").append((Object)SentimentTreebankPipeline$.MODULE$.evaluate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp())})), parser, this.treebank$1.testTrees(), SentimentTreebankPipeline$DecodeType$.MODULE$.Normal())).toString());
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            {
                this.params$1 = params$1;
                this.treebank$1 = treebank$1;
                this.trainTrees$1 = trainTrees$1;
                this.model$1 = model$1;
                this.name$1 = name$1;
            }
        });
    }

    public String renderArr(int[][] arr) {
        return (String)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arr).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int[] x$3) {
                return (String)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(x$3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int x$4) {
                        return ((Object)BoxesRunTime.boxToInteger((int)x$4)).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$5, String x$6) {
                        return new StringBuilder().append((Object)x$5).append((Object)"\t").append((Object)x$6).toString();
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$7, String x$8) {
                return new StringBuilder().append((Object)x$7).append((Object)"\n").append((Object)x$8).toString();
            }
        });
    }

    public int[][] evaluateSpanConfusions(String name, Parser<AnnotatedLabel, String> parser, IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees, Enumeration.Value decodeType) {
        return (int[][])((ParIterableLike)((ParIterableLike)testTrees.par()).map((Function1)new Serializable(parser, decodeType){
            public static final long serialVersionUID = 0L;
            private final Parser parser$2;
            private final Enumeration.Value decodeType$3;

            /*
             * WARNING - void declaration
             */
            public final int[][] apply(TreeInstance<AnnotatedLabel, String> ti) {
                void var2_2;
                int[][] spanConfusions = (int[][])Array$.MODULE$.tabulate(5, 5, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int i, int j) {
                        return 0;
                    }

                    public int apply$mcIII$sp(int i, int j) {
                        return 0;
                    }
                }, ClassTag$.MODULE$.Int());
                Tree<M> goldTree = ((Tree)ti.tree().children().head()).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(AnnotatedLabel x$10) {
                        String string = x$10.label();
                        Predef$ predef$ = Predef$.MODULE$;
                        return new StringOps(string).toInt();
                    }
                });
                ParseMarginal<AnnotatedLabel, String> marg = this.parser$2.marginal(ti.words());
                BinarizedTree<M> guessTree = SentimentTreebankPipeline$.MODULE$.decode(ti.tree().map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(AnnotatedLabel x$11) {
                    }
                }), marg, this.decodeType$3).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(AnnotatedLabel x$12) {
                        String string = x$12.label();
                        Predef$ predef$ = Predef$.MODULE$;
                        return new StringOps(string).toInt();
                    }
                });
                Set guess = guessTree.preorder().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Span> apply(Tree<Object> t) {
                        return new Tuple2(t.label(), (Object)new Span(t.span()));
                    }
                }).toSet();
                HashMap guessMap = (HashMap)new HashMap().$plus$plus((GenTraversableOnce)guess.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Span, Object> apply(Tuple2<Object, Span> x$13) {
                        return x$13.swap();
                    }
                }, Set$.MODULE$.canBuildFrom()), HashMap$.MODULE$.canBuildFrom());
                Set gold = goldTree.preorder().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Span> apply(Tree<Object> t) {
                        return new Tuple2(t.label(), (Object)new Span(t.span()));
                    }
                }).toSet();
                gold.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Span> check$ifrefutable$2) {
                        boolean bl = check$ifrefutable$2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, spanConfusions, guessMap){
                    public static final long serialVersionUID = 0L;
                    private final int[][] spanConfusions$1;
                    private final HashMap guessMap$2;

                    public final void apply(Tuple2<Object, Span> x$14) {
                        if (x$14 != null) {
                            int pLabel = BoxesRunTime.unboxToInt((Object)this.guessMap$2.apply(x$14._2()));
                            int[] nArray = this.spanConfusions$1[x$14._1$mcI$sp()];
                            nArray[pLabel] = nArray[pLabel] + 1;
                            return;
                        }
                        throw new MatchError(x$14);
                    }
                    {
                        this.spanConfusions$1 = spanConfusions$1;
                        this.guessMap$2 = guessMap$2;
                    }
                });
                return var2_2;
            }
            {
                this.parser$2 = parser$2;
                this.decodeType$3 = decodeType$3;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int[][] apply(int[][] arr1, int[][] arr2) {
                return (int[][])Array$.MODULE$.tabulate(5, 5, (Function2)new Serializable(this, arr1, arr2){
                    public static final long serialVersionUID = 0L;
                    private final int[][] arr1$1;
                    private final int[][] arr2$1;

                    public final int apply(int i, int j) {
                        return this.apply$mcIII$sp(i, j);
                    }

                    public int apply$mcIII$sp(int i, int j) {
                        return this.arr1$1[i][j] + this.arr2$1[i][j];
                    }
                    {
                        this.arr1$1 = arr1$1;
                        this.arr2$1 = arr2$1;
                    }
                }, ClassTag$.MODULE$.Int());
            }
        });
    }

    public int[][] evaluateRootConfusions(String name, Parser<AnnotatedLabel, String> parser, IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees, Enumeration.Value decodeType) {
        return (int[][])((ParIterableLike)((ParIterableLike)testTrees.par()).map((Function1)new Serializable(parser, decodeType){
            public static final long serialVersionUID = 0L;
            private final Parser parser$3;
            private final Enumeration.Value decodeType$4;

            /*
             * WARNING - void declaration
             */
            public final int[][] apply(TreeInstance<AnnotatedLabel, String> ti) {
                void var2_2;
                int[][] rootConfusions = (int[][])Array$.MODULE$.tabulate(5, 5, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int i, int j) {
                        return 0;
                    }

                    public int apply$mcIII$sp(int i, int j) {
                        return 0;
                    }
                }, ClassTag$.MODULE$.Int());
                Tree<M> goldTree = ((Tree)ti.tree().children().head()).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(AnnotatedLabel x$15) {
                        String string = x$15.label();
                        Predef$ predef$ = Predef$.MODULE$;
                        return new StringOps(string).toInt();
                    }
                });
                ParseMarginal<AnnotatedLabel, String> marg = this.parser$3.marginal(ti.words());
                BinarizedTree<M> guessTree = SentimentTreebankPipeline$.MODULE$.decode(ti.tree().map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(AnnotatedLabel x$16) {
                    }
                }), marg, this.decodeType$4).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(AnnotatedLabel x$17) {
                        String string = x$17.label();
                        Predef$ predef$ = Predef$.MODULE$;
                        return new StringOps(string).toInt();
                    }
                });
                int[] nArray = rootConfusions[BoxesRunTime.unboxToInt(goldTree.label())];
                int n = BoxesRunTime.unboxToInt(guessTree.label());
                nArray[n] = nArray[n] + 1;
                return var2_2;
            }
            {
                this.parser$3 = parser$3;
                this.decodeType$4 = decodeType$4;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int[][] apply(int[][] arr1, int[][] arr2) {
                return (int[][])Array$.MODULE$.tabulate(5, 5, (Function2)new Serializable(this, arr1, arr2){
                    public static final long serialVersionUID = 0L;
                    private final int[][] arr1$2;
                    private final int[][] arr2$2;

                    public final int apply(int i, int j) {
                        return this.apply$mcIII$sp(i, j);
                    }

                    public int apply$mcIII$sp(int i, int j) {
                        return this.arr1$2[i][j] + this.arr2$2[i][j];
                    }
                    {
                        this.arr1$2 = arr1$2;
                        this.arr2$2 = arr2$2;
                    }
                }, ClassTag$.MODULE$.Int());
            }
        });
    }

    public SentimentTreebankPipeline.Stats evaluate(String name, Parser<AnnotatedLabel, String> parser, IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees, Enumeration.Value decodeType) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Evaluating at ").append((Object)name).toString());
        return (SentimentTreebankPipeline.Stats)((ParIterableLike)((ParIterableLike)testTrees.par()).map((Function1)new Serializable(parser, decodeType){
            public static final long serialVersionUID = 0L;
            private final Parser parser$1;
            private final Enumeration.Value decodeType$1;

            public final SentimentTreebankPipeline.Stats apply(TreeInstance<AnnotatedLabel, String> ti) {
                Tree<M> goldTree = ((Tree)ti.tree().children().head()).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(AnnotatedLabel x$18) {
                        String string = x$18.label();
                        Predef$ predef$ = Predef$.MODULE$;
                        return new StringOps(string).toInt();
                    }
                });
                int goldRoot = BoxesRunTime.unboxToInt(goldTree.label());
                ParseMarginal<AnnotatedLabel, String> marg = this.parser$1.marginal(ti.words());
                BinarizedTree<M> guessTree = SentimentTreebankPipeline$.MODULE$.decode(ti.tree().map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(AnnotatedLabel x$19) {
                    }
                }), marg, this.decodeType$1).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(AnnotatedLabel x$20) {
                        String string = x$20.label();
                        Predef$ predef$ = Predef$.MODULE$;
                        return new StringOps(string).toInt();
                    }
                });
                int guessRoot = BoxesRunTime.unboxToInt(guessTree.label());
                Set guess = guessTree.preorder().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Span> apply(Tree<Object> t) {
                        return new Tuple2(t.label(), (Object)new Span(t.span()));
                    }
                }).toSet();
                HashMap guessMap = (HashMap)new HashMap().$plus$plus((GenTraversableOnce)guess.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Span, Object> apply(Tuple2<Object, Span> pair) {
                        return new Tuple2(pair._2(), (Object)BoxesRunTime.boxToInteger((int)pair._1$mcI$sp()));
                    }
                }, Set$.MODULE$.canBuildFrom()), HashMap$.MODULE$.canBuildFrom());
                Set gold = goldTree.preorder().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Span> apply(Tree<Object> t) {
                        return new Tuple2(t.label(), (Object)new Span(t.span()));
                    }
                }).toSet();
                IntRef spansRight = IntRef.create((int)0);
                IntRef numSpans = IntRef.create((int)0);
                IntRef spansRightTernary = IntRef.create((int)0);
                IntRef spansRightBinary = IntRef.create((int)0);
                IntRef numBinarySpans = IntRef.create((int)0);
                gold.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Span> check$ifrefutable$3) {
                        boolean bl = check$ifrefutable$3 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, guessMap, spansRight, numSpans, spansRightTernary, spansRightBinary, numBinarySpans){
                    public static final long serialVersionUID = 0L;
                    private final HashMap guessMap$1;
                    private final IntRef spansRight$1;
                    private final IntRef numSpans$1;
                    private final IntRef spansRightTernary$1;
                    private final IntRef spansRightBinary$1;
                    private final IntRef numBinarySpans$1;

                    public final void apply(Tuple2<Object, Span> x$21) {
                        if (x$21 != null) {
                            int pLabel = BoxesRunTime.unboxToInt((Object)this.guessMap$1.apply(x$21._2()));
                            this.spansRight$1.elem = this.spansRight$1.elem + (SentimentEvaluator$.MODULE$.isCorrectNormal(x$21._1$mcI$sp(), pLabel) ? 1 : 0);
                            ++this.numSpans$1.elem;
                            this.spansRightTernary$1.elem = this.spansRightTernary$1.elem + (SentimentEvaluator$.MODULE$.isCorrectTernary(x$21._1$mcI$sp(), pLabel) ? 1 : 0);
                            this.spansRightBinary$1.elem = this.spansRightBinary$1.elem + (SentimentEvaluator$.MODULE$.isUsedBinaryCoarse(x$21._1$mcI$sp(), pLabel) && SentimentEvaluator$.MODULE$.isCorrectBinary(x$21._1$mcI$sp(), pLabel) ? 1 : 0);
                            this.numBinarySpans$1.elem = this.numBinarySpans$1.elem + (SentimentEvaluator$.MODULE$.isUsedBinaryCoarse(x$21._1$mcI$sp(), pLabel) ? 1 : 0);
                            return;
                        }
                        throw new MatchError(x$21);
                    }
                    {
                        this.guessMap$1 = guessMap$1;
                        this.spansRight$1 = spansRight$1;
                        this.numSpans$1 = numSpans$1;
                        this.spansRightTernary$1 = spansRightTernary$1;
                        this.spansRightBinary$1 = spansRightBinary$1;
                        this.numBinarySpans$1 = numBinarySpans$1;
                    }
                });
                int rootsRight = SentimentEvaluator$.MODULE$.isCorrectNormal(goldRoot, guessRoot) ? 1 : 0;
                int rootsRightTernary = SentimentEvaluator$.MODULE$.isCorrectTernary(goldRoot, guessRoot) ? 1 : 0;
                int rootsRightBinary = SentimentEvaluator$.MODULE$.isUsedBinaryCoarse(goldRoot, guessRoot) && SentimentEvaluator$.MODULE$.isCorrectBinary(goldRoot, guessRoot) ? 1 : 0;
                int numBinaryRoots = SentimentEvaluator$.MODULE$.isUsedBinaryCoarse(goldRoot, guessRoot) ? 1 : 0;
                return new SentimentTreebankPipeline.Stats(spansRight.elem, numSpans.elem, spansRightTernary.elem, spansRightBinary.elem, numBinarySpans.elem, rootsRight, 1, rootsRightTernary, rootsRightBinary, numBinaryRoots);
            }
            {
                this.parser$1 = parser$1;
                this.decodeType$1 = decodeType$1;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SentimentTreebankPipeline.Stats apply(SentimentTreebankPipeline.Stats x$22, SentimentTreebankPipeline.Stats x$23) {
                return x$22.$plus(x$23);
            }
        });
    }

    public BinarizedTree<AnnotatedLabel> decode(BinarizedTree<BoxedUnit> tree, ParseMarginal<AnnotatedLabel, String> marginal2, Enumeration.Value decodeType) {
        Tuple2<TriangularArray<Counter<AnnotatedLabel, Object>>, TriangularArray<Counter<AnnotatedLabel, Object>>> tuple2 = marginal2.labelMarginals();
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            TriangularArray topMarg = (TriangularArray)tuple22._1();
            TriangularArray botMarg = (TriangularArray)tuple22._2();
            return tree.extend(new Serializable(tree, decodeType, topMarg, botMarg){
                public static final long serialVersionUID = 0L;
                private final BinarizedTree tree$1;
                private final Enumeration.Value decodeType$2;
                private final TriangularArray topMarg$1;
                private final TriangularArray botMarg$1;

                public final AnnotatedLabel apply(Tree<BoxedUnit> t) {
                    AnnotatedLabel annotatedLabel;
                    Counter counter;
                    if (t.begin() == 0 && t.end() == this.tree$1.end()) {
                        int n = t.end();
                        int n2 = t.begin();
                        TriangularArray triangularArray = this.botMarg$1;
                        Object object = triangularArray.data();
                        TriangularArray$ triangularArray$ = TriangularArray$.MODULE$;
                        if (n2 > n) {
                            TriangularArray$.anonfun.index.1 var6_6 = new TriangularArray$.anonfun.index.1();
                            boolean bl = n2 <= n;
                            Predef$ predef$ = Predef$.MODULE$;
                            if (!bl) {
                                throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append(var6_6.apply()).toString());
                            }
                        }
                        counter = (Counter)ScalaRunTime$.MODULE$.array_apply(object, n * (n + 1) / 2 + n2);
                    } else {
                        int n = t.end();
                        int n3 = t.begin();
                        TriangularArray triangularArray = this.topMarg$1;
                        Object object = triangularArray.data();
                        TriangularArray$ triangularArray$ = TriangularArray$.MODULE$;
                        if (n3 > n) {
                            TriangularArray$.anonfun.index.1 var13_13 = new TriangularArray$.anonfun.index.1();
                            boolean bl = n3 <= n;
                            Predef$ predef$ = Predef$.MODULE$;
                            if (!bl) {
                                throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append(var13_13.apply()).toString());
                            }
                        }
                        counter = (Counter)ScalaRunTime$.MODULE$.array_apply(object, n * (n + 1) / 2 + n3);
                    }
                    Counter summed = counter;
                    Enumeration.Value value = this.decodeType$2;
                    Enumeration.Value value2 = SentimentTreebankPipeline$DecodeType$.MODULE$.Binary();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        double pos;
                        double neg = BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("0"))) + BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("1")));
                        annotatedLabel = neg > (pos = BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("3"))) + BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("4")))) ? AnnotatedLabel$.MODULE$.apply("0") : AnnotatedLabel$.MODULE$.apply("4");
                    } else {
                        Enumeration.Value value3 = this.decodeType$2;
                        Enumeration.Value value4 = SentimentTreebankPipeline$DecodeType$.MODULE$.Ternary();
                        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                            double neg = BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("0"))) + BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("1")));
                            double pos = BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("3"))) + BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("4")));
                            double neutral = BoxesRunTime.unboxToDouble((Object)summed.apply((Object)AnnotatedLabel$.MODULE$.apply("2")));
                            annotatedLabel = neg > pos && neg > neutral ? AnnotatedLabel$.MODULE$.apply("0") : (pos > neg && pos > neutral ? AnnotatedLabel$.MODULE$.apply("4") : AnnotatedLabel$.MODULE$.apply("2"));
                        } else {
                            annotatedLabel = (AnnotatedLabel)summed.argmax((Ordering)Ordering.Double$.MODULE$);
                        }
                    }
                    return annotatedLabel;
                }
                {
                    this.tree$1 = tree$1;
                    this.decodeType$2 = decodeType$2;
                    this.topMarg$1 = topMarg$1;
                    this.botMarg$1 = botMarg$1;
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public void computeLL(IndexedSeq<TreeInstance<AnnotatedLabel, String>> trainTrees2, SpanModel<AnnotatedLabel, AnnotatedLabel, String> model, DenseVector<Object> weights) {
        Predef$.MODULE$.println((Object)"Computing final log likelihood on the whole training set...");
        Inference inf = model.inferenceFromWeights((DenseVector)weights);
        double ll = BoxesRunTime.unboxToDouble((Object)((ParIterableLike)trainTrees2.par()).aggregate((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return 0.0;
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, (Function2)new Serializable((LatentParserInference)inf){
            public static final long serialVersionUID = 0L;
            private final LatentParserInference inf$1;

            public final double apply(double currLL, TreeInstance<AnnotatedLabel, String> trainTree) {
                double d;
                try {
                    GrammarAnchoring<AnnotatedLabel, String> s = this.inf$1.scorer(trainTree);
                    d = currLL + ((ParseMarginal)this.inf$1.goldMarginal((Object)s, trainTree)).logPartition() - ((ParseMarginal)this.inf$1.marginal((Object)s, trainTree)).logPartition();
                }
                catch (Exception exception) {
                    Predef$.MODULE$.println((Object)"Couldn't parse");
                    d = currLL;
                }
                return d;
            }
            {
                this.inf$1 = inf$1;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$25, double x$26) {
                return x$25 + x$26;
            }

            public double apply$mcDDD$sp(double x$25, double x$26) {
                return x$25 + x$26;
            }
        }));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Log likelihood on ").append((Object)BoxesRunTime.boxToInteger((int)trainTrees2.size())).append((Object)" examples: ").append((Object)BoxesRunTime.boxToDouble((double)ll)).toString());
    }

    private SentimentTreebankPipeline$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

