/*
 * Decompiled with CFR 0.152.
 */
package epic.sequences;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import epic.sequences.Segmentation;
import epic.sequences.SegmentationEval;
import epic.sequences.SemiCRF;
import epic.trees.Span;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SegmentationEval$
implements LazyLogging {
    public static final SegmentationEval$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SegmentationEval$();
    }

    private Logger logger$lzycompute() {
        SegmentationEval$ segmentationEval$ = this;
        synchronized (segmentationEval$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <L, W> SegmentationEval.Stats eval(SemiCRF<L, W> crf, IndexedSeq<Segmentation<L, W>> examples, boolean logOnlyErrors) {
        return (SegmentationEval.Stats)((ParIterableLike)examples.par()).aggregate((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SegmentationEval.Stats apply() {
                return new SegmentationEval.Stats(0, 0, 0);
            }
        }, (Function2)new Serializable(crf, logOnlyErrors){
            public static final long serialVersionUID = 0L;
            private final SemiCRF crf$1;
            private final boolean logOnlyErrors$1;

            public final SegmentationEval.Stats apply(SegmentationEval.Stats stats, Segmentation<L, W> gold) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                Segmentation<L, W> guess = this.crf$1.bestSequence(gold.words(), new StringBuilder().append((Object)gold.id()).append((Object)"-guess").toString());
                try {
                    IndexedSeq<Tuple2<L, Span>> indexedSeq = guess.label();
                    IndexedSeq<Tuple2<L, Span>> indexedSeq2 = gold.label();
                    if (!(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null)) {
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (SegmentationEval$.MODULE$.logger().underlying().isTraceEnabled()) {
                        SegmentationEval$.MODULE$.logger().underlying().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gold = ", " guess = ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gold, guess}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"guess logPartition = ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.crf$1.goldMarginal(guess.segments(), guess.words()).logPartition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gold logPartition =", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.crf$1.goldMarginal(gold.segments(), gold.words()).logPartition())}))).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                }
                catch (Exception exception) {
                    if (SegmentationEval$.MODULE$.logger().underlying().isDebugEnabled()) {
                        SegmentationEval$.MODULE$.logger().underlying().debug(new StringBuilder().append((Object)"Can't recover gold for ").append(gold).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                SegmentationEval.Stats myStats = SegmentationEval$.MODULE$.evaluateExample((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), guess, gold);
                if (this.logOnlyErrors$1 && !(myStats.f1() < 1.0)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else if (SegmentationEval$.MODULE$.logger().underlying().isInfoEnabled()) {
                    SegmentationEval$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"Guess:\n").append((Object)guess.render()).append((Object)"\n Gold:\n").append((Object)gold.render()).append((Object)"\n").append((Object)myStats).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return stats.$plus(myStats);
            }
            {
                this.crf$1 = crf$1;
                this.logOnlyErrors$1 = logOnlyErrors$1;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SegmentationEval.Stats apply(SegmentationEval.Stats x$1, SegmentationEval.Stats x$2) {
                return x$1.$plus(x$2);
            }
        });
    }

    public <L, W> boolean eval$default$3() {
        return true;
    }

    public <W, L> SegmentationEval.Stats evaluateExample(Set<L> outsideLabel, Segmentation<L, W> guess, Segmentation<L, W> gold) {
        Set guessSet = ((TraversableOnce)guess.segments().filter((Function1)new Serializable(outsideLabel){
            public static final long serialVersionUID = 0L;
            private final Set outsideLabel$1;

            public final boolean apply(Tuple2<L, Span> a) {
                return !this.outsideLabel$1.apply(a._1());
            }
            {
                this.outsideLabel$1 = outsideLabel$1;
            }
        })).toSet();
        Set goldSet = ((TraversableOnce)gold.segments().filter((Function1)new Serializable(outsideLabel){
            public static final long serialVersionUID = 0L;
            private final Set outsideLabel$1;

            public final boolean apply(Tuple2<L, Span> a) {
                return !this.outsideLabel$1.apply(a._1());
            }
            {
                this.outsideLabel$1 = outsideLabel$1;
            }
        })).toSet();
        int nRight = ((TraversableOnce)guessSet.$amp((GenSet)goldSet)).size();
        SegmentationEval.Stats myStats = new SegmentationEval.Stats(nRight, guessSet.size(), goldSet.size());
        return myStats;
    }

    private SegmentationEval$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

