/*
 * Decompiled with CFR 0.152.
 */
package epic.trees;

import breeze.config.Help;
import epic.trees.AnnotatedLabel;
import epic.trees.AnnotatedLabel$;
import epic.trees.BinarizedTree;
import epic.trees.HeadFinder;
import epic.trees.HeadFinder$;
import epic.trees.ProcessedTreebank$;
import epic.trees.SimpleTreebank;
import epic.trees.SimpleTreebank$;
import epic.trees.StandardTreeProcessor;
import epic.trees.StandardTreeProcessor$;
import epic.trees.SupervisedHeadFinder$;
import epic.trees.Tree;
import epic.trees.TreeInstance;
import epic.trees.Treebank;
import epic.trees.Treebank$;
import epic.trees.UnaryChainCollapser$;
import epic.util.ArabicNormalization$;
import java.io.File;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple10;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Help(text="Parameters for reading and processing a treebank.")
@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u0001\u0003\u0001\u001e\u0011\u0011\u0003\u0015:pG\u0016\u001c8/\u001a3Ue\u0016,'-\u00198l\u0015\t\u0019A!A\u0003ue\u0016,7OC\u0001\u0006\u0003\u0011)\u0007/[2\u0004\u0001M!\u0001\u0001\u0003\b\u0012!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011\u0011bD\u0005\u0003!)\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\n%%\u00111C\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t+\u0001\u0011)\u001a!C\u0001-\u0005!\u0001/\u0019;i+\u00059\u0002C\u0001\r\u001e\u001b\u0005I\"B\u0001\u000e\u001c\u0003\tIwNC\u0001\u001d\u0003\u0011Q\u0017M^1\n\u0005yI\"\u0001\u0002$jY\u0016D\u0001\u0002\t\u0001\u0003\u0012\u0003\u0006IaF\u0001\u0006a\u0006$\b\u000e\t\u0005\tE\u0001\u0011)\u001a!C\u0001G\u0005IQ.\u0019=MK:<G\u000f[\u000b\u0002IA\u0011\u0011\"J\u0005\u0003M)\u00111!\u00138u\u0011!A\u0003A!E!\u0002\u0013!\u0013AC7bq2+gn\u001a;iA!A!\u0006\u0001BK\u0002\u0013\u00051&A\tj]\u000edW\u000fZ3EKZLe\u000e\u0016:bS:,\u0012\u0001\f\t\u0003\u00135J!A\f\u0006\u0003\u000f\t{w\u000e\\3b]\"A\u0001\u0007\u0001B\tB\u0003%A&\u0001\nj]\u000edW\u000fZ3EKZLe\u000e\u0016:bS:\u0004\u0003\u0002\u0003\u001a\u0001\u0005+\u0007I\u0011A\u001a\u0002\u0019\tLg.\u0019:ju\u0006$\u0018n\u001c8\u0016\u0003Q\u0002\"!\u000e\u001d\u000f\u0005%1\u0014BA\u001c\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]R\u0001\u0002\u0003\u001f\u0001\u0005#\u0005\u000b\u0011\u0002\u001b\u0002\u001b\tLg.\u0019:ju\u0006$\u0018n\u001c8!\u0011!q\u0004A!f\u0001\n\u0003\u0019\u0014\u0001\u0004;sK\u0016\u0014\u0017M\\6UsB,\u0007\u0002\u0003!\u0001\u0005#\u0005\u000b\u0011\u0002\u001b\u0002\u001bQ\u0014X-\u001a2b].$\u0016\u0010]3!\u0011!\u0011\u0005A!f\u0001\n\u0003\u0019\u0013\u0001\u00048v[N+g\u000e^3oG\u0016\u001c\b\u0002\u0003#\u0001\u0005#\u0005\u000b\u0011\u0002\u0013\u0002\u001b9,XnU3oi\u0016t7-Z:!\u0011!1\u0005A!f\u0001\n\u0003Y\u0013\u0001G6fKB,f.\u0019:z\u0007\"\f\u0017N\\:Ge>lGK]1j]\"A\u0001\n\u0001B\tB\u0003%A&A\rlK\u0016\u0004XK\\1ss\u000eC\u0017-\u001b8t\rJ|W\u000e\u0016:bS:\u0004\u0003\u0002\u0003&\u0001\u0005+\u0007I\u0011A\u0016\u0002\u001f\u0011,'-^2lo\u0006dG/\u001a:ju\u0016D\u0001\u0002\u0014\u0001\u0003\u0012\u0003\u0006I\u0001L\u0001\u0011I\u0016\u0014WoY6xC2$XM]5{K\u0002B\u0001B\u0014\u0001\u0003\u0016\u0004%\taM\u0001\u001cgV\u0004XM\u001d<jg\u0016$\u0007*Z1e\r&tG-\u001a:Qi\n\u0004\u0016\r\u001e5\t\u0011A\u0003!\u0011#Q\u0001\nQ\nAd];qKJ4\u0018n]3e\u0011\u0016\fGMR5oI\u0016\u0014\b\u000b\u001e2QCRD\u0007\u0005\u0003\u0005S\u0001\tU\r\u0011\"\u00014\u0003u\u0019X\u000f]3sm&\u001cX\r\u001a%fC\u00124\u0015N\u001c3fe\u000e{g\u000e\u001c7QCRD\u0007\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011\u0002\u001b\u0002=M,\b/\u001a:wSN,G\rS3bI\u001aKg\u000eZ3s\u0007>tG\u000e\u001c)bi\"\u0004\u0003\"\u0002,\u0001\t\u00039\u0016A\u0002\u001fj]&$h\bF\u0006Y5\u001e\\wn\u001d;vm^D\bCA-\u0001\u001b\u0005\u0011\u0001\"B\u000bV\u0001\u00049\u0002\u0006\u0002.]I\u0016\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\r\r|gNZ5h\u0015\u0005\t\u0017A\u00022sK\u0016TX-\u0003\u0002d=\n!\u0001*\u001a7q\u0003\u0011!X\r\u001f;\"\u0003\u0019\f!\u0005T8dCRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011ue\u0016,'-\u00198lA\u0011L'/Z2u_JL\bb\u0002\u0012V!\u0003\u0005\r\u0001\n\u0015\u0005Or#\u0017.I\u0001k\u0003\u0005j\u0015\r\u001f\u0011mK:<G\u000f\u001b\u0011g_J\u0004CO]1j]&tw\rI:f]R,gnY3t\u0011\u001dQS\u000b%AA\u00021BCa\u001b/e[\u0006\na.\u0001#TQ>,H\u000e\u001a\u0011xK\u0002\nG\r\u001a\u0011uQ\u0016\u0004C-\u001a<!g\u0016$\bEZ8sAQ\u0014\u0018-\u001b8j]\u001ed\u0003\u0005Z8!i\"L7\u000fI8oYf\u0004cm\u001c:!M&t\u0017\r\u001c\u0011uKN$h\u0006C\u00043+B\u0005\t\u0019\u0001\u001b)\t=dF-]\u0011\u0002e\u0006Qu\u000b[1uA-Lg\u000e\u001a\u0011pM\u0002\u0012\u0017N\\1sSj\fG/[8oAQ|\u0007\u0005Z8/A=\u0003H/[8ogj\u0002C.\u001a4uY\u0001\u0012\u0018n\u001a5uY\u0001BW-\u00193/A!+\u0017\r\u001a\u0011jg\u0002\u0012Wm\u001d;/\u0011\u001dqT\u000b%AA\u0002QBqAQ+\u0011\u0002\u0003\u0007A\u0005C\u0004G+B\u0005\t\u0019\u0001\u0017\t\u000f)+\u0006\u0013!a\u0001Y!9a*\u0016I\u0001\u0002\u0004!\u0004b\u0002*V!\u0003\u0005\r\u0001\u000e\u0005\tu\u0002A)\u0019!C\u0001w\u0006AAO]3fE\u0006t7.F\u0001}!\rIV\u0010N\u0005\u0003}\n\u0011\u0001\u0002\u0016:fK\n\fgn\u001b\u0005\n\u0003\u0003\u0001\u0001\u0012!Q!\nq\f\u0011\u0002\u001e:fK\n\fgn\u001b\u0011\t\u0015\u0005\u0015\u0001\u0001#b\u0001\n\u0003\t9!\u0001\u0006ue\u0006Lg\u000e\u0016:fKN,\"!!\u0003\u0011\r\u0005-\u00111DA\u0011\u001d\u0011\ti!a\u0006\u000f\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005\u0007\u0003\u0019a$o\\8u}%\t1\"C\u0002\u0002\u001a)\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0005}!AC%oI\u0016DX\rZ*fc*\u0019\u0011\u0011\u0004\u0006\u0011\re\u000b\u0019#a\n5\u0013\r\t)C\u0001\u0002\r)J,W-\u00138ti\u0006t7-\u001a\t\u00043\u0006%\u0012bAA\u0016\u0005\tq\u0011I\u001c8pi\u0006$X\r\u001a'bE\u0016d\u0007BCA\u0018\u0001!\u0005\t\u0015)\u0003\u0002\n\u0005YAO]1j]R\u0013X-Z:!\u0011)\t\u0019\u0004\u0001EC\u0002\u0013\u0005\u0011qA\u0001\tI\u00164HK]3fg\"Q\u0011q\u0007\u0001\t\u0002\u0003\u0006K!!\u0003\u0002\u0013\u0011,g\u000f\u0016:fKN\u0004\u0003BCA\u001e\u0001!\u0015\r\u0011\"\u0001\u0002\b\u0005IA/Z:u)J,Wm\u001d\u0005\u000b\u0003\u007f\u0001\u0001\u0012!Q!\n\u0005%\u0011A\u0003;fgR$&/Z3tA!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013A\u0004;sC:\u001chm\u001c:n)J,Wm\u001d\u000b\t\u0003\u0013\t9%!\u0016\u0002Z!A\u0011\u0011JA!\u0001\u0004\tY%A\u0004q_J$\u0018n\u001c8\u0011\t\u00055\u0013\u0011\u000b\b\u0004\u0003\u001fJX\"\u0001\u0001\n\u0007\u0005MSPA\u0004Q_J$\u0018n\u001c8\t\u000f\u0005]\u0013\u0011\ta\u0001I\u0005!Q.\u0019=M\u0011%\tY&!\u0011\u0011\u0002\u0003\u0007A&A\bd_2d\u0017\r]:f+:\f'/[3t\u0011\u001d\ty\u0006\u0001C\u0001\u0003C\n\u0001#\\1lKR\u0013X-Z%ogR\fgnY3\u0015\u0015\u0005\u0005\u00121MA4\u0003c\n9\bC\u0004\u0002f\u0005u\u0003\u0019\u0001\u001b\u0002\t9\fW.\u001a\u0005\t\u0003S\ni\u00061\u0001\u0002l\u0005!AO]3f!\u0011I\u0016Q\u000e\u001b\n\u0007\u0005=$A\u0001\u0003Ue\u0016,\u0007\u0002CA:\u0003;\u0002\r!!\u001e\u0002\u000b]|'\u000fZ:\u0011\u000b\u0005-\u00111\u0004\u001b\t\u000f\u0005m\u0013Q\fa\u0001Y!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014!\u00035fC\u0012\u0014V\u000f\\3t+\t\ty\b\u0005\u0003Z\u0003\u0003#\u0014bAAB\u0005\tQ\u0001*Z1e\r&tG-\u001a:\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005%\u0015a\u00029s_\u000e,7o]\u000b\u0003\u0003\u0017\u00032!WAG\u0013\r\tyI\u0001\u0002\u0016'R\fg\u000eZ1sIR\u0013X-\u001a)s_\u000e,7o]8s\u0011!\t\u0019\n\u0001Q\u0001\n\u0005-\u0015\u0001\u00039s_\u000e,7o\u001d\u0011\t\u0013\u0005]\u0005!!A\u0005\u0002\u0005e\u0015\u0001B2paf$R\u0003WAN\u0003;\u000by*!)\u0002$\u0006\u0015\u0016qUAU\u0003W\u000bi\u000b\u0003\u0005\u0016\u0003+\u0003\n\u00111\u0001\u0018\u0011!\u0011\u0013Q\u0013I\u0001\u0002\u0004!\u0003\u0002\u0003\u0016\u0002\u0016B\u0005\t\u0019\u0001\u0017\t\u0011I\n)\n%AA\u0002QB\u0001BPAK!\u0003\u0005\r\u0001\u000e\u0005\t\u0005\u0006U\u0005\u0013!a\u0001I!Aa)!&\u0011\u0002\u0003\u0007A\u0006\u0003\u0005K\u0003+\u0003\n\u00111\u0001-\u0011!q\u0015Q\u0013I\u0001\u0002\u0004!\u0004\u0002\u0003*\u0002\u0016B\u0005\t\u0019\u0001\u001b\t\u0013\u0005E\u0006!%A\u0005\u0002\u0005M\u0016\u0001\u0007;sC:\u001chm\u001c:n)J,Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0017\u0016\u0004Y\u0005]6FAA]!\u0011\tY,!2\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r'\"\u0001\u0006b]:|G/\u0019;j_:LA!a2\u0002>\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005-\u0007!%A\u0005\u0002\u00055\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fT3aFA\\\u0011%\t\u0019\u000eAI\u0001\n\u0003\t).\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]'f\u0001\u0013\u00028\"I\u00111\u001c\u0001\u0012\u0002\u0013\u0005\u00111W\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\ty\u000eAI\u0001\n\u0003\t\t/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\r(f\u0001\u001b\u00028\"I\u0011q\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u0011]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0011%\tY\u000fAI\u0001\n\u0003\t).\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\t\u0013\u0005=\b!%A\u0005\u0002\u0005M\u0016AD2paf$C-\u001a4bk2$He\u000e\u0005\n\u0003g\u0004\u0011\u0013!C\u0001\u0003g\u000babY8qs\u0012\"WMZ1vYR$\u0003\bC\u0005\u0002x\u0002\t\n\u0011\"\u0001\u0002b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012J\u0004\"CA~\u0001E\u0005I\u0011AAq\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\u0002\u0004\"CA\u0000\u0001\u0005\u0005I\u0011\tB\u0001\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u0001\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)\u0019!\u0011B\u000e\u0002\t1\fgnZ\u0005\u0004s\t\u001d\u0001\u0002\u0003B\b\u0001\u0005\u0005I\u0011A\u0012\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\tM\u0001!!A\u0005\u0002\tU\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005/\u0011i\u0002E\u0002\n\u00053I1Aa\u0007\u000b\u0005\r\te.\u001f\u0005\n\u0005?\u0011\t\"!AA\u0002\u0011\n1\u0001\u001f\u00132\u0011%\u0011\u0019\u0003AA\u0001\n\u0003\u0012)#A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0003\u0005\u0004\u0003*\t=\"qC\u0007\u0003\u0005WQ1A!\f\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005c\u0011YC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0011)\u0004AA\u0001\n\u0003\u00119$\u0001\u0005dC:,\u0015/^1m)\ra#\u0011\b\u0005\u000b\u0005?\u0011\u0019$!AA\u0002\t]\u0001\"\u0003B\u001f\u0001\u0005\u0005I\u0011\tB \u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0013\t\u0013\t\r\u0003!!A\u0005B\t\u0015\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\r\u0001\"\u0003B%\u0001\u0005\u0005I\u0011\tB&\u0003\u0019)\u0017/^1mgR\u0019AF!\u0014\t\u0015\t}!qIA\u0001\u0002\u0004\u00119\u0002K\u0003\u00019\u0012\u0014\t&\t\u0002\u0003T\u0005\t\u0004+\u0019:b[\u0016$XM]:!M>\u0014\bE]3bI&tw\rI1oI\u0002\u0002(o\\2fgNLgn\u001a\u0011bAQ\u0014X-\u001a2b].ts!\u0003B,\u0005\u0005\u0005\t\u0012\u0001B-\u0003E\u0001&o\\2fgN,G\r\u0016:fK\n\fgn\u001b\t\u00043\nmc\u0001C\u0001\u0003\u0003\u0003E\tA!\u0018\u0014\u000b\tm#qL\t\u0011\u001f\t\u0005$qM\f%YQ\"D\u0005\f\u00175iak!Aa\u0019\u000b\u0007\t\u0015$\"A\u0004sk:$\u0018.\\3\n\t\t%$1\r\u0002\u0013\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0007C\u0004W\u00057\"\tA!\u001c\u0015\u0005\te\u0003B\u0003B\"\u00057\n\t\u0011\"\u0012\u0003F!Q!1\u000fB.\u0003\u0003%\tI!\u001e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015+a\u00139Ha\u001f\u0003\u0000\t\r%q\u0011BE\u0005\u0017\u0013iIa$\u0003\u0012\"1QC!\u001dA\u0002]ASAa\u001e]I\u0016D\u0001B\tB9!\u0003\u0005\r\u0001\n\u0015\u0006\u0005wbF-\u001b\u0005\tU\tE\u0004\u0013!a\u0001Y!*!q\u0010/e[\"A!G!\u001d\u0011\u0002\u0003\u0007A\u0007K\u0003\u0003\u0004r#\u0017\u000f\u0003\u0005?\u0005c\u0002\n\u00111\u00015\u0011!\u0011%\u0011\u000fI\u0001\u0002\u0004!\u0003\u0002\u0003$\u0003rA\u0005\t\u0019\u0001\u0017\t\u0011)\u0013\t\b%AA\u00021B\u0001B\u0014B9!\u0003\u0005\r\u0001\u000e\u0005\t%\nE\u0004\u0013!a\u0001i!Q!Q\u0013B.\u0003\u0003%\tIa&\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0014BS!\u0015I!1\u0014BP\u0013\r\u0011iJ\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u001b%\u0011\tk\u0006\u0013-iQ\"C\u0006\f\u001b5\u0013\r\u0011\u0019K\u0003\u0002\b)V\u0004H.Z\u00191\u0011%\u00119Ka%\u0002\u0002\u0003\u0007\u0001,A\u0002yIAB!Ba+\u0003\\E\u0005I\u0011AAk\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003BX\u00057\n\n\u0011\"\u0001\u00024\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u00034\nm\u0013\u0013!C\u0001\u0003C\fq\"\u00199qYf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0005o\u0013Y&%A\u0005\u0002\u0005\u0005\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\t\u0015\tm&1LI\u0001\n\u0003\t).A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137\u0011)\u0011yLa\u0017\u0012\u0002\u0013\u0005\u00111W\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%o!Q!1\u0019B.#\u0003%\t!a-\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIaB!Ba2\u0003\\E\u0005I\u0011AAq\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012J\u0004B\u0003Bf\u00057\n\n\u0011\"\u0001\u0002b\u0006\u0001\u0012\r\u001d9ms\u0012\"WMZ1vYR$\u0013\u0007\r\u0005\u000b\u0005\u001f\u0014Y&%A\u0005\u0002\u0005U\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0003T\nm\u0013\u0013!C\u0001\u0003g\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003Bl\u00057\n\n\u0011\"\u0001\u0002b\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQB!Ba7\u0003\\E\u0005I\u0011AAq\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k!Q!q\u001cB.#\u0003%\t!!6\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0011)\u0011\u0019Oa\u0017\u0012\u0002\u0013\u0005\u00111W\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\t\u0015\t\u001d(1LI\u0001\n\u0003\t\u0019,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000f\u0005\u000b\u0005W\u0014Y&%A\u0005\u0002\u0005\u0005\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\b\u0003\u0006\u0003p\nm\u0013\u0013!C\u0001\u0003C\fA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004\u0007\u0003\u0006\u0003t\nm\u0013\u0011!C\u0005\u0005k\f1B]3bIJ+7o\u001c7wKR\u0011!q\u001f\t\u0005\u0005\u000b\u0011I0\u0003\u0003\u0003|\n\u001d!AB(cU\u0016\u001cG\u000f")
public class ProcessedTreebank
implements Product,
Serializable {
    private final File path;
    private final int maxLength;
    private final boolean includeDevInTrain;
    private final String binarization;
    private final String treebankType;
    private final int numSentences;
    private final boolean keepUnaryChainsFromTrain;
    private final boolean debuckwalterize;
    private final String supervisedHeadFinderPtbPath;
    private final String supervisedHeadFinderConllPath;
    private Treebank<String> treebank;
    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> trainTrees;
    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> devTrees;
    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees;
    private final StandardTreeProcessor process;
    private volatile byte bitmap$0;

    public static String $lessinit$greater$default$10() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$10();
    }

    public static String $lessinit$greater$default$9() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean $lessinit$greater$default$8() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$7() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$6() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$2();
    }

    public static String apply$default$10() {
        return ProcessedTreebank$.MODULE$.apply$default$10();
    }

    public static String apply$default$9() {
        return ProcessedTreebank$.MODULE$.apply$default$9();
    }

    public static boolean apply$default$8() {
        return ProcessedTreebank$.MODULE$.apply$default$8();
    }

    public static boolean apply$default$7() {
        return ProcessedTreebank$.MODULE$.apply$default$7();
    }

    public static int apply$default$6() {
        return ProcessedTreebank$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return ProcessedTreebank$.MODULE$.apply$default$5();
    }

    public static String apply$default$4() {
        return ProcessedTreebank$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return ProcessedTreebank$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return ProcessedTreebank$.MODULE$.apply$default$2();
    }

    public static Option<Tuple10<File, Object, Object, String, String, Object, Object, Object, String, String>> unapply(ProcessedTreebank processedTreebank) {
        return ProcessedTreebank$.MODULE$.unapply(processedTreebank);
    }

    public static ProcessedTreebank apply(@Help(text="Location of the treebank directory") File file, @Help(text="Max length for training sentences") int n, @Help(text="Should we add the dev set for training, do this only for final test.") boolean bl, @Help(text="What kind of binarization to do. Options: left, right, head. Head is best.") String string, String string2, int n2, boolean bl2, boolean bl3, String string3, String string4) {
        return ProcessedTreebank$.MODULE$.apply(file, n, bl, string, string2, n2, bl2, bl3, string3, string4);
    }

    public static Function1<Tuple10<File, Object, Object, String, String, Object, Object, Object, String, String>, ProcessedTreebank> tupled() {
        return ProcessedTreebank$.MODULE$.tupled();
    }

    public static Function1<File, Function1<Object, Function1<Object, Function1<String, Function1<String, Function1<Object, Function1<Object, Function1<Object, Function1<String, Function1<String, ProcessedTreebank>>>>>>>>>> curried() {
        return ProcessedTreebank$.MODULE$.curried();
    }

    private Treebank treebank$lzycompute() {
        ProcessedTreebank processedTreebank = this;
        synchronized (processedTreebank) {
            block6: {
                block15: {
                    Treebank<String> treebank;
                    block8: {
                        String string;
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block7: {
                                                    if ((byte)(this.bitmap$0 & 1) != 0) break block6;
                                                    string = this.treebankType().toLowerCase();
                                                    if (!"penn".equals(string)) break block7;
                                                    treebank = Treebank$.MODULE$.fromPennTreebankDir(this.path());
                                                    break block8;
                                                }
                                                if (!"chinese".equals(string)) break block9;
                                                treebank = Treebank$.MODULE$.fromChineseTreebankDir(this.path());
                                                break block8;
                                            }
                                            if (!"negra".equals(string)) break block10;
                                            treebank = Treebank$.MODULE$.fromGermanTreebank(this.path());
                                            break block8;
                                        }
                                        if (!"simple".equals(string)) break block11;
                                        treebank = new SimpleTreebank(new File(this.path(), "train.txt"), new File(this.path(), "dev.txt"), new File(this.path(), "test.txt"));
                                        break block8;
                                    }
                                    if (!"conllonto".equals(string)) break block12;
                                    treebank = Treebank$.MODULE$.fromOntonotesDirectory(this.path(), Treebank$.MODULE$.fromOntonotesDirectory$default$2());
                                    break block8;
                                }
                                if (!"spmrl".equals(string)) break block13;
                                File trainPath = new File(this.path(), "train");
                                if (!trainPath.exists()) {
                                    trainPath = new File(this.path(), "train5k");
                                }
                                File[] train2 = (File[])Predef$.MODULE$.refArrayOps((Object[])trainPath.listFiles()).filter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(File x$1) {
                                        return x$1.getName().endsWith("ptb");
                                    }
                                });
                                File[] dev = (File[])Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "dev").listFiles()).filter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(File x$2) {
                                        return x$2.getName().endsWith("ptb");
                                    }
                                });
                                File[] test = (File[])Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "test").listFiles()).filter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(File x$3) {
                                        return x$3.getName().endsWith("ptb");
                                    }
                                });
                                treebank = new SimpleTreebank((IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])train2), (IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])dev), (IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])test));
                                break block8;
                            }
                            if (!"spmrl5k".equals(string)) break block14;
                            File[] train3 = (File[])Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "train5k").listFiles()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(File x$4) {
                                    return x$4.getName().endsWith("ptb");
                                }
                            });
                            File[] dev = (File[])Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "dev").listFiles()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(File x$5) {
                                    return x$5.getName().endsWith("ptb");
                                }
                            });
                            File[] test = (File[])Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "test").listFiles()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(File x$6) {
                                    return x$6.getName().endsWith("ptb");
                                }
                            });
                            treebank = new SimpleTreebank((IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])train3), (IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])dev), (IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])test));
                            break block8;
                        }
                        if (!"meta".equals(string)) break block15;
                        treebank = SimpleTreebank$.MODULE$.fromTrainDevTestDirs(this.path(), SimpleTreebank$.MODULE$.fromTrainDevTestDirs$default$2());
                    }
                    this.treebank = treebank;
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    break block6;
                }
                RuntimeException runtimeException = new RuntimeException("Unknown Treebank type");
                // ** MonitorExit[this] (shouldn't be in output)
                throw runtimeException;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.treebank;
        }
    }

    private IndexedSeq trainTrees$lzycompute() {
        ProcessedTreebank processedTreebank = this;
        synchronized (processedTreebank) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                IndexedSeq train2 = this.transformTrees(this.treebank().train(), this.maxLength(), true);
                if (this.includeDevInTrain()) {
                    train2 = (IndexedSeq)train2.$plus$plus(this.transformTrees(this.treebank().dev(), this.maxLength(), true), IndexedSeq$.MODULE$.canBuildFrom());
                }
                this.trainTrees = (IndexedSeq)train2.take(this.numSentences());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.trainTrees;
        }
    }

    private IndexedSeq devTrees$lzycompute() {
        ProcessedTreebank processedTreebank = this;
        synchronized (processedTreebank) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.devTrees = this.transformTrees(this.treebank().dev(), 100000, this.transformTrees$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.devTrees;
        }
    }

    private IndexedSeq testTrees$lzycompute() {
        ProcessedTreebank processedTreebank = this;
        synchronized (processedTreebank) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.testTrees = this.transformTrees(this.treebank().test(), 1000000, this.transformTrees$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.testTrees;
        }
    }

    public File path() {
        return this.path;
    }

    public int maxLength() {
        return this.maxLength;
    }

    public boolean includeDevInTrain() {
        return this.includeDevInTrain;
    }

    public String binarization() {
        return this.binarization;
    }

    public String treebankType() {
        return this.treebankType;
    }

    public int numSentences() {
        return this.numSentences;
    }

    public boolean keepUnaryChainsFromTrain() {
        return this.keepUnaryChainsFromTrain;
    }

    public boolean debuckwalterize() {
        return this.debuckwalterize;
    }

    public String supervisedHeadFinderPtbPath() {
        return this.supervisedHeadFinderPtbPath;
    }

    public String supervisedHeadFinderConllPath() {
        return this.supervisedHeadFinderConllPath;
    }

    public Treebank<String> treebank() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.treebank$lzycompute() : this.treebank;
    }

    public IndexedSeq<TreeInstance<AnnotatedLabel, String>> trainTrees() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.trainTrees$lzycompute() : this.trainTrees;
    }

    public IndexedSeq<TreeInstance<AnnotatedLabel, String>> devTrees() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.devTrees$lzycompute() : this.devTrees;
    }

    public IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.testTrees$lzycompute() : this.testTrees;
    }

    public IndexedSeq<TreeInstance<AnnotatedLabel, String>> transformTrees(Treebank.Portion portion, int maxL, boolean collapseUnaries) {
        Iterator binarizedAndTransformed = portion.trees().zipWithIndex().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Tree<String>, IndexedSeq<String>>, Object> check$ifrefutable$1) {
                boolean bl = check$ifrefutable$1 != null && check$ifrefutable$1._1() != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(this, maxL){
            public static final long serialVersionUID = 0L;
            private final int maxL$1;

            public final boolean apply(Tuple2<Tuple2<Tree<String>, IndexedSeq<String>>, Object> x$7) {
                if (x$7 != null && x$7._1() != null) {
                    return ((SeqLike)((Tuple2)x$7._1())._2()).length() <= this.maxL$1;
                }
                throw new MatchError(x$7);
            }
            {
                this.maxL$1 = maxL$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessedTreebank $outer;

            public final Tuple2<Tuple2<Tuple2<Tree<String>, IndexedSeq<String>>, Object>, IndexedSeq<String>> apply(Tuple2<Tuple2<Tree<String>, IndexedSeq<String>>, Object> x$9) {
                if (x$9 != null && x$9._1() != null) {
                    IndexedSeq w2 = this.$outer.debuckwalterize() ? (IndexedSeq)((TraversableLike)((Tuple2)x$9._1())._2()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String buckwalter) {
                            return ArabicNormalization$.MODULE$.buckwalterToUnicode(buckwalter);
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom()) : (IndexedSeq)((Tuple2)x$9._1())._2();
                    return new Tuple2(x$9, (Object)w2);
                }
                throw new MatchError(x$9);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this, portion, collapseUnaries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessedTreebank $outer;
            private final Treebank.Portion portion$1;
            private final boolean collapseUnaries$1;

            public final TreeInstance<AnnotatedLabel, String> apply(Tuple2<Tuple2<Tuple2<Tree<String>, IndexedSeq<String>>, Object>, IndexedSeq<String>> x$10) {
                if (x$10 != null && x$10._1() != null && ((Tuple2)x$10._1())._1() != null) {
                    String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.portion$1.name(), BoxesRunTime.boxToInteger((int)((Tuple2)x$10._1())._2$mcI$sp())}));
                    return this.$outer.makeTreeInstance(name, (Tree)((Tuple2)((Tuple2)x$10._1())._1())._1(), (IndexedSeq<String>)((IndexedSeq)x$10._2()), this.collapseUnaries$1);
                }
                throw new MatchError(x$10);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.portion$1 = portion$1;
                this.collapseUnaries$1 = collapseUnaries$1;
            }
        });
        return binarizedAndTransformed.toIndexedSeq();
    }

    public boolean transformTrees$default$3() {
        return false;
    }

    public TreeInstance<AnnotatedLabel, String> makeTreeInstance(String name, Tree<String> tree, IndexedSeq<String> words2, boolean collapseUnaries) {
        ObjectRef transformed = ObjectRef.create(this.process().apply(tree.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AnnotatedLabel apply(String label2) {
                return AnnotatedLabel$.MODULE$.parseTreebank(label2);
            }
        })));
        if (collapseUnaries) {
            transformed.elem = UnaryChainCollapser$.MODULE$.collapseUnaryChains((BinarizedTree)transformed.elem, this.keepUnaryChainsFromTrain());
        }
        Serializable serializable = new Serializable(this, words2, transformed){
            public static final long serialVersionUID = 0L;
            public final IndexedSeq words$1;
            public final ObjectRef transformed$1;

            public final String apply() {
                return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)((BinarizedTree)this.transformed$1.elem)), " ")).append((Object)this.words$1).toString();
            }
            {
                this.words$1 = words$1;
                this.transformed$1 = transformed$1;
            }
        };
        boolean bl = ((BinarizedTree)transformed.elem).children().length() == 1;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            BinarizedTree binarizedTree = (BinarizedTree)serializable.transformed$1.elem;
            Predef$ predef$2 = Predef$.MODULE$;
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension((Object)binarizedTree, " ")).append((Object)serializable.words$1).toString()).toString());
        }
        return new TreeInstance<AnnotatedLabel, String>(name, (BinarizedTree)transformed.elem, words2);
    }

    public HeadFinder<String> headRules() {
        boolean bl;
        String string = this.binarization();
        boolean bl2 = "xbar".equals(string) ? true : "right".equals(string);
        HeadFinder<Object> headFinder = bl2 ? HeadFinder$.MODULE$.right() : ((bl = "leftXbar".equals(string) ? true : "left".equals(string)) ? HeadFinder$.MODULE$.left() : ("head".equals(string) ? (this.treebankType().startsWith("spmrl") ? SupervisedHeadFinder$.MODULE$.trainHeadFinderFromFiles(this.supervisedHeadFinderPtbPath(), this.supervisedHeadFinderConllPath()) : HeadFinder$.MODULE$.collins()) : HeadFinder$.MODULE$.collins()));
        return headFinder;
    }

    public StandardTreeProcessor process() {
        return this.process;
    }

    public ProcessedTreebank copy(File path, int maxLength, boolean includeDevInTrain, String binarization, String treebankType, int numSentences, boolean keepUnaryChainsFromTrain, boolean debuckwalterize, String supervisedHeadFinderPtbPath, String supervisedHeadFinderConllPath) {
        return new ProcessedTreebank(path, maxLength, includeDevInTrain, binarization, treebankType, numSentences, keepUnaryChainsFromTrain, debuckwalterize, supervisedHeadFinderPtbPath, supervisedHeadFinderConllPath);
    }

    public File copy$default$1() {
        return this.path();
    }

    public int copy$default$2() {
        return this.maxLength();
    }

    public boolean copy$default$3() {
        return this.includeDevInTrain();
    }

    public String copy$default$4() {
        return this.binarization();
    }

    public String copy$default$5() {
        return this.treebankType();
    }

    public int copy$default$6() {
        return this.numSentences();
    }

    public boolean copy$default$7() {
        return this.keepUnaryChainsFromTrain();
    }

    public boolean copy$default$8() {
        return this.debuckwalterize();
    }

    public String copy$default$9() {
        return this.supervisedHeadFinderPtbPath();
    }

    public String copy$default$10() {
        return this.supervisedHeadFinderConllPath();
    }

    public String productPrefix() {
        return "ProcessedTreebank";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        Object object;
        switch (x$1) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 9: {
                object = this.supervisedHeadFinderConllPath();
                break;
            }
            case 8: {
                object = this.supervisedHeadFinderPtbPath();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.debuckwalterize());
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this.keepUnaryChainsFromTrain());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToInteger((int)this.numSentences());
                break;
            }
            case 4: {
                object = this.treebankType();
                break;
            }
            case 3: {
                object = this.binarization();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.includeDevInTrain());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.maxLength());
                break;
            }
            case 0: {
                object = this.path();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcessedTreebank;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.path())), (int)this.maxLength()), (int)(this.includeDevInTrain() ? 1231 : 1237)), (int)Statics.anyHash((Object)this.binarization())), (int)Statics.anyHash((Object)this.treebankType())), (int)this.numSentences()), (int)(this.keepUnaryChainsFromTrain() ? 1231 : 1237)), (int)(this.debuckwalterize() ? 1231 : 1237)), (int)Statics.anyHash((Object)this.supervisedHeadFinderPtbPath())), (int)Statics.anyHash((Object)this.supervisedHeadFinderConllPath())), (int)10);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof ProcessedTreebank)) return false;
        boolean bl = true;
        if (!bl) return false;
        ProcessedTreebank processedTreebank = (ProcessedTreebank)x$1;
        File file = this.path();
        File file2 = processedTreebank.path();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        if (this.maxLength() != processedTreebank.maxLength()) return false;
        if (this.includeDevInTrain() != processedTreebank.includeDevInTrain()) return false;
        String string = this.binarization();
        String string2 = processedTreebank.binarization();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.treebankType();
        String string4 = processedTreebank.treebankType();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (this.numSentences() != processedTreebank.numSentences()) return false;
        if (this.keepUnaryChainsFromTrain() != processedTreebank.keepUnaryChainsFromTrain()) return false;
        if (this.debuckwalterize() != processedTreebank.debuckwalterize()) return false;
        String string5 = this.supervisedHeadFinderPtbPath();
        String string6 = processedTreebank.supervisedHeadFinderPtbPath();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        String string7 = this.supervisedHeadFinderConllPath();
        String string8 = processedTreebank.supervisedHeadFinderConllPath();
        if (string7 == null) {
            if (string8 != null) {
                return false;
            }
        } else if (!string7.equals(string8)) return false;
        if (!processedTreebank.canEqual(this)) return false;
        return true;
    }

    public ProcessedTreebank(@Help(text="Location of the treebank directory") File path, @Help(text="Max length for training sentences") int maxLength, @Help(text="Should we add the dev set for training, do this only for final test.") boolean includeDevInTrain, @Help(text="What kind of binarization to do. Options: left, right, head. Head is best.") String binarization, String treebankType, int numSentences, boolean keepUnaryChainsFromTrain, boolean debuckwalterize, String supervisedHeadFinderPtbPath, String supervisedHeadFinderConllPath) {
        this.path = path;
        this.maxLength = maxLength;
        this.includeDevInTrain = includeDevInTrain;
        this.binarization = binarization;
        this.treebankType = treebankType;
        this.numSentences = numSentences;
        this.keepUnaryChainsFromTrain = keepUnaryChainsFromTrain;
        this.debuckwalterize = debuckwalterize;
        this.supervisedHeadFinderPtbPath = supervisedHeadFinderPtbPath;
        this.supervisedHeadFinderConllPath = supervisedHeadFinderConllPath;
        Product.class.$init$((Product)this);
        this.process = new StandardTreeProcessor(HeadFinder$.MODULE$.lensed(this.headRules(), AnnotatedLabel$.MODULE$.stringLens()), StandardTreeProcessor$.MODULE$.$lessinit$greater$default$2());
    }
}

