/*
 * Decompiled with CFR 0.152.
 */
package epic.util;

import breeze.util.BloomFilter;
import com.typesafe.scalalogging.slf4j.Logger;
import epic.util.BloomFilterSeenSet;
import epic.util.LockableSeenSet;
import epic.util.LockableSeenSet$class;
import epic.util.SafeLogging;
import epic.util.SafeLogging$class;
import java.util.concurrent.ConcurrentLinkedDeque;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u000f\t1B\u000b\u001b:fC\u0012dunY1m\u00052|w.\u001c$jYR,'O\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\u0005)\u0011\u0001B3qS\u000e\u001c\u0001!\u0006\u0002\t+M!\u0001!C\b2!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0019\u0001#E\n\u000e\u0003\tI!A\u0005\u0002\u0003\u001f1{7m[1cY\u0016\u001cV-\u001a8TKR\u0004\"\u0001F\u000b\r\u0001\u0011Ia\u0003\u0001Q\u0001\u0002\u0003\u0015\ra\u0006\u0002\u0002)F\u0011\u0001d\u0007\t\u0003\u0015eI!AG\u0006\u0003\u000f9{G\u000f[5oOB\u0011!\u0002H\u0005\u0003;-\u00111!\u00118zQ\u0011)rD\t\u0017\u0011\u0005)\u0001\u0013BA\u0011\f\u0005-\u0019\b/Z2jC2L'0\u001a32\u000b\r\u001aCEJ\u0013\u000f\u0005)!\u0013BA\u0013\f\u0003\rIe\u000e^\u0019\u0005I\u001dZCB\u0004\u0002)W5\t\u0011F\u0003\u0002+\r\u00051AH]8pizJ\u0011\u0001D\u0019\u0006G5r\u0003g\f\b\u0003\u00159J!aL\u0006\u0002\t1{gnZ\u0019\u0005I\u001dZC\u0002\u0005\u0002\u0011e%\u00111G\u0001\u0002\f'\u00064W\rT8hO&tw\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003)qW/\u001c\"vG.,Go\u001d\t\u0003\u0015]J!\u0001O\u0006\u0003\u0007%sG\u000f\u0003\u0005;\u0001\t\u0005\t\u0015!\u00037\u0003AqW/\u001c%bg\"4UO\\2uS>t7\u000fC\u0003=\u0001\u0011\u0005Q(\u0001\u0004=S:LGO\u0010\u000b\u0004}}\u0002\u0005c\u0001\t\u0001'!)Qg\u000fa\u0001m!)!h\u000fa\u0001m!9!\t\u0001b\u0001\n\u0013\u0019\u0015A\u0001;m+\u0005!\u0005cA#K\u00196\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\u0017QC'/Z1e\u0019>\u001c\u0017\r\u001c\t\u0004\u001bF\u001bR\"\u0001(\u000b\u0005\ry%\"\u0001)\u0002\r\t\u0014X-\u001a>f\u0013\t\u0011fJA\u0006CY>|WNR5mi\u0016\u0014\bB\u0002+\u0001A\u0003%A)A\u0002uY\u0002BQA\u0016\u0001\u0005B]\u000b\u0011\"\u00193e\u001fJ\u001cV-\u001a8\u0015\u0005a[\u0006C\u0001\u0006Z\u0013\tQ6BA\u0004C_>dW-\u00198\t\u000bq+\u0006\u0019A\n\u0002\u0003aDqA\u0018\u0001C\u0002\u0013%q,A\u0003rk\u0016,X-F\u0001a!\r\tW\rT\u0007\u0002E*\u00111\rZ\u0001\u000bG>t7-\u001e:sK:$(BA\u0002I\u0013\t1'MA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fI\u0012+\u0017/^3\t\r!\u0004\u0001\u0015!\u0003a\u0003\u0019\tX/Z;fA!)!\u000e\u0001C\u0001W\u0006)QO\\5p]V\tA\nC\u0003n\u0001\u0011\u0005a.\u0001\u0003m_\u000e\\W#A8\u0011\u0007A\u00018#\u0003\u0002r\u0005\t\u0011\"\t\\8p[\u001aKG\u000e^3s'\u0016,gnU3uQ\u0011\u00011O^<\u0011\u0005)!\u0018BA;\f\u0005A\u0019VM]5bYZ+'o]5p]VKE)A\u0003wC2,XMH\u0001\u0002\u0001")
public class ThreadLocalBloomFilter<T>
implements LockableSeenSet<T>,
SafeLogging {
    public static final long serialVersionUID = 1L;
    public final int epic$util$ThreadLocalBloomFilter$$numBuckets;
    public final int epic$util$ThreadLocalBloomFilter$$numHashFunctions;
    private final ThreadLocal<BloomFilter<T>> epic$util$ThreadLocalBloomFilter$$tl;
    private final ConcurrentLinkedDeque<BloomFilter<T>> epic$util$ThreadLocalBloomFilter$$queue;
    private volatile transient Logger epic$util$SafeLogging$$_the_logger;

    @Override
    public Logger epic$util$SafeLogging$$_the_logger() {
        return this.epic$util$SafeLogging$$_the_logger;
    }

    @Override
    @TraitSetter
    public void epic$util$SafeLogging$$_the_logger_$eq(Logger x$1) {
        this.epic$util$SafeLogging$$_the_logger = x$1;
    }

    @Override
    public Logger logger() {
        return SafeLogging$class.logger(this);
    }

    public ThreadLocal<BloomFilter<T>> epic$util$ThreadLocalBloomFilter$$tl() {
        return this.epic$util$ThreadLocalBloomFilter$$tl;
    }

    @Override
    public boolean addOrSeen(T x) {
        this.epic$util$ThreadLocalBloomFilter$$tl().get().$plus$eq(x);
        return true;
    }

    public ConcurrentLinkedDeque<BloomFilter<T>> epic$util$ThreadLocalBloomFilter$$queue() {
        return this.epic$util$ThreadLocalBloomFilter$$queue;
    }

    /*
     * WARNING - void declaration
     */
    public BloomFilter<T> union() {
        void var1_1;
        BloomFilter<T> bf = this.epic$util$ThreadLocalBloomFilter$$tl().get();
        int len = this.epic$util$ThreadLocalBloomFilter$$queue().size();
        for (int i = 0; !this.epic$util$ThreadLocalBloomFilter$$queue().isEmpty() && i < len; ++i) {
            bf.$bar$eq(this.epic$util$ThreadLocalBloomFilter$$queue().pop());
        }
        this.epic$util$ThreadLocalBloomFilter$$queue().push(bf);
        return var1_1;
    }

    @Override
    public BloomFilterSeenSet<T> lock() {
        BoxedUnit boxedUnit;
        BloomFilter<T> u = this.union();
        double load = u.load();
        double size = (double)(-u.numBuckets()) * package$.MODULE$.log1p(-load) / (double)u.numHashFunctions();
        if (this.logger().underlying().isInfoEnabled()) {
            double arg$macro$1 = u.load();
            Double arg$macro$2 = BoxesRunTime.boxToDouble((double)size);
            Integer arg$macro$3 = BoxesRunTime.boxToInteger((int)this.epic$util$ThreadLocalBloomFilter$$queue().size());
            this.logger().underlying().info(new StringOps("Bloom filter has load of %.3f and approx size %s. Queue is %s elements long.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1), arg$macro$2, arg$macro$3})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new BloomFilterSeenSet<T>(u);
    }

    @Override
    public boolean addOrSeen$mcI$sp(int x) {
        return this.addOrSeen(BoxesRunTime.boxToInteger((int)x));
    }

    @Override
    public boolean addOrSeen$mcJ$sp(long x) {
        return this.addOrSeen(BoxesRunTime.boxToLong((long)x));
    }

    public BloomFilter<Object> union$mcI$sp() {
        return this.union();
    }

    public BloomFilter<Object> union$mcJ$sp() {
        return this.union();
    }

    public BloomFilterSeenSet<Object> lock$mcI$sp() {
        return this.lock();
    }

    public BloomFilterSeenSet<Object> lock$mcJ$sp() {
        return this.lock();
    }

    public ThreadLocalBloomFilter(int numBuckets, int numHashFunctions) {
        this.epic$util$ThreadLocalBloomFilter$$numBuckets = numBuckets;
        this.epic$util$ThreadLocalBloomFilter$$numHashFunctions = numHashFunctions;
        LockableSeenSet$class.$init$(this);
        SafeLogging$class.$init$(this);
        this.epic$util$ThreadLocalBloomFilter$$tl = new ThreadLocal<BloomFilter<T>>(this){
            private final /* synthetic */ ThreadLocalBloomFilter $outer;

            /*
             * WARNING - void declaration
             */
            public BloomFilter<T> initialValue() {
                void var1_1;
                BloomFilter bf = new BloomFilter(this.$outer.epic$util$ThreadLocalBloomFilter$$numBuckets, this.$outer.epic$util$ThreadLocalBloomFilter$$numHashFunctions);
                this.$outer.epic$util$ThreadLocalBloomFilter$$queue().offer(bf);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.epic$util$ThreadLocalBloomFilter$$queue = new ConcurrentLinkedDeque();
    }
}

