/*
 * Decompiled with CFR 0.152.
 */
package epic.dense;

import breeze.linalg.Counter;
import breeze.linalg.Counter$;
import breeze.storage.Zero;
import epic.dense.Word2Vec$;
import epic.dense.Word2Vec$$anonfun$smartLoadVectorsForVocabulary$1$;
import epic.dense.Word2VecUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Random;

public final class Word2Vec$ {
    public static final Word2Vec$ MODULE$;
    private final Pattern hyphenPattern;

    static {
        new Word2Vec$();
    }

    public HashMap<String, float[]> smartLoadVectorsForVocabulary(Seq<String> word2vecPaths, Set<String> voc, Counter<String, Object> vocCounts, int maxVectorLen, boolean inputVectorBias, boolean randomizeUnks) {
        Seq vectorsEachSource = (Seq)word2vecPaths.map((Function1)new Serializable(voc){
            public static final long serialVersionUID = 0L;
            private final Set voc$1;

            public final HashMap<String, float[]> apply(String word2vecPath) {
                block4: {
                    HashMap<String, float[]> hashMap;
                    block3: {
                        block2: {
                            if (!word2vecPath.endsWith("bin")) break block2;
                            hashMap = Word2Vec$.MODULE$.readWord2Vec(word2vecPath, (Set<String>)this.voc$1, false);
                            break block3;
                        }
                        if (!word2vecPath.endsWith(".txt")) break block4;
                        hashMap = Word2Vec$.MODULE$.readBansalEmbeddings(word2vecPath, (Set<String>)this.voc$1, false);
                    }
                    return hashMap;
                }
                throw new RuntimeException(new StringBuilder().append((Object)"Unrecognized vectors: ").append((Object)word2vecPath).toString());
            }
            {
                this.voc$1 = voc$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq dimsEachSource = (Seq)vectorsEachSource.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(HashMap<String, float[]> x$1) {
                return ((float[])x$1.values().head()).length;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int finalVectorDim = Math.min(maxVectorLen, BoxesRunTime.unboxToInt((Object)dimsEachSource.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + (inputVectorBias ? 1 : 0));
        HashMap finalVectors = new HashMap();
        Random rng = new Random(0);
        Counter mostCommonMisses = Counter$.MODULE$.apply((Zero)Zero.DoubleZero$.MODULE$);
        IntRef numRand = IntRef.create((int)0);
        voc.foreach((Function1)new Serializable(vocCounts, inputVectorBias, randomizeUnks, vectorsEachSource, dimsEachSource, finalVectorDim, finalVectors, rng, mostCommonMisses, numRand){
            public static final long serialVersionUID = 0L;
            private final Counter vocCounts$1;
            public final boolean inputVectorBias$1;
            private final boolean randomizeUnks$1;
            public final Seq vectorsEachSource$1;
            public final Seq dimsEachSource$1;
            public final int finalVectorDim$1;
            private final HashMap finalVectors$1;
            public final Random rng$1;
            private final Counter mostCommonMisses$1;
            private final IntRef numRand$1;

            /*
             * WARNING - void declaration
             */
            public final Option<float[]> apply(String word) {
                float[] fArray;
                boolean containedInSome = BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)this.vectorsEachSource$1.map((Function1)new Serializable(this, word){
                    public static final long serialVersionUID = 0L;
                    private final String word$1;

                    public final boolean apply(HashMap<String, float[]> x$2) {
                        return x$2.keySet().contains((Object)this.word$1);
                    }
                    {
                        this.word$1 = word$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(boolean x$3, boolean x$4) {
                        return x$3 || x$4;
                    }
                }));
                if (containedInSome) {
                    void var3_3;
                    float[] finalVector = (float[])((TraversableOnce)this.vectorsEachSource$1.indices().map((Function1)new Serializable(this, word){
                        public static final long serialVersionUID = 0L;
                        public final /* synthetic */ anonfun.smartLoadVectorsForVocabulary.1 $outer;
                        private final String word$1;

                        public final float[] apply(int i) {
                            return (float[])((MapLike)this.$outer.vectorsEachSource$1.apply(i)).getOrElse((Object)this.word$1, (Function0)new Serializable(this, i){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$smartLoadVectorsForVocabulary$1$$anonfun$10 $outer;
                                private final int i$1;

                                public final float[] apply() {
                                    return (float[])Array$.MODULE$.tabulate(BoxesRunTime.unboxToInt((Object)this.$outer.$outer.dimsEachSource$1.apply(this.i$1)), (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final float apply(int j) {
                                            return 0.0f;
                                        }

                                        public float apply$mcFI$sp(int j) {
                                            return 0.0f;
                                        }
                                    }, ClassTag$.MODULE$.Float());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.i$1 = i$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.smartLoadVectorsForVocabulary.1 epic$dense$Word2Vec$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.word$1 = word$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final float[] apply(float[] x$5, float[] x$6) {
                            return (float[])Predef$.MODULE$.floatArrayOps(x$5).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(x$6), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        }
                    });
                    if (this.inputVectorBias$1) {
                        finalVector = (float[])Predef$.MODULE$.floatArrayOps(finalVector).$plus$plus((GenTraversableOnce)Predef$.MODULE$.floatArrayOps(new float[]{1.0f}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                    }
                    fArray = var3_3;
                } else {
                    this.mostCommonMisses$1.update((Object)word, this.vocCounts$1.apply((Object)word));
                    ++this.numRand$1.elem;
                    fArray = this.randomizeUnks$1 ? (float[])Array$.MODULE$.tabulate(this.finalVectorDim$1, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.smartLoadVectorsForVocabulary.1 $outer;

                        public final float apply(int i) {
                            return this.apply$mcFI$sp(i);
                        }

                        public float apply$mcFI$sp(int i) {
                            return i == this.$outer.finalVectorDim$1 - 1 && this.$outer.inputVectorBias$1 ? 1.0f : (float)((this.$outer.rng$1.nextDouble() - 0.5) * 0.5);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.Float()) : (float[])Array$.MODULE$.tabulate(this.finalVectorDim$1, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.smartLoadVectorsForVocabulary.1 $outer;

                        public final float apply(int i) {
                            return this.apply$mcFI$sp(i);
                        }

                        public float apply$mcFI$sp(int i) {
                            return i == this.$outer.finalVectorDim$1 - 1 && this.$outer.inputVectorBias$1 ? 1.0f : 0.0f;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.Float());
                }
                void vector = fArray;
                void vectorTrimmed = (float[])(((void)vector).length > this.finalVectorDim$1 ? (float[])Predef$.MODULE$.floatArrayOps((float[])vector).slice(0, this.finalVectorDim$1) : vector);
                Serializable serializable = new Serializable(this, (float[])vector, (float[])vectorTrimmed){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.smartLoadVectorsForVocabulary.1 $outer;
                    private final float[] vector$1;
                    private final float[] vectorTrimmed$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Mismatched sizes, expected dimension ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.finalVectorDim$1)).append((Object)" but got ").append((Object)BoxesRunTime.boxToInteger((int)this.vector$1.length)).append((Object)" clipped to ").append((Object)BoxesRunTime.boxToInteger((int)this.vectorTrimmed$1.length)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.vector$1 = vector$1;
                        this.vectorTrimmed$1 = vectorTrimmed$1;
                    }
                };
                boolean bl = ((void)vectorTrimmed).length == this.finalVectorDim$1;
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)serializable.apply()).toString());
                }
                return this.finalVectors$1.put((Object)word, (Object)vectorTrimmed);
            }
            {
                this.vocCounts$1 = vocCounts$1;
                this.inputVectorBias$1 = inputVectorBias$1;
                this.randomizeUnks$1 = randomizeUnks$1;
                this.vectorsEachSource$1 = vectorsEachSource$1;
                this.dimsEachSource$1 = dimsEachSource$1;
                this.finalVectorDim$1 = finalVectorDim$1;
                this.finalVectors$1 = finalVectors$1;
                this.rng$1 = rng$1;
                this.mostCommonMisses$1 = mostCommonMisses$1;
                this.numRand$1 = numRand$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Read embeddings for ").append((Object)BoxesRunTime.boxToInteger((int)voc.size())).append((Object)" words from ").append((Object)BoxesRunTime.boxToInteger((int)word2vecPaths.size())).append((Object)" sources, ").append((Object)"total embedding size = ").append((Object)BoxesRunTime.boxToInteger((int)finalVectorDim)).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)numRand.elem)).append((Object)" present in no source").toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Fifty most common misses: ").append(mostCommonMisses.argtopk(50, (Ordering)Ordering.Double$.MODULE$).map((Function1)new Serializable(mostCommonMisses){
            public static final long serialVersionUID = 0L;
            private final Counter mostCommonMisses$1;

            public final String apply(String word) {
                return new StringBuilder().append((Object)word).append((Object)": ").append(this.mostCommonMisses$1.apply((Object)word)).toString();
            }
            {
                this.mostCommonMisses$1 = mostCommonMisses$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toString());
        return finalVectors;
    }

    public Counter<String, Object> smartLoadVectorsForVocabulary$default$3() {
        return Counter$.MODULE$.apply((Zero)Zero.DoubleZero$.MODULE$);
    }

    public int smartLoadVectorsForVocabulary$default$4() {
        return Integer.MAX_VALUE;
    }

    public boolean smartLoadVectorsForVocabulary$default$6() {
        return true;
    }

    public HashMap<String, float[]> makeRandomVectorsForVocabulary(Set<String> voc, int dim, boolean inputVectorBias) {
        HashMap finalVectors = new HashMap();
        int finalVectorDim = dim + (inputVectorBias ? 1 : 0);
        Random rng = new Random(0);
        voc.foreach((Function1)new Serializable(inputVectorBias, finalVectors, finalVectorDim, rng){
            public static final long serialVersionUID = 0L;
            public final boolean inputVectorBias$4;
            private final HashMap finalVectors$2;
            public final int finalVectorDim$2;
            public final Random rng$2;

            public final Option<float[]> apply(String word) {
                float[] vec = (float[])Array$.MODULE$.tabulate(this.finalVectorDim$2, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.makeRandomVectorsForVocabulary.1 $outer;

                    public final float apply(int i) {
                        return this.apply$mcFI$sp(i);
                    }

                    public float apply$mcFI$sp(int i) {
                        return i == this.$outer.finalVectorDim$2 - 1 && this.$outer.inputVectorBias$4 ? 1.0f : (float)((this.$outer.rng$2.nextDouble() - 0.5) * 0.5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Float());
                return this.finalVectors$2.put((Object)word, (Object)vec);
            }
            {
                this.inputVectorBias$4 = inputVectorBias$4;
                this.finalVectors$2 = finalVectors$2;
                this.finalVectorDim$2 = finalVectorDim$2;
                this.rng$2 = rng$2;
            }
        });
        return finalVectors;
    }

    public HashMap<String, float[]> loadVectorsForVocabulary(String word2vecPath, Set<String> voc, boolean inputVectorBias) {
        HashMap<String, float[]> word2vecMap = this.readWord2Vec(word2vecPath, voc, inputVectorBias);
        if (word2vecMap.isEmpty()) {
            throw new RuntimeException("No word2vec vectors loaded");
        }
        return this.augmentVectorsToCompleteVocabulary(word2vecMap, voc, inputVectorBias);
    }

    public HashMap<String, float[]> loadBansalVectorsForVocabulary(String word2vecPath, Set<String> voc, boolean inputVectorBias) {
        HashMap<String, float[]> word2vecMap = this.readBansalEmbeddings(word2vecPath, voc, inputVectorBias);
        if (word2vecMap.isEmpty()) {
            throw new RuntimeException("No Bansal vectors loaded");
        }
        return this.augmentVectorsToCompleteVocabulary(word2vecMap, voc, inputVectorBias);
    }

    private HashMap<String, float[]> augmentVectorsToCompleteVocabulary(HashMap<String, float[]> word2vecMap, Set<String> voc, boolean inputVectorBias) {
        int word2vecDim = ((float[])word2vecMap.values().head()).length;
        Random rng = new Random(0);
        ((IterableLike)voc.$minus$minus((GenTraversableOnce)word2vecMap.keySet())).foreach((Function1)new Serializable(word2vecMap, inputVectorBias, word2vecDim, rng){
            public static final long serialVersionUID = 0L;
            private final HashMap word2vecMap$1;
            public final boolean inputVectorBias$5;
            public final int word2vecDim$1;
            public final Random rng$3;

            public final Option<float[]> apply(String unkWord) {
                return this.word2vecMap$1.put((Object)unkWord, Array$.MODULE$.tabulate(this.word2vecDim$1, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.augmentVectorsToCompleteVocabulary.1 $outer;

                    public final float apply(int i) {
                        return this.apply$mcFI$sp(i);
                    }

                    public float apply$mcFI$sp(int i) {
                        return i == this.$outer.word2vecDim$1 - 1 && this.$outer.inputVectorBias$5 ? 1.0f : (float)((this.$outer.rng$3.nextDouble() - 0.5) * 0.5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Float()));
            }
            {
                this.word2vecMap$1 = word2vecMap$1;
                this.inputVectorBias$5 = inputVectorBias$5;
                this.word2vecDim$1 = word2vecDim$1;
                this.rng$3 = rng$3;
            }
        });
        return word2vecMap;
    }

    public HashMap<String, float[]> readWord2Vec(String word2VecPath, Set<String> words2, boolean inputVectorBias) {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(word2VecPath));
        DataInputStream dis = new DataInputStream(bis);
        HashMap word2Vec = new HashMap();
        String string = Word2VecUtils.readString(dis);
        Predef$ predef$ = Predef$.MODULE$;
        int vocSize = new StringOps(string).toInt();
        String string2 = Word2VecUtils.readString(dis);
        Predef$ predef$2 = Predef$.MODULE$;
        int dim = new StringOps(string2).toInt();
        Predef$ predef$3 = Predef$.MODULE$;
        Range range = Range$.MODULE$.apply(0, vocSize);
        if (!range.isEmpty()) {
            int n = range.start();
            while (true) {
                int n2;
                if ((n2 = n) % 1000000 == 0) {
                    String string3 = new StringBuilder().append((Object)"On line ").append((Object)BoxesRunTime.boxToInteger((int)n2)).toString();
                    Predef$ predef$4 = Predef$.MODULE$;
                    Console$.MODULE$.println((Object)string3);
                }
                String word1 = Word2VecUtils.readString(dis);
                float[] vector1 = new float[inputVectorBias ? dim + 1 : dim];
                for (int j1 = 0; j1 < dim; ++j1) {
                    vector1[j1] = Word2VecUtils.readFloat(dis);
                }
                if (inputVectorBias) {
                    vector1[j1] = 1.0f;
                }
                Object object = words2.isEmpty() || words2.contains((Object)word1) ? word2Vec.put((Object)word1, (Object)vector1) : BoxedUnit.UNIT;
                if (n == range.lastElement()) break;
                n += range.step();
            }
        }
        String string4 = new StringBuilder().append((Object)"Loaded ").append((Object)BoxesRunTime.boxToInteger((int)word2Vec.size())).append((Object)" word2vec representations out of ").append((Object)BoxesRunTime.boxToInteger((int)words2.size())).append((Object)" attempted words").toString();
        Predef$ predef$5 = Predef$.MODULE$;
        Console$.MODULE$.println((Object)string4);
        return word2Vec;
    }

    public Pattern hyphenPattern() {
        return this.hyphenPattern;
    }

    /*
     * WARNING - void declaration
     */
    public String convertWord(String str, boolean lowercase) {
        void var3_3;
        String strRep = str.replace("-LRB-", "(").replace("-RRB-", ")").replace("-LSB-", "[").replace("-RSB-", "]").replace("-LCB-", "{").replace("-RCB-", "}").replaceAll("^-?[0-9,.]{2,15}$", "fifteen");
        Matcher m2 = this.hyphenPattern().matcher(str);
        String string = strRep = m2.find() ? m2.group(2) : strRep;
        if (lowercase) {
            strRep = strRep.toLowerCase();
        }
        return var3_3;
    }

    public boolean convertWord$default$2() {
        return false;
    }

    public HashMap<String, float[]> readBansalEmbeddings(String embeddingsPath, Set<String> words2, boolean inputVectorBias) {
        Iterator inFile = Source$.MODULE$.fromFile(new File(embeddingsPath), Codec$.MODULE$.fallbackSystemCodec()).getLines();
        HashMap word2Vec = new HashMap();
        boolean firstLine = true;
        while (inFile.hasNext()) {
            BoxedUnit boxedUnit;
            String line = (String)inFile.next();
            if (firstLine) {
                if (Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")).size() == 2) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Skipping first line: ").append((Object)line).toString());
                } else {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Not skipping first line: ").append((Object)line).toString());
                    firstLine = false;
                }
            }
            if (firstLine) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (line.contains("\t")) {
                String word = line.substring(0, line.indexOf("\t"));
                if (words2.isEmpty() || words2.contains((Object)word)) {
                    String[] entries = line.substring(line.indexOf("\t") + 1).split(" ");
                    float[] arr = (float[])Array$.MODULE$.tabulate(inputVectorBias ? Predef$.MODULE$.refArrayOps((Object[])entries).size() + 1 : Predef$.MODULE$.refArrayOps((Object[])entries).size(), (Function1)new Serializable(inputVectorBias, entries){
                        public static final long serialVersionUID = 0L;
                        private final boolean inputVectorBias$3;
                        private final String[] entries$1;

                        public final float apply(int i) {
                            return this.apply$mcFI$sp(i);
                        }

                        public float apply$mcFI$sp(int i) {
                            float f;
                            if (this.inputVectorBias$3 && i == Predef$.MODULE$.refArrayOps((Object[])this.entries$1).size()) {
                                f = 1.0f;
                            } else {
                                String string = this.entries$1[i];
                                Predef$ predef$ = Predef$.MODULE$;
                                f = new StringOps(string).toFloat();
                            }
                            return f;
                        }
                        {
                            this.inputVectorBias$3 = inputVectorBias$3;
                            this.entries$1 = entries$1;
                        }
                    }, ClassTag$.MODULE$.Float());
                    boxedUnit = word2Vec.put((Object)word, (Object)arr);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                String word = line.substring(0, line.indexOf(" "));
                if (words2.isEmpty() || words2.contains((Object)word)) {
                    String[] entries = line.substring(line.indexOf(" ") + 1).split(" ");
                    float[] arr = (float[])Array$.MODULE$.tabulate(inputVectorBias ? Predef$.MODULE$.refArrayOps((Object[])entries).size() + 1 : Predef$.MODULE$.refArrayOps((Object[])entries).size(), (Function1)new Serializable(inputVectorBias, entries){
                        public static final long serialVersionUID = 0L;
                        private final boolean inputVectorBias$3;
                        private final String[] entries$2;

                        public final float apply(int i) {
                            return this.apply$mcFI$sp(i);
                        }

                        public float apply$mcFI$sp(int i) {
                            float f;
                            if (this.inputVectorBias$3 && i == Predef$.MODULE$.refArrayOps((Object[])this.entries$2).size()) {
                                f = 1.0f;
                            } else {
                                String string = this.entries$2[i];
                                Predef$ predef$ = Predef$.MODULE$;
                                f = new StringOps(string).toFloat();
                            }
                            return f;
                        }
                        {
                            this.inputVectorBias$3 = inputVectorBias$3;
                            this.entries$2 = entries$2;
                        }
                    }, ClassTag$.MODULE$.Float());
                    boxedUnit = word2Vec.put((Object)word, (Object)arr);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            firstLine = false;
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Loaded ").append((Object)BoxesRunTime.boxToInteger((int)word2Vec.size())).append((Object)" Bansal representations out of ").append((Object)BoxesRunTime.boxToInteger((int)words2.size())).append((Object)" attempted words").toString());
        return word2Vec;
    }

    private Word2Vec$() {
        MODULE$ = this;
        this.hyphenPattern = Pattern.compile("(\\w+-)+(\\w+)");
    }
}

