/*
 * Decompiled with CFR 0.152.
 */
package epic.parser.models;

import breeze.config.Help;
import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.scaleAdd$;
import breeze.util.Index;
import epic.dense.AffineOutputTransform;
import epic.dense.AffineOutputTransform$;
import epic.dense.AffineTransform;
import epic.dense.AffineTransform$;
import epic.dense.CachingLookupAndAffineTransformDense;
import epic.dense.CachingLookupAndAffineTransformDense$;
import epic.dense.CachingLookupTransform;
import epic.dense.EmbeddingsTransform;
import epic.dense.EmbeddingsTransform$;
import epic.dense.NonlinearTransform;
import epic.dense.NonlinearTransform$;
import epic.dense.OutputEmbeddingTransform;
import epic.dense.OutputTransform;
import epic.dense.Transform;
import epic.dense.Word2VecIndexed;
import epic.framework.Feature;
import epic.parser.GenerativeParser$;
import epic.parser.models.ExtraPNMParams;
import epic.parser.models.ExtraPNMParams$;
import epic.parser.models.ExtraPNMSparseParams;
import epic.parser.models.ExtraPNMSparseParams$;
import epic.parser.models.PositionalNeuralModelFactory;
import epic.trees.AnnotatedLabel;
import epic.trees.Rule;
import epic.trees.annotations.TreeAnnotator;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple15;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class PositionalNeuralModelFactory$
implements Serializable {
    public static final PositionalNeuralModelFactory$ MODULE$;

    static {
        new PositionalNeuralModelFactory$();
    }

    public Transform<int[], DenseVector<Object>> buildNetInnerTransforms(Word2VecIndexed<String> word2vecIndexed, int inputSize, int numHidden, int numHiddenLayers, String nonLinType, double dropoutRate, boolean backpropIntoEmbeddings) {
        Transform<int[], DenseVector<Object>> transform;
        if (numHiddenLayers == 0) {
            transform = new CachingLookupTransform(word2vecIndexed);
        } else {
            Product product;
            if (backpropIntoEmbeddings) {
                EmbeddingsTransform$ embeddingsTransform$ = EmbeddingsTransform$.MODULE$;
                product = new EmbeddingsTransform(numHidden, inputSize, word2vecIndexed, true);
            } else {
                CachingLookupAndAffineTransformDense$ cachingLookupAndAffineTransformDense$ = CachingLookupAndAffineTransformDense$.MODULE$;
                product = new CachingLookupAndAffineTransformDense(numHidden, inputSize, word2vecIndexed, true);
            }
            Product baseTransformLayer = product;
            ObjectRef currLayer = ObjectRef.create(this.addNonlinearity(nonLinType, numHidden, dropoutRate, (Transform<int[], DenseVector<Object>>)baseTransformLayer));
            Predef$ predef$ = Predef$.MODULE$;
            Range range = Range$.MODULE$.apply(1, numHiddenLayers);
            if (!range.isEmpty()) {
                int n = range.start();
                while (true) {
                    AffineTransform$ affineTransform$ = AffineTransform$.MODULE$;
                    currLayer.elem = MODULE$.addNonlinearity(nonLinType, numHidden, dropoutRate, new AffineTransform(numHidden, numHidden, (Transform)currLayer.elem, true, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD(), DenseVector.canDaxpy$.MODULE$));
                    if (n == range.lastElement()) break;
                    n += range.step();
                }
            }
            transform = (Transform)currLayer.elem;
        }
        return transform;
    }

    public AffineOutputTransform<int[]> buildNet(Word2VecIndexed<String> word2vecIndexed, int inputSize, int numHidden, int numHiddenLayers, int outputSize, String nonLinType, double dropoutRate, boolean backpropIntoEmbeddings) {
        Transform<int[], DenseVector<Object>> innerTransform = this.buildNetInnerTransforms(word2vecIndexed, inputSize, numHidden, numHiddenLayers, nonLinType, dropoutRate, backpropIntoEmbeddings);
        return new AffineOutputTransform<int[]>(outputSize, numHiddenLayers >= 1 ? numHidden : inputSize, innerTransform, AffineOutputTransform$.MODULE$.$lessinit$greater$default$4());
    }

    public OutputTransform<int[], DenseVector<Object>> buildNetOutputEmbedding(Word2VecIndexed<String> word2vecIndexed, int inputSize, int numHidden, int numHiddenLayers, int outputSize, String nonLinType, double dropoutRate, boolean backpropIntoEmbeddings, int outputEmbeddingDim, Option<Function1<Object, Object>> coarsenerForInitialization) {
        Transform<int[], DenseVector<Object>> innerTransform = this.buildNetInnerTransforms(word2vecIndexed, inputSize, numHidden, numHiddenLayers, nonLinType, dropoutRate, backpropIntoEmbeddings);
        AffineTransform<int[], DenseVector<Object>> innerTransformLastLayer = new AffineTransform<int[], DenseVector<Object>>(outputEmbeddingDim, numHiddenLayers >= 1 ? numHidden : inputSize, innerTransform, AffineTransform$.MODULE$.$lessinit$greater$default$4(), (UFunc.UImpl2<OpMulMatrix$, DenseMatrix<Object>, DenseVector<Object>, DenseVector<Object>>)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD(), (UFunc.InPlaceImpl3<scaleAdd$, DenseVector<Object>, Object, DenseVector<Object>>)DenseVector.canDaxpy$.MODULE$);
        return new OutputEmbeddingTransform<int[]>(outputSize, outputEmbeddingDim, innerTransformLastLayer, coarsenerForInitialization);
    }

    public Transform<int[], DenseVector<Object>> addNonlinearity(String nonLinType, int numHidden, double dropoutRate, Transform<int[], DenseVector<Object>> currLayer) {
        boolean useDropout = dropoutRate > 1.0E-8;
        NonlinearTransform<Object> tmpLayer = new NonlinearTransform<int[]>(nonLinType, numHidden, currLayer, NonlinearTransform$.MODULE$.$lessinit$greater$default$4());
        if (useDropout) {
            tmpLayer = new NonlinearTransform("dropout", numHidden, tmpLayer, dropoutRate);
        }
        return tmpLayer;
    }

    public Function1<Object, Object> getRuleToParentMapping(Index<Feature> index2) {
        return new Serializable(index2){
            public static final long serialVersionUID = 0L;
            private final Index index$1;

            public final int apply(int i) {
                return this.apply$mcII$sp(i);
            }

            public int apply$mcII$sp(int i) {
                int parentIdx;
                return this.index$1.get(i) instanceof Rule ? ((parentIdx = this.index$1.apply(((Rule)this.index$1.get(i)).parent())) == -1 ? 0 : parentIdx) : i;
            }
            {
                this.index$1 = index$1;
            }
        };
    }

    public PositionalNeuralModelFactory apply(@Help(text="The kind of annotation to do on the refined grammar. Default uses just parent annotation.\nYou can also epic.trees.annotations.KMAnnotator to get more or less Klein and Manning 2003.\n                              ") TreeAnnotator<AnnotatedLabel, String, AnnotatedLabel> annotator, @Help(text="For features not seen in gold trees, we bin them into dummyFeats * numGoldFeatures bins using hashing. If negative, use absolute value as number of hash features.") double dummyFeats, @Help(text="Sparse features only fire on suffixes seen at lease this many times. Lower than 100 doesn't seem to do better.") int commonWordThreshold, @Help(text="Combine the neural net features with sparse features. The NN does well on its own but sparse helps by >1 F1.") boolean useSparseFeatures, @Help(text="Nonlinearity to use. Options: tanh, relu, cube") String nonLinType, @Help(text="Backpropagate into word embeddings (tune them during training). Doesn't help.") boolean backpropIntoEmbeddings, @Help(text="Dropout rate; 0.0 won't instantiate any dropout units, higher rates will but it doesn't seem to help.") double dropoutRate, @Help(text="Width of hidden layer to use.") int numHidden, @Help(text="Number of hidden layers to use. More than 1 slows down dramatically and doesn't help.") int numHiddenLayers, @Help(text="How much surface context should we use as input to the neural network? Default is +/-2 words around begin/end/split. See Word2VecSurfaceFeaturizer for options") String neuralSurfaceWordsToUse, @Help(text="Path to word vectors. Can either be .bin like Mikolov et al.'s or .txt like Bansal et al.'s") String word2vecPath, @Help(text="Load additional word vectors into the model rather than just those in the training set. Doesn't help.") String vocFile, @Help(text="Set to true if your word vectors are all lowercase. Otherwise true case is used.") boolean lowercasedVectors, ExtraPNMParams extraPNMParams, ExtraPNMSparseParams extraPNMSparseParams) {
        return new PositionalNeuralModelFactory(annotator, dummyFeats, commonWordThreshold, useSparseFeatures, nonLinType, backpropIntoEmbeddings, dropoutRate, numHidden, numHiddenLayers, neuralSurfaceWordsToUse, word2vecPath, vocFile, lowercasedVectors, extraPNMParams, extraPNMSparseParams);
    }

    public Option<Tuple15<TreeAnnotator<AnnotatedLabel, String, AnnotatedLabel>, Object, Object, Object, String, Object, Object, Object, Object, String, String, String, Object, ExtraPNMParams, ExtraPNMSparseParams>> unapply(PositionalNeuralModelFactory x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15(x$0.annotator(), (Object)BoxesRunTime.boxToDouble((double)x$0.dummyFeats()), (Object)BoxesRunTime.boxToInteger((int)x$0.commonWordThreshold()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useSparseFeatures()), (Object)x$0.nonLinType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.backpropIntoEmbeddings()), (Object)BoxesRunTime.boxToDouble((double)x$0.dropoutRate()), (Object)BoxesRunTime.boxToInteger((int)x$0.numHidden()), (Object)BoxesRunTime.boxToInteger((int)x$0.numHiddenLayers()), (Object)x$0.neuralSurfaceWordsToUse(), (Object)x$0.word2vecPath(), (Object)x$0.vocFile(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.lowercasedVectors()), (Object)x$0.extraPNMParams(), (Object)x$0.extraPNMSparseParams()));
    }

    public TreeAnnotator<AnnotatedLabel, String, AnnotatedLabel> $lessinit$greater$default$1() {
        return GenerativeParser$.MODULE$.defaultAnnotator(GenerativeParser$.MODULE$.defaultAnnotator$default$1(), GenerativeParser$.MODULE$.defaultAnnotator$default$2());
    }

    public double $lessinit$greater$default$2() {
        return 0.5;
    }

    public int $lessinit$greater$default$3() {
        return 100;
    }

    public boolean $lessinit$greater$default$4() {
        return true;
    }

    public String $lessinit$greater$default$5() {
        return "relu";
    }

    public boolean $lessinit$greater$default$6() {
        return false;
    }

    public double $lessinit$greater$default$7() {
        return 0.0;
    }

    public int $lessinit$greater$default$8() {
        return 200;
    }

    public int $lessinit$greater$default$9() {
        return 1;
    }

    public String $lessinit$greater$default$10() {
        return "most";
    }

    public String $lessinit$greater$default$11() {
        return "";
    }

    public String $lessinit$greater$default$12() {
        return "";
    }

    public boolean $lessinit$greater$default$13() {
        return false;
    }

    public ExtraPNMParams $lessinit$greater$default$14() {
        return new ExtraPNMParams(ExtraPNMParams$.MODULE$.apply$default$1(), ExtraPNMParams$.MODULE$.apply$default$2(), ExtraPNMParams$.MODULE$.apply$default$3(), ExtraPNMParams$.MODULE$.apply$default$4(), ExtraPNMParams$.MODULE$.apply$default$5(), ExtraPNMParams$.MODULE$.apply$default$6(), ExtraPNMParams$.MODULE$.apply$default$7(), ExtraPNMParams$.MODULE$.apply$default$8(), ExtraPNMParams$.MODULE$.apply$default$9(), ExtraPNMParams$.MODULE$.apply$default$10(), ExtraPNMParams$.MODULE$.apply$default$11());
    }

    public ExtraPNMSparseParams $lessinit$greater$default$15() {
        return new ExtraPNMSparseParams(ExtraPNMSparseParams$.MODULE$.apply$default$1(), ExtraPNMSparseParams$.MODULE$.apply$default$2(), ExtraPNMSparseParams$.MODULE$.apply$default$3(), ExtraPNMSparseParams$.MODULE$.apply$default$4());
    }

    public TreeAnnotator<AnnotatedLabel, String, AnnotatedLabel> apply$default$1() {
        return GenerativeParser$.MODULE$.defaultAnnotator(GenerativeParser$.MODULE$.defaultAnnotator$default$1(), GenerativeParser$.MODULE$.defaultAnnotator$default$2());
    }

    public double apply$default$2() {
        return 0.5;
    }

    public int apply$default$3() {
        return 100;
    }

    public boolean apply$default$4() {
        return true;
    }

    public String apply$default$5() {
        return "relu";
    }

    public boolean apply$default$6() {
        return false;
    }

    public double apply$default$7() {
        return 0.0;
    }

    public int apply$default$8() {
        return 200;
    }

    public int apply$default$9() {
        return 1;
    }

    public String apply$default$10() {
        return "most";
    }

    public String apply$default$11() {
        return "";
    }

    public String apply$default$12() {
        return "";
    }

    public boolean apply$default$13() {
        return false;
    }

    public ExtraPNMParams apply$default$14() {
        return new ExtraPNMParams(ExtraPNMParams$.MODULE$.apply$default$1(), ExtraPNMParams$.MODULE$.apply$default$2(), ExtraPNMParams$.MODULE$.apply$default$3(), ExtraPNMParams$.MODULE$.apply$default$4(), ExtraPNMParams$.MODULE$.apply$default$5(), ExtraPNMParams$.MODULE$.apply$default$6(), ExtraPNMParams$.MODULE$.apply$default$7(), ExtraPNMParams$.MODULE$.apply$default$8(), ExtraPNMParams$.MODULE$.apply$default$9(), ExtraPNMParams$.MODULE$.apply$default$10(), ExtraPNMParams$.MODULE$.apply$default$11());
    }

    public ExtraPNMSparseParams apply$default$15() {
        return new ExtraPNMSparseParams(ExtraPNMSparseParams$.MODULE$.apply$default$1(), ExtraPNMSparseParams$.MODULE$.apply$default$2(), ExtraPNMSparseParams$.MODULE$.apply$default$3(), ExtraPNMSparseParams$.MODULE$.apply$default$4());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PositionalNeuralModelFactory$() {
        MODULE$ = this;
    }
}

