/*
 * Decompiled with CFR 0.152.
 */
package epic.sequences;

import breeze.config.CommandLineParser$;
import breeze.config.Configuration$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.math.Field;
import breeze.optimize.BatchDiffFunction;
import breeze.optimize.CachedBatchDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.GradientTester$;
import breeze.util.Encoder;
import breeze.util.Encoder$;
import breeze.util.Implicits$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import breeze.util.package$;
import epic.corpora.CONLLSequenceReader$;
import epic.framework.Example;
import epic.framework.Feature;
import epic.framework.ModelObjective;
import epic.sequences.Segmentation;
import epic.sequences.SegmentationEval;
import epic.sequences.SegmentationEval$;
import epic.sequences.SegmentationModelFactory;
import epic.sequences.SegmentationModelFactory$;
import epic.sequences.SemiCRFInference;
import epic.sequences.SemiCRFModel;
import epic.sequences.SemiConllNerPipeline;
import epic.trees.Span;
import epic.trees.Span$;
import epic.util.Optional$;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class SemiConllNerPipeline$
implements SerializableLogging {
    public static final SemiConllNerPipeline$ MODULE$;
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;

    static {
        new SemiConllNerPipeline$();
    }

    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    public LazyLogger logger() {
        return SerializableLogging.class.logger((SerializableLogging)this);
    }

    public Segmentation<String, String> makeSegmentation(Example<IndexedSeq<String>, IndexedSeq<IndexedSeq<String>>> ex) {
        BoxedUnit boxedUnit;
        int i;
        IndexedSeq<String> labels = ex.label();
        IndexedSeq words2 = (IndexedSeq)((TraversableLike)ex.features()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(IndexedSeq<String> x$8) {
                return (String)x$8.apply(0);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(labels.length() == words2.length());
        ArrayBuffer out = new ArrayBuffer();
        int start = labels.length();
        block5: for (i = 0; i < labels.length(); ++i) {
            String l = (String)labels.apply(i);
            Predef$ predef$ = Predef$.MODULE$;
            char c = StringOps$.MODULE$.apply$extension(l, 0);
            switch (c) {
                default: {
                    throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"weird label?!?").append((Object)l).toString());
                }
                case 'I': {
                    if (start >= i) {
                        start = i;
                        continue block5;
                    }
                    Object object = labels.apply(start);
                    if (!(object == null ? l != null : !object.equals(l))) continue block5;
                    Span span = new Span(Span$.MODULE$.apply(start, i));
                    Object object2 = Predef$.MODULE$.ArrowAssoc((Object)((String)labels.apply(start)).replaceAll(".-", "").intern());
                    Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                    out.$plus$eq((Object)new Tuple2(object2, (Object)span));
                    start = i;
                    continue block5;
                }
                case 'B': {
                    BoxedUnit boxedUnit2;
                    if (start < i) {
                        Span span = new Span(Span$.MODULE$.apply(start, i));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)((String)labels.apply(start)).replaceAll(".-", "").intern());
                        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                        boxedUnit2 = out.$plus$eq((Object)new Tuple2(object, (Object)span));
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    start = i;
                    continue block5;
                }
                case 'O': {
                    BoxedUnit boxedUnit3;
                    if (start < i) {
                        Span span = new Span(Span$.MODULE$.apply(start, i));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)((String)labels.apply(start)).replaceAll(".-", "").intern());
                        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                        boxedUnit3 = out.$plus$eq((Object)new Tuple2(object, (Object)span));
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    start = i + 1;
                }
            }
        }
        if (start < i) {
            Span span = new Span(Span$.MODULE$.apply(start, i));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)((String)labels.apply(start)).replaceAll(".-", "").intern());
            Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
            boxedUnit = out.$plus$eq((Object)new Tuple2(object, (Object)span));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Segmentation<String, String>((IndexedSeq<Tuple2<String, Span>>)out, (IndexedSeq<String>)words2, ex.id());
    }

    public void main(String[] args) {
        Object object;
        SemiConllNerPipeline.Params params = (SemiConllNerPipeline.Params)CommandLineParser$.MODULE$.readIn((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])args), CommandLineParser$.MODULE$.readIn$default$2(), CommandLineParser$.MODULE$.readIn$default$3(), CommandLineParser$.MODULE$.readIn$default$4(), CommandLineParser$.MODULE$.readIn$default$5(), CommandLineParser$.MODULE$.readIn$default$6(), ManifestFactory$.MODULE$.classType(SemiConllNerPipeline.Params.class));
        this.logger().info((Function0)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final SemiConllNerPipeline.Params params$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Command line arguments for recovery:\n").append((Object)Configuration$.MODULE$.fromObject((Object)this.params$2, Configuration$.MODULE$.fromObject$default$2(), ManifestFactory$.MODULE$.classType(SemiConllNerPipeline.Params.class)).toCommandLineString()).toString();
            }
            {
                this.params$2 = params$2;
            }
        });
        scala.collection.immutable.IndexedSeq standardTrain = CONLLSequenceReader$.MODULE$.readTrain(new FileInputStream(params.train()), params.train().getName(), CONLLSequenceReader$.MODULE$.readTrain$default$3()).toIndexedSeq();
        scala.collection.immutable.IndexedSeq standardTest = CONLLSequenceReader$.MODULE$.readTrain(new FileInputStream(params.test()), params.train().getName(), CONLLSequenceReader$.MODULE$.readTrain$default$3()).toIndexedSeq();
        Object object2 = standardTest.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Segmentation<String, String> apply(Example<IndexedSeq<String>, IndexedSeq<IndexedSeq<String>>> ex) {
                return SemiConllNerPipeline$.MODULE$.makeSegmentation(ex);
            }
        }, scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom());
        Object object3 = Predef$.MODULE$.ArrowAssoc(((TraversableLike)standardTrain.take(params.nsents())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Segmentation<String, String> apply(Example<IndexedSeq<String>, IndexedSeq<IndexedSeq<String>>> ex) {
                return SemiConllNerPipeline$.MODULE$.makeSegmentation(ex);
            }
        }, scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom()));
        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
        Tuple2 tuple2 = new Tuple2(object3, object2);
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        scala.collection.immutable.IndexedSeq train2 = (scala.collection.immutable.IndexedSeq)tuple22._1();
        scala.collection.immutable.IndexedSeq test = (scala.collection.immutable.IndexedSeq)tuple22._2();
        SemiCRFModel model = new SegmentationModelFactory(SegmentationModelFactory$.MODULE$.$lessinit$greater$default$1(), SegmentationModelFactory$.MODULE$.$lessinit$greater$default$2(), Optional$.MODULE$.optionToOptional(SegmentationModelFactory$.MODULE$.$lessinit$greater$default$3()), SegmentationModelFactory$.MODULE$.$lessinit$greater$default$4(), SegmentationModelFactory$.MODULE$.$lessinit$greater$default$5()).makeModel(train2);
        ModelObjective obj = new ModelObjective(model, train2, params.nthreads());
        CachedBatchDiffFunction cached = new CachedBatchDiffFunction(obj, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double()));
        if (params.checkGradient()) {
            DenseVector<Object> x$25 = obj.initialWeightVector(true);
            Serializable x$26 = new Serializable(model){
                public static final long serialVersionUID = 0L;
                private final SemiCRFModel model$2;

                public final String apply(int i) {
                    return this.model$2.featureIndex().get(i).toString();
                }
                {
                    this.model$2 = model$2;
                }
            };
            double x$27 = GradientTester$.MODULE$.test$default$3();
            boolean x$28 = GradientTester$.MODULE$.test$default$4();
            double x$29 = GradientTester$.MODULE$.test$default$5();
            double x$30 = GradientTester$.MODULE$.test$default$6();
            object = GradientTester$.MODULE$.test((DiffFunction)cached, x$25, x$27, x$28, x$29, x$30, (Function1)x$26, Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double()), DenseVector$.MODULE$.canNorm((Field)Field.fieldDouble$.MODULE$), DenseVector$.MODULE$.canSubD());
        } else {
            object = BoxedUnit.UNIT;
        }
        FirstOrderMinimizer.State weights = (FirstOrderMinimizer.State)Implicits$.MODULE$.scEnrichIterator(Implicits$.MODULE$.scEnrichIterator(params.opt().iterations((BatchDiffFunction)cached, obj.initialWeightVector(false), DenseVector$.MODULE$.space_Double())).tee((Function1)new Serializable(params, test, model){
            public static final long serialVersionUID = 0L;
            private final SemiConllNerPipeline.Params params$2;
            private final scala.collection.immutable.IndexedSeq test$2;
            private final SemiCRFModel model$2;

            public final void apply(FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> state) {
                if ((state.iter() + 1) % this.params$2.iterPerEval() == 0) {
                    SemiConllNerPipeline$.MODULE$.epic$sequences$SemiConllNerPipeline$$eval$2(state, this.test$2, this.model$2);
                }
            }
            {
                this.params$2 = params$2;
                this.test$2 = test$2;
                this.model$2 = model$2;
            }
        }).take(params.opt().maxIterations())).last();
        SegmentationEval.Stats stats = this.epic$sequences$SemiConllNerPipeline$$eval$2(weights, test, model);
        package$.MODULE$.writeObject(params.modelOut(), model.extractCRF((DenseVector<Object>)((DenseVector)weights.x())));
        Predef$.MODULE$.println((Object)stats);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final SegmentationEval.Stats epic$sequences$SemiConllNerPipeline$$eval$2(FirstOrderMinimizer.State state, scala.collection.immutable.IndexedSeq test$2, SemiCRFModel model$2) {
        PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream("weights.txt")));
        Encoder qual$1 = Encoder$.MODULE$.fromIndex(model$2.featureIndex());
        DenseVector x$31 = (DenseVector)state.x();
        boolean x$32 = qual$1.decode$default$2();
        ((IterableLike)((IterableLike)qual$1.decode((Vector)x$31, x$32).iterator().toIndexedSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Feature, Object> x$10) {
                double d = x$10._2$mcD$sp();
                Predef$ predef$ = Predef$.MODULE$;
                return -RichDouble$.MODULE$.abs$extension(d);
            }
        }, (Ordering)Ordering.Double$.MODULE$)).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Feature, Object> x$11) {
                double d = x$11._2$mcD$sp();
                Predef$ predef$ = Predef$.MODULE$;
                return RichDouble$.MODULE$.abs$extension(d) > 1.0E-4;
            }
        })).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final PrintWriter out$1;

            public final void apply(Tuple2<Feature, Object> x0$1) {
                if (x0$1 != null) {
                    this.out$1.println(new StringBuilder().append(x0$1._2$mcD$sp()).append((Object)"\t").append(x0$1._1()).toString());
                    return;
                }
                throw new MatchError(x0$1);
            }
            {
                this.out$1 = out$1;
            }
        });
        SemiCRFInference crf = model$2.extractCRF((DenseVector<Object>)((DenseVector)state.x()));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Eval + ").append((Object)BoxesRunTime.boxToInteger((int)(state.iter() + 1))).toString());
        SegmentationEval.Stats stats = SegmentationEval$.MODULE$.eval(crf, test$2, SegmentationEval$.MODULE$.eval$default$3());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final: ").append((Object)stats).toString());
        out.close();
        return stats;
    }

    private SemiConllNerPipeline$() {
        MODULE$ = this;
        SerializableLogging.class.$init$((SerializableLogging)this);
    }
}

