/*
 * Decompiled with CFR 0.152.
 */
package epic.trees;

import breeze.io.FileStreams$;
import breeze.linalg.Counter2;
import breeze.linalg.Counter2$;
import breeze.storage.Zero;
import epic.trees.HeadDB;
import epic.trees.HeadDB$;
import epic.trees.HeadFinder;
import epic.trees.PartialTreeProcessor;
import epic.trees.SimpleTreebank;
import epic.trees.Span$;
import epic.trees.SupervisedHeadFinder;
import epic.trees.SupervisedHeadFinderInnards$;
import epic.trees.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SupervisedHeadFinder$ {
    public static final SupervisedHeadFinder$ MODULE$;

    static {
        new SupervisedHeadFinder$();
    }

    public HeadFinder<String> trainHeadFinderFromFiles(String ptbPath, String conllPath) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Training supervised head finder from PTB trees at ").append((Object)ptbPath).append((Object)" and CoNLL trees at ").append((Object)conllPath).toString());
        SimpleTreebank treebank = new SimpleTreebank(new File(ptbPath), new File(ptbPath), new File(ptbPath));
        PartialTreeProcessor process = new PartialTreeProcessor();
        Seq processedTrees = (Seq)treebank.train().trees().toSeq().map((Function1)new Serializable(process){
            public static final long serialVersionUID = 0L;
            private final PartialTreeProcessor process$1;

            public final Tree<String> apply(Tuple2<Tree<String>, IndexedSeq<String>> treeWordsPair) {
                return this.process$1.apply((Tree)treeWordsPair._1());
            }
            {
                this.process$1 = process$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq<Seq<Object>> conllTrees = this.readDepTrees(conllPath);
        if (processedTrees.size() != conllTrees.size()) {
            throw new RuntimeException(new StringBuilder().append((Object)"Error in training the supervised head finder: dep and const trees don't match: ").append((Object)BoxesRunTime.boxToInteger((int)processedTrees.size())).append((Object)" const but ").append((Object)BoxesRunTime.boxToInteger((int)conllTrees.size())).append((Object)" dep").toString());
        }
        Counter2 symbolArityHeadChildCounts = Counter2$.MODULE$.apply((Zero)Zero.IntZero$.MODULE$);
        Counter2 ruleHeadChildCounts = Counter2$.MODULE$.apply((Zero)Zero.IntZero$.MODULE$);
        IntRef numMatched = IntRef.create((int)0);
        ((IterableLike)conllTrees.zip((GenIterable)processedTrees, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(symbolArityHeadChildCounts, ruleHeadChildCounts, numMatched){
            public static final long serialVersionUID = 0L;
            private final Counter2 symbolArityHeadChildCounts$1;
            private final Counter2 ruleHeadChildCounts$1;
            private final IntRef numMatched$1;

            public final void apply(Tuple2<Seq<Object>, Tree<String>> x0$1) {
                if (x0$1 != null) {
                    if (((SeqLike)x0$1._1()).size() == Span$.MODULE$.length$extension(((Tree)x0$1._2()).span())) {
                        SupervisedHeadFinder$.MODULE$.epic$trees$SupervisedHeadFinder$$rec$1((Tree)x0$1._2(), (Seq)x0$1._1(), this.symbolArityHeadChildCounts$1, this.ruleHeadChildCounts$1);
                        ++this.numMatched$1.elem;
                    }
                    return;
                }
                throw new MatchError(x0$1);
            }
            {
                this.symbolArityHeadChildCounts$1 = symbolArityHeadChildCounts$1;
                this.ruleHeadChildCounts$1 = ruleHeadChildCounts$1;
                this.numMatched$1 = numMatched$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Head finder trained; lengths matched on ").append((Object)BoxesRunTime.boxToInteger((int)numMatched.elem)).append((Object)" / ").append((Object)BoxesRunTime.boxToInteger((int)conllTrees.size())).append((Object)" trees").toString());
        return new SupervisedHeadFinder<String>(SupervisedHeadFinderInnards$.MODULE$.fromHeadDB(new HeadDB(symbolArityHeadChildCounts, ruleHeadChildCounts, HeadDB$.MODULE$.$lessinit$greater$default$3())));
    }

    public Seq<Seq<Object>> readDepTrees(String conllPath) {
        InputStream in = FileStreams$.MODULE$.input(new File(conllPath));
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        ArrayBuffer trees2 = new ArrayBuffer();
        ArrayBuffer currSent = new ArrayBuffer();
        while (br.ready()) {
            ArrayBuffer arrayBuffer;
            String line = br.readLine();
            if (line.trim().isEmpty()) {
                Object object = currSent.nonEmpty() ? trees2.$plus$eq(this.conllToTree((Seq<Seq<String>>)currSent)) : BoxedUnit.UNIT;
                currSent = new ArrayBuffer();
                arrayBuffer = BoxedUnit.UNIT;
                continue;
            }
            arrayBuffer = currSent.$plus$eq((Object)Predef$.MODULE$.wrapRefArray((Object[])line.split("\\s+")));
        }
        Object object = currSent.nonEmpty() ? trees2.$plus$eq(this.conllToTree((Seq<Seq<String>>)currSent)) : BoxedUnit.UNIT;
        return trees2;
    }

    public Seq<Object> conllToTree(Seq<Seq<String>> sent) {
        return (Seq)sent.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<String> x$3) {
                String string = (String)x$3.apply(6);
                Predef$ predef$ = Predef$.MODULE$;
                return new StringOps(string).toInt() - 1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public final void epic$trees$SupervisedHeadFinder$$rec$1(Tree tree, Seq conllTree, Counter2 symbolArityHeadChildCounts$1, Counter2 ruleHeadChildCounts$1) {
        block6: {
            IntRef headIdx;
            String label2;
            block7: {
                if (tree.isLeaf()) break block6;
                label2 = (String)tree.label();
                headIdx = IntRef.create((int)-1);
                long l = tree.span();
                Span$ span$ = Span$.MODULE$;
                int n = (int)(l >>> 32);
                Predef$ predef$ = Predef$.MODULE$;
                long l2 = tree.span();
                Span$ span$2 = Span$.MODULE$;
                int n2 = (int)l2;
                Range range = Range$.MODULE$.apply(n, n2);
                if (range.isEmpty()) break block7;
                int n3 = range.start();
                while (true) {
                    block9: {
                        block8: {
                            long l3 = tree.span();
                            Span$ span$3 = Span$.MODULE$;
                            if (BoxesRunTime.unboxToInt((Object)conllTree.apply(n3)) < (int)(l3 >>> 32)) break block8;
                            long l4 = tree.span();
                            Span$ span$4 = Span$.MODULE$;
                            if (BoxesRunTime.unboxToInt((Object)conllTree.apply(n3)) < (int)l4) break block9;
                        }
                        headIdx.elem = n3;
                    }
                    if (n3 == range.lastElement()) break;
                    n3 += range.step();
                }
            }
            if (headIdx.elem != -1) {
                int childIdx = 0;
                while (true) {
                    long l = ((Tree)tree.children().apply(childIdx)).span();
                    Span$ span$ = Span$.MODULE$;
                    if ((int)l > headIdx.elem) break;
                    ++childIdx;
                }
                Predef$ predef$ = Predef$.MODULE$;
                Integer n = BoxesRunTime.boxToInteger((int)tree.children().size());
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                Tuple2 tuple2 = new Tuple2((Object)label2, (Object)n);
                symbolArityHeadChildCounts$1.update((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)childIdx), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)symbolArityHeadChildCounts$1.apply((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)childIdx))) + 1)));
                Predef$ predef$2 = Predef$.MODULE$;
                Object object = tree.children().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tree<String> x$1) {
                        return x$1.label();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                Tuple2 tuple22 = new Tuple2((Object)label2, object);
                ruleHeadChildCounts$1.update((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)childIdx), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)ruleHeadChildCounts$1.apply((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)childIdx))) + 1)));
            }
            tree.children().foreach((Function1)new Serializable(symbolArityHeadChildCounts$1, ruleHeadChildCounts$1, conllTree){
                public static final long serialVersionUID = 0L;
                private final Counter2 symbolArityHeadChildCounts$1;
                private final Counter2 ruleHeadChildCounts$1;
                private final Seq conllTree$1;

                public final void apply(Tree<String> x$2) {
                    SupervisedHeadFinder$.MODULE$.epic$trees$SupervisedHeadFinder$$rec$1(x$2, this.conllTree$1, this.symbolArityHeadChildCounts$1, this.ruleHeadChildCounts$1);
                }
                {
                    this.symbolArityHeadChildCounts$1 = symbolArityHeadChildCounts$1;
                    this.ruleHeadChildCounts$1 = ruleHeadChildCounts$1;
                    this.conllTree$1 = conllTree$1;
                }
            });
        }
    }

    private SupervisedHeadFinder$() {
        MODULE$ = this;
    }
}

