/*
 * Decompiled with CFR 0.152.
 */
package epic.util;

import breeze.config.CommandLineParser$;
import breeze.config.Configuration;
import breeze.config.GenerateHelp$;
import epic.preprocess.JavaSentenceSegmenter;
import epic.preprocess.JavaSentenceSegmenter$;
import epic.preprocess.MLSentenceSegmenter$;
import epic.preprocess.NewLineSentenceSegmenter;
import epic.preprocess.NewLineSentenceSegmenter$;
import epic.preprocess.SentenceSegmenter;
import epic.preprocess.StreamSentenceSegmenter;
import epic.preprocess.StreamSentenceSegmenter$;
import epic.preprocess.Tokenizer;
import epic.preprocess.TreebankTokenizer;
import epic.preprocess.WhitespaceTokenizer;
import epic.util.FIFOWorkQueue;
import epic.util.FIFOWorkQueue$;
import epic.util.ProcessTextMain;
import epic.util.ProcessTextMain$;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.package$;
import scala.reflect.ManifestFactory$;

public abstract class ProcessTextMain$class {
    public static String renderFailed(ProcessTextMain $this, Object model, IndexedSeq tokens, Throwable reason) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"### Could not tag ", ", because ", "... ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tokens, reason.getMessage(), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])reason.getStackTrace()).take(2)).mkString(";")})).replaceAll("\n", " ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(ProcessTextMain $this, String[] args) {
        Tokenizer tokenizer;
        SentenceSegmenter sentenceSegmenter2;
        Object object;
        ProcessTextMain.Params params;
        Tuple2 tuple2 = CommandLineParser$.MODULE$.parseArguments((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        Configuration baseConfig = (Configuration)tuple22._1();
        IndexedSeq files = (IndexedSeq)tuple22._2();
        Configuration config = baseConfig;
        try {
            params = (ProcessTextMain.Params)baseConfig.readIn("", baseConfig.readIn$default$2(), ManifestFactory$.MODULE$.classType(ProcessTextMain.Params.class));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(GenerateHelp$.MODULE$.apply(config, ManifestFactory$.MODULE$.classType(ProcessTextMain.Params.class)));
            throw scala.sys.package$.MODULE$.exit(1);
        }
        try {
            object = epic.models.package$.MODULE$.deserialize(params.model().toString());
        }
        catch (Exception exception) {
            System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't deserialize model due to exception, ", ". Trying classPathLoad..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getCause().getMessage()})));
            object = $this.classPathLoad(params.model().toString());
        }
        Object model = object;
        String string = params.sentences().toLowerCase();
        if ("java".equals(string)) {
            sentenceSegmenter2 = new JavaSentenceSegmenter(JavaSentenceSegmenter$.MODULE$.$lessinit$greater$default$1());
        } else {
            boolean bl = "default".equals(string) ? true : "trained".equals(string);
            if (bl) {
                sentenceSegmenter2 = (SentenceSegmenter)MLSentenceSegmenter$.MODULE$.bundled(MLSentenceSegmenter$.MODULE$.bundled$default$1()).get();
            } else {
                if (!"newline".equals(string)) throw new MatchError((Object)string);
                sentenceSegmenter2 = new NewLineSentenceSegmenter(NewLineSentenceSegmenter$.MODULE$.$lessinit$greater$default$1());
            }
        }
        StreamSentenceSegmenter sentenceSegmenter = new StreamSentenceSegmenter(sentenceSegmenter2, StreamSentenceSegmenter$.MODULE$.$lessinit$greater$default$2());
        String string2 = params.tokens().toLowerCase();
        boolean bl = "default".equals(string2) ? true : "treebank".equals(string2);
        if (bl) {
            tokenizer = new TreebankTokenizer();
        } else {
            bl = "none".equals(string2) ? true : "whitespace".equals(string2);
            if (!bl) throw new MatchError((Object)string2);
            tokenizer = new WhitespaceTokenizer();
        }
        ExecutionContextExecutor context = params.threads() > 0 ? ExecutionContext$.MODULE$.fromExecutor((Executor)new ThreadPoolExecutor(1, params.threads(), 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>())) : ExecutionContext$.MODULE$.global();
        Iterator iter = files.isEmpty() ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputStream[]{System.in})) : files.iterator().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final FileInputStream apply(String x$2) {
                return new FileInputStream(x$2);
            }
        });
        iter.foreach((Function1)new Serializable($this, params, model, sentenceSegmenter, tokenizer, context){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ProcessTextMain $outer;
            public final ProcessTextMain.Params params$1;
            public final Object model$1;
            private final StreamSentenceSegmenter sentenceSegmenter$1;
            public final Tokenizer tokenizer$1;
            private final ExecutionContextExecutor context$1;

            public final void apply(InputStream src) {
                FIFOWorkQueue<String, Out> queue = FIFOWorkQueue$.MODULE$.apply(this.sentenceSegmenter$1.sentences(src), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProcessTextMain$.anonfun.main.1 $outer;

                    public final String apply(String sent) {
                        String string;
                        scala.collection.immutable.IndexedSeq tokens;
                        block3: {
                            tokens = this.$outer.tokenizer$1.apply(sent).toIndexedSeq();
                            if (tokens.length() <= this.$outer.params$1.maxLength()) break block3;
                            ProcessTextMain.SentenceTooLongException sentenceTooLongException = new ProcessTextMain.SentenceTooLongException(tokens.length());
                            string = this.$outer.$outer.renderFailed(this.$outer.model$1, (IndexedSeq<String>)tokens, sentenceTooLongException);
                        }
                        try {
                            ProcessTextMain$.anonfun.main.1 var2_5 = this.$outer;
                            AnnotatedType tree = var2_5.$outer.annotate(this.$outer.model$1, (IndexedSeq<String>)tokens);
                            ProcessTextMain$.anonfun.main.1 var3_7 = this.$outer;
                            string = var3_7.$outer.render(this.$outer.model$1, tree, (IndexedSeq<String>)tokens);
                        }
                        catch (Exception exception) {
                            string = this.$outer.$outer.renderFailed(this.$outer.model$1, (IndexedSeq<String>)tokens, exception);
                        }
                        return string;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (ExecutionContext)this.context$1);
                queue.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String result) {
                        Predef$.MODULE$.println((Object)result);
                    }
                });
                src.close();
            }

            public /* synthetic */ ProcessTextMain epic$util$ProcessTextMain$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var6_6;
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.params$1 = params$1;
                this.model$1 = var3_3;
                this.sentenceSegmenter$1 = var4_4;
                this.tokenizer$1 = var5_5;
                this.context$1 = var6_6;
            }
        });
    }

    public static void $init$(ProcessTextMain $this) {
    }
}

