/*
 * Decompiled with CFR 0.152.
 */
package epic.trees;

import breeze.io.FileStreams$;
import breeze.linalg.Counter2;
import breeze.linalg.Counter2$;
import breeze.storage.Zero;
import epic.trees.HeadDB;
import epic.trees.HeadDB$;
import epic.trees.HeadFinder;
import epic.trees.PartialTreeProcessor;
import epic.trees.SimpleTreebank;
import epic.trees.Span$;
import epic.trees.SupervisedHeadFinder;
import epic.trees.SupervisedHeadFinderInnards$;
import epic.trees.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class SupervisedHeadFinder$ {
    public static SupervisedHeadFinder$ MODULE$;

    static {
        new SupervisedHeadFinder$();
    }

    public HeadFinder<String> trainHeadFinderFromFiles(String ptbPath, String conllPath) {
        Predef$.MODULE$.println((Object)("Training supervised head finder from PTB trees at " + ptbPath + " and CoNLL trees at " + conllPath));
        SimpleTreebank treebank = new SimpleTreebank(new File(ptbPath), new File(ptbPath), new File(ptbPath));
        PartialTreeProcessor process = new PartialTreeProcessor();
        Seq processedTrees = (Seq)treebank.train().trees().toSeq().map((Function1 & Serializable & scala.Serializable)treeWordsPair -> process.apply((Tree)treeWordsPair._1()), Seq$.MODULE$.canBuildFrom());
        Seq<Seq<Object>> conllTrees = this.readDepTrees(conllPath);
        if (processedTrees.size() != conllTrees.size()) {
            throw new RuntimeException("Error in training the supervised head finder: dep and const trees don't match: " + processedTrees.size() + " const but " + conllTrees.size() + " dep");
        }
        Counter2 symbolArityHeadChildCounts = Counter2$.MODULE$.apply((Zero)Zero.IntZero$.MODULE$);
        Counter2 ruleHeadChildCounts = Counter2$.MODULE$.apply((Zero)Zero.IntZero$.MODULE$);
        IntRef numMatched = IntRef.create((int)0);
        ((IterableLike)conllTrees.zip((GenIterable)processedTrees, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SupervisedHeadFinder$.$anonfun$trainHeadFinderFromFiles$5(symbolArityHeadChildCounts, ruleHeadChildCounts, numMatched, x0$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)("Head finder trained; lengths matched on " + numMatched.elem + " / " + conllTrees.size() + " trees"));
        return new SupervisedHeadFinder<String>(SupervisedHeadFinderInnards$.MODULE$.fromHeadDB(new HeadDB(symbolArityHeadChildCounts, ruleHeadChildCounts, HeadDB$.MODULE$.$lessinit$greater$default$3())));
    }

    public Seq<Seq<Object>> readDepTrees(String conllPath) {
        InputStream in = FileStreams$.MODULE$.input(new File(conllPath));
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        ArrayBuffer trees = new ArrayBuffer();
        ArrayBuffer currSent = new ArrayBuffer();
        int i = 0;
        while (br.ready()) {
            String line = br.readLine();
            if (line.trim().isEmpty()) {
                if (currSent.nonEmpty()) {
                    trees.$plus$eq(this.conllToTree((Seq<Seq<String>>)currSent));
                }
                currSent = new ArrayBuffer();
            } else {
                currSent.$plus$eq((Object)Predef$.MODULE$.wrapRefArray((Object[])line.split("\\s+")));
            }
            ++i;
        }
        if (currSent.nonEmpty()) {
            trees.$plus$eq(this.conllToTree((Seq<Seq<String>>)currSent));
        }
        return trees;
    }

    public Seq<Object> conllToTree(Seq<Seq<String>> sent) {
        return (Seq)sent.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)SupervisedHeadFinder$.$anonfun$conllToTree$1(x$3)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$trainHeadFinderFromFiles$2(Tree tree$1, Seq conllTree$1, IntRef headIdx$1, int idx) {
        if (BoxesRunTime.unboxToInt((Object)conllTree$1.apply(idx)) < Span$.MODULE$.begin$extension(tree$1.span()) || BoxesRunTime.unboxToInt((Object)conllTree$1.apply(idx)) >= Span$.MODULE$.end$extension(tree$1.span())) {
            headIdx$1.elem = idx;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void rec$1(Tree tree, Seq conllTree, Counter2 symbolArityHeadChildCounts$1, Counter2 ruleHeadChildCounts$1) {
        if (!tree.isLeaf()) {
            String label = (String)tree.label();
            IntRef headIdx = IntRef.create((int)-1);
            int n = Span$.MODULE$.begin$extension(tree.span());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, Span$.MODULE$.end$extension(tree.span()));
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    SupervisedHeadFinder$.$anonfun$trainHeadFinderFromFiles$2(tree, conllTree, headIdx, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            if (headIdx.elem != -1) {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                void $minus$greater$extension_y2;
                void $minus$greater$extension_$this2;
                int childIdx = 0;
                while (Span$.MODULE$.end$extension(((Tree)tree.children().apply(childIdx)).span()) <= headIdx.elem) {
                    ++childIdx;
                }
                Integer n2 = BoxesRunTime.boxToInteger((int)tree.children().size());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)label);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
                symbolArityHeadChildCounts$1.update((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)childIdx), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)symbolArityHeadChildCounts$1.apply((Object)tuple2, (Object)BoxesRunTime.boxToInteger((int)childIdx))) + 1)));
                Object object2 = tree.children().map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.label(), IndexedSeq$.MODULE$.canBuildFrom());
                Object object3 = Predef$.MODULE$.ArrowAssoc((Object)label);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                Tuple2 tuple22 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                ruleHeadChildCounts$1.update((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)childIdx), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)ruleHeadChildCounts$1.apply((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)childIdx))) + 1)));
            }
            tree.children().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                SupervisedHeadFinder$.rec$1(x$2, conllTree, symbolArityHeadChildCounts$1, ruleHeadChildCounts$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$trainHeadFinderFromFiles$5(Counter2 symbolArityHeadChildCounts$1, Counter2 ruleHeadChildCounts$1, IntRef numMatched$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            if (((SeqLike)x0$1._1()).size() == Span$.MODULE$.length$extension(((Tree)x0$1._2()).span())) {
                SupervisedHeadFinder$.rec$1((Tree)x0$1._2(), (Seq)x0$1._1(), symbolArityHeadChildCounts$1, ruleHeadChildCounts$1);
                ++numMatched$1.elem;
                return;
            }
        } else {
            throw new MatchError((Object)x0$1);
        }
    }

    public static final /* synthetic */ int $anonfun$conllToTree$1(Seq x$3) {
        String string = (String)x$3.apply(6);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toInt() - 1;
    }

    private SupervisedHeadFinder$() {
        MODULE$ = this;
    }
}

