/*
 * Decompiled with CFR 0.152.
 */
package epic.parser.projections;

import breeze.config.CommandLineParser$;
import breeze.config.Configuration$;
import breeze.generic.UFunc;
import breeze.numerics.package;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import breeze.util.package$;
import epic.constraints.CachedChartConstraintsFactory;
import epic.constraints.ChartConstraints;
import epic.constraints.ChartConstraints$;
import epic.constraints.SpanConstraints;
import epic.parser.Parser;
import epic.parser.projections.ParserChartConstraintsFactory;
import epic.parser.projections.PrecacheConstraints;
import epic.trees.AnnotatedLabel;
import epic.trees.BinarizedTree;
import epic.trees.BinaryTree;
import epic.trees.ProcessedTreebank;
import epic.trees.Span;
import epic.trees.Span$;
import epic.trees.Tree;
import epic.trees.TreeInstance;
import epic.trees.UnaryTree;
import epic.util.CacheBroker;
import epic.util.CacheBroker$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.mapdb.Serializer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversable;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.Map;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class PrecacheConstraints$
implements SerializableLogging {
    public static PrecacheConstraints$ MODULE$;
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;

    static {
        new PrecacheConstraints$();
    }

    public LazyLogger logger() {
        return SerializableLogging.logger$((SerializableLogging)this);
    }

    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    public CachedChartConstraintsFactory<AnnotatedLabel, String> forTreebank(ParserChartConstraintsFactory<AnnotatedLabel, String> constrainer, ProcessedTreebank treebank, String tableName, boolean verifyNoGoldPruningInTrain, CacheBroker broker) {
        CachedChartConstraintsFactory<AnnotatedLabel, String> cached = this.forTrainingSet(constrainer, (GenTraversable)((ParIterableLike)treebank.trainTrees().par()).map((Function1 & Serializable & scala.Serializable)ti -> {
            BinarizedTree x$20 = ti.tree().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.baseAnnotatedLabel());
            String x$21 = ti.copy$default$1();
            IndexedSeq x$22 = ti.copy$default$3();
            return ti.copy(x$21, x$20, x$22);
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom()), tableName, verifyNoGoldPruningInTrain, broker);
        ((ParIterableLike)treebank.devTrees().par()).foreach((Function1 & Serializable & scala.Serializable)ti -> {
            PrecacheConstraints$.$anonfun$forTreebank$3(this, constrainer, verifyNoGoldPruningInTrain, cached, ti);
            return BoxedUnit.UNIT;
        });
        ((ParIterableLike)treebank.testTrees().par()).foreach((Function1 & Serializable & scala.Serializable)ti -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ensuring existing constraint for test sentence ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ti.id(), ti.words()})));
            return cached.constraints(ti.words());
        });
        return cached;
    }

    public String forTreebank$default$3() {
        return "parseConstraints";
    }

    public boolean forTreebank$default$4() {
        return true;
    }

    public <L, W> CachedChartConstraintsFactory<L, W> forTrainingSet(ParserChartConstraintsFactory<L, W> constrainer, GenTraversable<TreeInstance<L, W>> train, String tableName, boolean verifyNoGoldPruning, CacheBroker broker) {
        AtomicInteger parsed = new AtomicInteger(0);
        int len = train.size();
        Serializer x$27 = ChartConstraints$.MODULE$.serializerChartConstraints();
        broker.make$default$2(tableName);
        Map cache = broker.make(tableName, null, x$27);
        ((ParIterableLike)train.par()).foreach((Function1 & Serializable & scala.Serializable)ti -> {
            PrecacheConstraints$.$anonfun$forTrainingSet$1(this, constrainer, verifyNoGoldPruning, parsed, len, cache, ti);
            return BoxedUnit.UNIT;
        });
        broker.commit();
        return new CachedChartConstraintsFactory<L, W>(constrainer, cache);
    }

    public <L, W> String forTrainingSet$default$3() {
        return "parseConstraints";
    }

    public <L, W> boolean forTrainingSet$default$4() {
        return true;
    }

    public <W, L> void checkConstraints(TreeInstance<L, W> ti, ChartConstraints<L> constraints, ParserChartConstraintsFactory<L, W> constrainer) {
        BooleanRef printTree = BooleanRef.create((boolean)true);
        IntRef nerrors = IntRef.create((int)0);
        IntRef all = IntRef.create((int)0);
        ti.tree().allChildren().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PrecacheConstraints$.$anonfun$checkConstraints$2(this, ti, constraints, constrainer, printTree, nerrors, all, x0$1);
            return BoxedUnit.UNIT;
        });
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " pruning errors: ", "/", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ti.id(), BoxesRunTime.boxToInteger((int)nerrors$1.elem), BoxesRunTime.boxToInteger((int)all$1.elem), BoxesRunTime.boxToDouble((double)((double)nerrors$1.elem * 1.0 / (double)all$1.elem))})));
    }

    public void main(String[] args) {
        PrecacheConstraints.ProjectionParams params = (PrecacheConstraints.ProjectionParams)CommandLineParser$.MODULE$.readIn((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])args), CommandLineParser$.MODULE$.readIn$default$2(), CommandLineParser$.MODULE$.readIn$default$3(), CommandLineParser$.MODULE$.readIn$default$4(), CommandLineParser$.MODULE$.readIn$default$5(), CommandLineParser$.MODULE$.readIn$default$6(), ManifestFactory$.MODULE$.classType(PrecacheConstraints.ProjectionParams.class));
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Command line arguments for recovery:\n" + Configuration$.MODULE$.fromObject((Object)params, Configuration$.MODULE$.fromObject$default$2(), ManifestFactory$.MODULE$.classType(PrecacheConstraints.ProjectionParams.class)).toCommandLineString());
        int x$29 = 1000000;
        File x$30 = params.treebank().copy$default$1();
        boolean x$31 = params.treebank().copy$default$3();
        String x$32 = params.treebank().copy$default$4();
        String x$33 = params.treebank().copy$default$5();
        int x$34 = params.treebank().copy$default$6();
        boolean x$35 = params.treebank().copy$default$7();
        boolean x$36 = params.treebank().copy$default$8();
        String x$37 = params.treebank().copy$default$9();
        String x$38 = params.treebank().copy$default$10();
        ProcessedTreebank treebank = params.treebank().copy(x$30, x$29, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38);
        Parser parser = (Parser)package$.MODULE$.readObject(params.parser());
        params.out().getAbsoluteFile().getParentFile().mkdirs();
        ParserChartConstraintsFactory<AnnotatedLabel, String> factory = new ParserChartConstraintsFactory<AnnotatedLabel, String>(parser, (Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isIntermediate()), package.exp$.MODULE$.apply$mDDc$sp(params.threshold(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$));
        CacheBroker broker = new CacheBroker(params.out(), CacheBroker$.MODULE$.$lessinit$greater$default$2(), CacheBroker$.MODULE$.$lessinit$greater$default$3(), CacheBroker$.MODULE$.$lessinit$greater$default$4(), CacheBroker$.MODULE$.$lessinit$greater$default$5());
        this.forTreebank(factory, treebank, params.name(), this.forTreebank$default$4(), broker);
        broker.commit();
        broker.close();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$forTreebank$3(PrecacheConstraints$ $this, ParserChartConstraintsFactory constrainer$1, boolean verifyNoGoldPruningInTrain$1, CachedChartConstraintsFactory cached$1, TreeInstance ti) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ensuring existing constraint for dev tree ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ti.id(), ti.words()})));
        SpanConstraints constraints = cached$1.constraints(ti.words());
        if (verifyNoGoldPruningInTrain$1) {
            BinarizedTree x$23 = ti.tree().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.baseAnnotatedLabel());
            String x$24 = ti.copy$default$1();
            IndexedSeq x$25 = ti.copy$default$3();
            $this.checkConstraints(ti.copy(x$24, x$23, x$25), (ChartConstraints)constraints, constrainer$1);
        }
    }

    public static final /* synthetic */ void $anonfun$forTrainingSet$1(PrecacheConstraints$ $this, ParserChartConstraintsFactory constrainer$2, boolean verifyNoGoldPruning$1, AtomicInteger parsed$1, int len$1, Map cache$1, TreeInstance ti) {
        try {
            BooleanRef located = BooleanRef.create((boolean)true);
            ChartConstraints constraints = (ChartConstraints)cache$1.getOrElseUpdate(ti.words(), (Function0 & Serializable & scala.Serializable)() -> {
                located$1.elem = false;
                $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Building constraints for ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ti.id(), ti.words()})));
                return constrainer$2.constraints(ti.words());
            });
            if (located.elem) {
                $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Already had constraints for ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ti.id(), ti.words()})));
            } else if (verifyNoGoldPruning$1) {
                $this.checkConstraints(ti, constraints, constrainer$2);
            }
            int count = parsed$1.incrementAndGet();
            if (count % 10 == 0) {
                $this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Pruning statistics so far: " + constrainer$2.overallStatistics());
            }
            if (count % 100 == 0) {
                $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed ", "/", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count), BoxesRunTime.boxToInteger((int)len$1)})));
            }
        }
        catch (Exception e) {
            $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while parsing ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ti.words()})), (Throwable)e);
        }
    }

    private final void logError$1(String pos, Tree t, Set allowedSpans, TreeInstance ti$1, BooleanRef printTree$1, IntRef nerrors$1) {
        this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pruned gold ", " label ", " over span ", ":", " \\n\\tAllowed: ", ".\\n\\tSentence is ", " words long.\\n\\tin ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pos, t.label(), new Span(t.span()), Span$.MODULE$.map$extension(t.span(), ti$1.words()), allowedSpans, BoxesRunTime.boxToInteger((int)ti$1.words().length()), ti$1.tree().render(ti$1.words(), true)})));
        printTree$1.elem = false;
        ++nerrors$1.elem;
    }

    public static final /* synthetic */ Object $anonfun$checkConstraints$4(ParserChartConstraintsFactory constrainer$3, int x$11) {
        return constrainer$3.labelIndex().get(x$11);
    }

    public static final /* synthetic */ Object $anonfun$checkConstraints$6(ParserChartConstraintsFactory constrainer$3, int x$13) {
        return constrainer$3.labelIndex().get(x$13);
    }

    public static final /* synthetic */ Object $anonfun$checkConstraints$8(ParserChartConstraintsFactory constrainer$3, int x$15) {
        return constrainer$3.labelIndex().get(x$15);
    }

    public static final /* synthetic */ void $anonfun$checkConstraints$2(PrecacheConstraints$ $this, TreeInstance ti$1, ChartConstraints constraints$1, ParserChartConstraintsFactory constrainer$3, BooleanRef printTree$1, IntRef nerrors$1, IntRef all$1, Tree x0$1) {
        if (x0$1 instanceof UnaryTree) {
            UnaryTree unaryTree = (UnaryTree)x0$1;
            ++all$1.elem;
            if (!constraints$1.top().isAllowedLabeledSpan(unaryTree.begin(), unaryTree.end(), constrainer$3.labelIndex().apply(unaryTree.label()))) {
                int n = 0;
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Set allowedSpans = ((TraversableOnce)((TraversableLike)RichInt$.MODULE$.until$extension0(n, constrainer$3.labelIndex().size()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> constraints$1.top().isAllowedLabeledSpan(unaryTree.begin(), unaryTree.end(), x$10))).map((Function1 & Serializable & scala.Serializable)x$11 -> PrecacheConstraints$.$anonfun$checkConstraints$4(constrainer$3, BoxesRunTime.unboxToInt((Object)x$11)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                $this.logError$1(Span$.MODULE$.length$extension(unaryTree.span()) == 1 ? "length one unary" : "top", unaryTree, allowedSpans, ti$1, printTree$1, nerrors$1);
                return;
            }
        } else if (x0$1 instanceof BinaryTree) {
            BinaryTree binaryTree = (BinaryTree)x0$1;
            ++all$1.elem;
            if (!constraints$1.bot().isAllowedLabeledSpan(binaryTree.begin(), binaryTree.end(), constrainer$3.labelIndex().apply(binaryTree.label()))) {
                int n = 0;
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Set allowedSpans = ((TraversableOnce)((TraversableLike)RichInt$.MODULE$.until$extension0(n, constrainer$3.labelIndex().size()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$12 -> constraints$1.bot().isAllowedLabeledSpan(binaryTree.begin(), binaryTree.end(), x$12))).map((Function1 & Serializable & scala.Serializable)x$13 -> PrecacheConstraints$.$anonfun$checkConstraints$6(constrainer$3, BoxesRunTime.unboxToInt((Object)x$13)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                $this.logError$1("bot", binaryTree, allowedSpans, ti$1, printTree$1, nerrors$1);
                return;
            }
        } else {
            ++all$1.elem;
            if (!constraints$1.bot().isAllowedLabeledSpan(x0$1.begin(), x0$1.end(), constrainer$3.labelIndex().apply(x0$1.label()))) {
                int n = 0;
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Set allowedSpans = ((TraversableOnce)((TraversableLike)RichInt$.MODULE$.until$extension0(n, constrainer$3.labelIndex().size()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$14 -> constraints$1.bot().isAllowedLabeledSpan(x0$1.begin(), x0$1.end(), x$14))).map((Function1 & Serializable & scala.Serializable)x$15 -> PrecacheConstraints$.$anonfun$checkConstraints$8(constrainer$3, BoxesRunTime.unboxToInt((Object)x$15)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                $this.logError$1("tag", x0$1, allowedSpans, ti$1, printTree$1, nerrors$1);
                return;
            }
        }
    }

    private PrecacheConstraints$() {
        MODULE$ = this;
        SerializableLogging.$init$((SerializableLogging)this);
    }
}

