/*
 * Decompiled with CFR 0.152.
 */
package epic.preprocess;

import breeze.linalg.Counter;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.support.CanCopy;
import breeze.optimize.L2Regularization;
import breeze.optimize.OptimizationOption;
import breeze.optimize.OptimizationPackage;
import breeze.optimize.OptimizationPackage$;
import breeze.stats.distributions.RandBasis$;
import breeze.util.Encoder;
import breeze.util.Encoder$;
import breeze.util.Index;
import breeze.util.Index$;
import breeze.util.Iterators$;
import breeze.util.MutableIndex;
import breeze.util.package$;
import epic.corpora.MascSlab$;
import epic.features.CrossProductFeature;
import epic.features.CrossProductFeature$;
import epic.framework.Feature;
import epic.framework.Inference;
import epic.framework.ModelObjective;
import epic.framework.ModelObjective$;
import epic.preprocess.MLSentenceSegmenter;
import epic.preprocess.MLSentenceSegmenter$BiasFeature$;
import epic.preprocess.MLSentenceSegmenter$ContextWord$;
import epic.preprocess.MLSentenceSegmenter$EOFFeature$;
import epic.preprocess.MLSentenceSegmenter$LastWordLength$;
import epic.preprocess.MLSentenceSegmenter$LineIsShortFeature$;
import epic.preprocess.MLSentenceSegmenter$addIndicesWhere$;
import epic.slab.Sentence;
import epic.slab.Slab;
import epic.slab.Source;
import epic.trees.Span;
import epic.trees.Span$;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.zip.GZIPInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqOptimized;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ClassTag$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class MLSentenceSegmenter$
implements scala.Serializable {
    public static MLSentenceSegmenter$ MODULE$;
    private final IndexedSeq<Tuple2<String, scala.collection.immutable.IndexedSeq<Object>>> extraExamples;

    static {
        new MLSentenceSegmenter$();
    }

    public Option<MLSentenceSegmenter> bundled(String language) {
        String path = new StringBuilder(28).append(language).append("-sent-segmenter.model.ser.gz").toString();
        Option option = Option$.MODULE$.apply((Object)this.getClass().getResourceAsStream(path));
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)MLSentenceSegmenter$.$anonfun$bundled$1((InputStream)map_this.get()));
        return object;
    }

    public String bundled$default$1() {
        return "en";
    }

    public MLSentenceSegmenter loadModel(File file) {
        return (MLSentenceSegmenter)package$.MODULE$.readObject(file);
    }

    /*
     * WARNING - void declaration
     */
    public int nextPotentialSentenceBoundary(String text, int offset) {
        void var3_3;
        int codepoint;
        for (int start = offset + 1; start < text.length(); start += Character.charCount(codepoint)) {
            codepoint = text.codePointAt(start);
            if (!this.isPotentialSentenceBoundary(text, start, codepoint)) continue;
            return start;
        }
        return (int)var3_3;
    }

    public String codepointToString(int cp) {
        if (Character.charCount(cp) == 1 && !Character.isISOControl(cp) && !Character.isSpaceChar(cp)) {
            return ((Object)BoxesRunTime.boxToCharacter((char)((char)cp))).toString();
        }
        return Character.getName(cp);
    }

    public String epic$preprocess$MLSentenceSegmenter$$stringForCharType(int ct) {
        Object object = new Object();
        try {
            Field[] fields = Class.forName("java.lang.Character").getDeclaredFields();
            ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields));
            int foreach_len = foreach_this.length();
            for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                Field field = (Field)foreach_this.apply(foreach_i);
                MLSentenceSegmenter$.$anonfun$stringForCharType$1(ct, object, field);
            }
            return "???";
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (String)ex.value();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Feature[] featuresForEndPointDetection(String text, int offset) {
        void var8_7;
        ArrayBuffer buf = new ArrayBuffer();
        buf.$plus$eq((Object)MLSentenceSegmenter$BiasFeature$.MODULE$);
        if (offset == text.length()) {
            buf.$plus$eq((Object)MLSentenceSegmenter$EOFFeature$.MODULE$);
        }
        IndexedSeq<Feature> curCharFeatures = this.addCharFeatures(text, offset, 0);
        buf.$plus$plus$eq(curCharFeatures);
        if (this.previousLineIsShort(text, offset)) {
            buf.$plus$eq((Object)MLSentenceSegmenter$LineIsShortFeature$.MODULE$);
            curCharFeatures.foreach((Function1 & Serializable & scala.Serializable)m -> buf.$plus$eq(new CrossProductFeature<MLSentenceSegmenter$LineIsShortFeature$, Feature>(MLSentenceSegmenter$LineIsShortFeature$.MODULE$, (Feature)m, CrossProductFeature$.MODULE$.apply$default$3())));
        }
        buf.$plus$plus$eq(this.addCharFeatures(text, offset, -2));
        buf.$plus$plus$eq(this.addCharFeatures(text, offset, -1));
        buf.$plus$plus$eq(this.addCharFeatures(text, offset, 1));
        buf.$plus$plus$eq(this.addCharFeatures(text, offset, 2));
        this.addCharFeatures(text, offset, 1).foreach((Function1 & Serializable & scala.Serializable)f1 -> {
            MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$2(text, offset, buf, f1);
            return BoxedUnit.UNIT;
        });
        curCharFeatures.foreach((Function1 & Serializable & scala.Serializable)f1 -> {
            MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$4(text, offset, buf, f1);
            return BoxedUnit.UNIT;
        });
        this.addCharFeatures(text, offset, -1).foreach((Function1 & Serializable & scala.Serializable)f1 -> {
            MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$6(buf, curCharFeatures, f1);
            return BoxedUnit.UNIT;
        });
        this.addCharFeatures(text, offset, -1).foreach((Function1 & Serializable & scala.Serializable)f1 -> {
            MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$8(text, offset, buf, f1);
            return BoxedUnit.UNIT;
        });
        this.addCharFeatures(text, offset, -1).foreach((Function1 & Serializable & scala.Serializable)f1 -> {
            MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$10(text, offset, buf, curCharFeatures, f1);
            return BoxedUnit.UNIT;
        });
        this.addCharFeatures(text, offset, -1).foreach((Function1 & Serializable & scala.Serializable)f1 -> {
            MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$13(text, offset, buf, f1);
            return BoxedUnit.UNIT;
        });
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int n = offset - 2;
        StringOps lastIndexWhere_this = new StringOps(text);
        for (int lastIndexWhere_i = scala.math.package$.MODULE$.min((int)lastIndexWhere_end, lastIndexWhere_this.length() - 1); lastIndexWhere_i >= 0 && !MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$15(BoxesRunTime.unboxToChar((Object)lastIndexWhere_this.apply(lastIndexWhere_i))); --lastIndexWhere_i) {
        }
        int prevSpace = scala.math.package$.MODULE$.max((int)var8_7, -1);
        buf.$plus$eq((Object)new MLSentenceSegmenter.ContextWord(text.substring(prevSpace + 1, offset), MLSentenceSegmenter$ContextWord$.MODULE$.apply$default$2()));
        buf.$plus$eq((Object)new MLSentenceSegmenter.LastWordLength(offset - prevSpace, MLSentenceSegmenter$LastWordLength$.MODULE$.apply$default$2()));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int n2 = IndexedSeqOptimized.indexWhere$((IndexedSeqOptimized)new StringOps(text), (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$16(BoxesRunTime.unboxToChar((Object)c))), (int)(offset + 1));
        if (n2 >= 0) {
            char c2 = text.charAt(n2);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (RichChar$.MODULE$.isLetterOrDigit$extension(c2)) {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                IndexedSeqOptimized.indexWhere$((IndexedSeqOptimized)new StringOps(text), (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$17(BoxesRunTime.unboxToChar((Object)c))), (int)(n2 + 1));
            } else {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                IndexedSeqOptimized.indexWhere$((IndexedSeqOptimized)new StringOps(text), (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$18(text, n2, BoxesRunTime.unboxToChar((Object)c))), (int)(n2 + 1));
            }
            buf.$plus$eq((Object)new MLSentenceSegmenter.ContextWord(new StringBuilder(2).append(text.substring(prevSpace + 1, prevSpace + 2)).append("--").append(text.substring(n2, n2 + 1)).toString(), -3));
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int n3 = IndexedSeqOptimized.indexWhere$((IndexedSeqOptimized)new StringOps(text), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$19(BoxesRunTime.unboxToChar((Object)x$3))), (int)(offset + 1));
        if (n3 >= 0) {
            buf.$plus$eq((Object)new MLSentenceSegmenter.NextRealLetterFeature(Character.getType(text.charAt(n3))));
        }
        buf.$plus$eq((Object)new MLSentenceSegmenter.SurroundingCharFeature(offset == 0 ? "BOS" : this.codepointToString(text.codePointBefore(offset)), n2 < 0 ? "EOS" : this.codepointToString(text.codePointAt(n2))));
        buf.$plus$eq((Object)new MLSentenceSegmenter.SurroundingCharTypeFeature(offset == 0 ? -1 : Character.getType(text.codePointBefore(offset)), n2 < 0 ? -1 : Character.getType(text.codePointAt(n2))));
        buf.$plus$eq(new CrossProductFeature<Object, Object>(buf.apply(1), buf.last(), CrossProductFeature$.MODULE$.apply$default$3()));
        return (Feature[])buf.toArray(ClassTag$.MODULE$.apply(Feature.class));
    }

    public IndexedSeq<Feature> addCharFeatures(String text, int base, int rel) {
        String string;
        Object object;
        int next;
        int n;
        ArrayBuffer buf = new ArrayBuffer();
        try {
            n = text.offsetByCodePoints(base, rel);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n = next = rel > 0 ? text.length() : 0;
        }
        if (next < 0 || next >= text.length()) {
            String string2 = "###";
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            object = object2;
            string = string2;
        } else {
            int cp = text.codePointAt(next);
            String cps = this.codepointToString(cp);
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)cp));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            object = object3;
            string = cps;
        }
        String string3 = string;
        int n2 = BoxesRunTime.unboxToInt((Object)object);
        String cps = string3;
        buf.$plus$eq((Object)new MLSentenceSegmenter.CharTypeFeature(Character.getType(n2), rel));
        buf.$plus$eq((Object)new MLSentenceSegmenter.CodePointFeature(cps, rel));
        return buf.toIndexedSeq();
    }

    public boolean isQuote(char ch) {
        switch (Character.getType(ch)) {
            case 29: {
                return true;
            }
            case 30: {
                return true;
            }
            case 24: {
                return ch == '\'' || ch == '\"';
            }
        }
        return false;
    }

    public boolean isPotentialSentenceBoundary(String text, int offset, int codepoint) {
        switch (Character.getType(codepoint)) {
            case 24: {
                return codepoint != 44 && this.isProbablyNotContraction(text, offset, codepoint, '\'');
            }
            case 29: {
                return true;
            }
            case 21: {
                return true;
            }
            case 30: {
                return this.isProbablyNotContraction(text, offset, codepoint, '\u2019');
            }
            case 22: {
                return true;
            }
            case 12: {
                int before;
                return offset > 0 && !Character.isLetterOrDigit(before = text.codePointBefore(offset)) && !Character.isSpaceChar(before) && !this.isControl(before) && !this.isPotentialSentenceBoundary(text, offset - Character.charCount(before), before) && before != 44;
            }
            case 15: {
                return this.isControl(codepoint) && (offset == 0 || text.codePointBefore(offset) != 44 && (offset == text.length() - 1 || this.isControl(text.codePointAt(offset + 1)) || this.previousLineIsShort(text, offset) || Character.isUpperCase(text.codePointAt(offset + 1))));
            }
            case 28: {
                return false;
            }
        }
        return false;
    }

    public boolean isControl(int codepoint) {
        return codepoint == 13 || codepoint == 10 || codepoint == 9;
    }

    public boolean previousLineIsShort(String s, int pos) {
        int SHORT_LINE = 35;
        return pos - s.lastIndexOf(10, pos - 1) < SHORT_LINE;
    }

    public boolean isProbablyNotContraction(String text, int offset, int codepoint, char quote) {
        return codepoint != quote || offset >= text.length() - 1 || offset == 0 || !Character.isLetterOrDigit(text.codePointAt(offset + 1)) || !Character.isLetterOrDigit(text.codePointBefore(offset));
    }

    /*
     * WARNING - void declaration
     */
    public Iterator<Object> potentialSentenceBoundariesIterator(String text) {
        void fromProducer_prod;
        IntRef offset = IntRef.create((int)0);
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
            int next;
            if (offset$2.elem == text.length()) {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                if (new StringOps(text).nonEmpty()) {
                    return None$.MODULE$;
                }
            }
            if ((next = MODULE$.nextPotentialSentenceBoundary(text, offset$2.elem)) < text.length() || next != offset$2.elem + 1) {
                offset$2.elem = next;
                return new Some((Object)BoxesRunTime.boxToInteger((int)next));
            }
            return None$.MODULE$;
        };
        if (Iterators$.MODULE$ == null) {
            throw null;
        }
        return scala.package$.MODULE$.Iterator().continually((Function0)fromProducer_prod).takeWhile(Iterators$::$anonfun$fromProducer$1$adapted).map(Iterators$::$anonfun$fromProducer$2);
    }

    /*
     * WARNING - void declaration
     */
    public Set<Object> adjustGoldSentenceBoundaries(String text, Iterator<Span> _endPoints, boolean newlineIsBoundary) {
        scala.collection.immutable.IndexedSeq endPoints = (scala.collection.immutable.IndexedSeq)_endPoints.toIndexedSeq().sortBy((Function1 & Serializable & scala.Serializable)s -> MLSentenceSegmenter$.$anonfun$adjustGoldSentenceBoundaries$1(((Span)s).encoded()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        LongRef lastSpan = LongRef.create((long)Span$.MODULE$.apply(0, 0));
        Set annotated = ((scala.collection.immutable.IndexedSeq)endPoints.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = !Span$.MODULE$.unapply(((Span)check$ifrefutable$1).encoded()).isEmpty()))).withFilter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$adjustGoldSentenceBoundaries$3(lastSpan, ((Span)x$6).encoded()))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)MLSentenceSegmenter$.$anonfun$adjustGoldSentenceBoundaries$4(text, lastSpan, ((Span)x$7).encoded())), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        ObjectRef allBoundaries = ObjectRef.create((Object)annotated);
        if (newlineIsBoundary) {
            void withFilter_p;
            Tuple2[] codepoints = (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(text.codePoints().toArray())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null));
            ArrayOps.ofRef withFilter_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codepoints));
            new TraversableLike.WithFilter((TraversableLike)withFilter_this, (Function1)withFilter_p).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                MLSentenceSegmenter$.$anonfun$adjustGoldSentenceBoundaries$7(annotated, allBoundaries, codepoints, x$8);
                return BoxedUnit.UNIT;
            });
        }
        if (newlineIsBoundary) {
            Predef$.MODULE$.println(((TraversableOnce)((Set)allBoundaries.elem).$minus$minus((GenTraversableOnce)annotated)).toIndexedSeq().sorted((Ordering)Ordering.Int$.MODULE$));
        }
        return (Set)allBoundaries.elem;
    }

    private boolean isControlChar(char ccp) {
        return ccp == '\n' || ccp == '\t' || ccp == '\r';
    }

    public String addIndicesWhere(String __str) {
        return __str;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<String, scala.collection.immutable.IndexedSeq<Object>> instancesAtPeriods(String str) {
        void $minus$greater$extension_$this;
        void indicesWhere$extension_f;
        void indicesWhere$extension_$this;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$instancesAtPeriods$1(BoxesRunTime.unboxToChar((Object)x$9)));
        String string = this.addIndicesWhere(str);
        if (MLSentenceSegmenter$addIndicesWhere$.MODULE$ == null) {
            throw null;
        }
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        scala.collection.immutable.IndexedSeq indexedSeq = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(n, indicesWhere$extension_$this.length()).filter((Function1)((JFunction1.mcZI.sp & Serializable & scala.Serializable)arg_0 -> MLSentenceSegmenter$addIndicesWhere$.$anonfun$indicesWhere$1((Function1)indicesWhere$extension_f, (String)indicesWhere$extension_$this, arg_0)));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)str);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)indexedSeq);
    }

    public IndexedSeq<Tuple2<String, scala.collection.immutable.IndexedSeq<Object>>> extraExamples() {
        return this.extraExamples;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void withFilter_p;
        File mascDir = new File(args[0]);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)dir.isDirectory());
        ArrayOps.ofRef withFilter_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(new File(mascDir, "data"), "written").listFiles()));
        IndexedSeq[] sentenceBoundaryProblems = (IndexedSeq[])new TraversableLike.WithFilter((TraversableLike)withFilter_this, (Function1)withFilter_p).flatMap((Function1 & Serializable & scala.Serializable)dir -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".txt");
            }
        }))), (Function1 & Serializable & scala.Serializable)f -> {
            Slab<String, Span, Source> slab = MascSlab$.MODULE$.apply(f.toURI().toURL());
            Slab<String, Span, Sentence> slabWithSentences = MascSlab$.MODULE$.s(slab);
            String text = slab.content();
            scala.collection.immutable.IndexedSeq guessPoints = MLSentenceSegmenter$.MODULE$.potentialSentenceBoundariesIterator(slabWithSentences.content()).toIndexedSeq();
            String string = dir.getName();
            String string2 = "twitter";
            boolean newlineIsDocBoundary = string != null && string.equals(string2);
            Set<Object> goldPoints = MLSentenceSegmenter$.MODULE$.adjustGoldSentenceBoundaries(text, (Iterator<Span>)slabWithSentences.iterator(ClassTag$.MODULE$.apply(Sentence.class)).map((Function1 & Serializable & scala.Serializable)x$10 -> new Span(MLSentenceSegmenter$.$anonfun$main$4(x$10))), newlineIsDocBoundary);
            return (IndexedSeq)guessPoints.map((Function1 & Serializable & scala.Serializable)guess -> MLSentenceSegmenter$.$anonfun$main$5(text, newlineIsDocBoundary, goldPoints, f, BoxesRunTime.unboxToInt((Object)guess)), scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
        }, (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(IndexedSeq.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(IndexedSeq.class)));
        IndexedSeq extraInstances = (IndexedSeq)this.extraExamples().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).map((Function1 & Serializable & scala.Serializable)x$14 -> {
            if (x$14 == null) {
                throw new MatchError(x$14);
            }
            IndexedSeq indexedSeq = (IndexedSeq)MODULE$.potentialSentenceBoundariesIterator((String)x$14._1()).toIndexedSeq().map((Function1 & Serializable & scala.Serializable)guess -> MLSentenceSegmenter$.$anonfun$main$10(x$14, BoxesRunTime.unboxToInt((Object)guess)), scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
            return indexedSeq;
        }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
        sentenceBoundaryProblems = (IndexedSeq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sentenceBoundaryProblems)).$plus$plus((GenTraversableOnce)extraInstances, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(IndexedSeq.class)));
        MLSentenceSegmenter.SentenceDecisionInstance[] allProbs = (MLSentenceSegmenter.SentenceDecisionInstance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sentenceBoundaryProblems)).flatten((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(MLSentenceSegmenter.SentenceDecisionInstance.class));
        Tuple2 tuple2 = ((TraversableLike)((IndexedSeq)RandBasis$.MODULE$.mt0().permutation(allProbs.length).draw()).map((Function1)Predef$.MODULE$.wrapRefArray((Object[])allProbs), scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).splitAt(1000);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object object = tuple2._2();
        Object object2 = tuple2._1();
        IndexedSeq dev = (IndexedSeq)object2;
        IndexedSeq train = (IndexedSeq)object;
        MutableIndex featureIndex = Index$.MODULE$.apply((OptManifest)ClassManifestFactory$.MODULE$.classType(Feature.class));
        train.foreach((Function1 & Serializable & scala.Serializable)inst -> {
            MLSentenceSegmenter$.$anonfun$main$11(featureIndex, inst);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)train.size()));
        MLSentenceSegmenter.ClassificationModel model = new MLSentenceSegmenter.ClassificationModel((Index<Feature>)featureIndex);
        ModelObjective<MLSentenceSegmenter.SentenceDecisionInstance> obj = new ModelObjective<MLSentenceSegmenter.SentenceDecisionInstance>(model, train, ModelObjective$.MODULE$.$lessinit$greater$default$3());
        DenseVector bestWeights = (DenseVector)breeze.optimize.package$.MODULE$.minimize(obj.cached((CanCopy<DenseVector<Object>>)DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), obj.initialWeightVector(true), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptimizationOption[]{new L2Regularization(1.0)}), (OptimizationPackage)OptimizationPackage$.MODULE$.lbfgsMinimizationPackage(DenseVector$.MODULE$.space_Double(), Predef$.MODULE$.$conforms()));
        Inference inf = model.inferenceFromWeights(bestWeights);
        Encoder qual$1 = Encoder$.MODULE$.fromIndex((Index)featureIndex);
        boolean x$23 = qual$1.decode$default$2();
        Counter decoded = qual$1.decode((Vector)bestWeights, x$23);
        Predef$.MODULE$.println((Object)"Train");
        this.evalDev((MLSentenceSegmenter.ClassificationInference)inf, (IndexedSeq<MLSentenceSegmenter.SentenceDecisionInstance>)train, (Counter<Feature, Object>)decoded);
        Predef$.MODULE$.println((Object)"Dev");
        this.evalDev((MLSentenceSegmenter.ClassificationInference)inf, (IndexedSeq<MLSentenceSegmenter.SentenceDecisionInstance>)dev, (Counter<Feature, Object>)decoded);
        Predef$.MODULE$.println((Object)"Special");
        this.evalDev((MLSentenceSegmenter.ClassificationInference)inf, (IndexedSeq<MLSentenceSegmenter.SentenceDecisionInstance>)((IndexedSeq)extraInstances.flatten((Function1)Predef$.MODULE$.$conforms())), (Counter<Feature, Object>)decoded);
        MLSentenceSegmenter segmenter = new MLSentenceSegmenter((MLSentenceSegmenter.ClassificationInference)inf);
        package$.MODULE$.writeObject(new File("en-sent-segmenter.model.ser.gz"), (Object)segmenter);
    }

    private String makeStringContext(String text, int position) {
        int contextBegin = scala.math.package$.MODULE$.max(0, position - 50);
        int contextEnd = scala.math.package$.MODULE$.min(text.length(), position + 50);
        if (position != text.length()) {
            return new StringBuilder(4).append(text.substring(contextBegin, position)).append("[[").append(text.charAt(position)).append("]]").append(text.substring(position + 1, contextEnd)).toString();
        }
        return new StringBuilder(4).append(text.substring(contextBegin, position)).append("[[]]").toString();
    }

    public void evalDev(MLSentenceSegmenter.ClassificationInference inf, IndexedSeq<MLSentenceSegmenter.SentenceDecisionInstance> dev, Counter<Feature, Object> decoded) {
        IntRef right = IntRef.create((int)0);
        IntRef wrong = IntRef.create((int)0);
        IntRef tN = IntRef.create((int)0);
        IntRef fN = IntRef.create((int)0);
        IntRef tP = IntRef.create((int)0);
        IntRef fP = IntRef.create((int)0);
        dev.foreach((Function1 & Serializable & scala.Serializable)inst -> {
            MLSentenceSegmenter$.$anonfun$evalDev$1(inf, decoded, right, wrong, tN, fN, tP, fP, inst);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringBuilder(17).append("prec: ").append((double)tP.elem * 1.0 / (double)(tP.elem + fP.elem)).append(" rec: ").append((double)tP.elem * 1.0 / (double)(tP.elem + fN.elem)).append(", ").append(tP.elem).append(" ").append(tN.elem).append(" ").append(fP.elem).append(" ").append(fN.elem).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Accuracy: ").append(right.elem).append(" ").append(wrong.elem).append("... ").append((double)right.elem * 1.0 / (double)(right.elem + wrong.elem)).toString());
    }

    public void printOutSentenceBoundaries(String text, Set<Object> guessPoints, Set<Object> goldPoints) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, text.length());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                MLSentenceSegmenter$.$anonfun$printOutSentenceBoundaries$1(text, guessPoints, goldPoints, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public MLSentenceSegmenter apply(MLSentenceSegmenter.ClassificationInference inf) {
        return new MLSentenceSegmenter(inf);
    }

    public Option<MLSentenceSegmenter.ClassificationInference> unapply(MLSentenceSegmenter x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.inf());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ MLSentenceSegmenter $anonfun$bundled$1(InputStream strm) {
        MLSentenceSegmenter mLSentenceSegmenter;
        try {
            mLSentenceSegmenter = (MLSentenceSegmenter)new ObjectInputStream(new GZIPInputStream(strm)).readObject();
        }
        finally {
            if (strm != null) {
                strm.close();
            }
        }
        return mLSentenceSegmenter;
    }

    public static final /* synthetic */ void $anonfun$stringForCharType$1(int ct$1, Object nonLocalReturnKey1$1, Field f) {
        try {
            if (f.getByte(null) == ct$1) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)f.getName());
            }
        }
        catch (Exception exception) {}
    }

    public static final /* synthetic */ void $anonfun$featuresForEndPointDetection$2(String text$3, int offset$1, ArrayBuffer buf$1, Feature f1) {
        MODULE$.addCharFeatures(text$3, offset$1, 2).foreach((Function1 & Serializable & scala.Serializable)f2 -> buf$1.$plus$eq(new CrossProductFeature<Feature, Feature>(f1, (Feature)f2, CrossProductFeature$.MODULE$.apply$default$3())));
    }

    public static final /* synthetic */ void $anonfun$featuresForEndPointDetection$4(String text$3, int offset$1, ArrayBuffer buf$1, Feature f1) {
        MODULE$.addCharFeatures(text$3, offset$1, 1).foreach((Function1 & Serializable & scala.Serializable)f2 -> buf$1.$plus$eq(new CrossProductFeature<Feature, Feature>(f1, (Feature)f2, CrossProductFeature$.MODULE$.apply$default$3())));
    }

    public static final /* synthetic */ void $anonfun$featuresForEndPointDetection$6(ArrayBuffer buf$1, IndexedSeq curCharFeatures$1, Feature f1) {
        ((IterableLike)curCharFeatures$1.take(1)).foreach((Function1 & Serializable & scala.Serializable)f2 -> buf$1.$plus$eq(new CrossProductFeature<Feature, Feature>(f1, (Feature)f2, CrossProductFeature$.MODULE$.apply$default$3())));
    }

    public static final /* synthetic */ void $anonfun$featuresForEndPointDetection$8(String text$3, int offset$1, ArrayBuffer buf$1, Feature f1) {
        MODULE$.addCharFeatures(text$3, offset$1, 1).foreach((Function1 & Serializable & scala.Serializable)f2 -> buf$1.$plus$eq(new CrossProductFeature<Feature, Feature>(f1, (Feature)f2, CrossProductFeature$.MODULE$.apply$default$3())));
    }

    public static final /* synthetic */ void $anonfun$featuresForEndPointDetection$11(String text$3, int offset$1, ArrayBuffer buf$1, Feature f1$5, Feature fmid) {
        MODULE$.addCharFeatures(text$3, offset$1, 1).foreach((Function1 & Serializable & scala.Serializable)f2 -> buf$1.$plus$eq(new CrossProductFeature<Feature, CrossProductFeature<Feature, Feature>>(f1$5, new CrossProductFeature<Feature, Feature>(fmid, (Feature)f2, CrossProductFeature$.MODULE$.apply$default$3()), CrossProductFeature$.MODULE$.apply$default$3())));
    }

    public static final /* synthetic */ void $anonfun$featuresForEndPointDetection$10(String text$3, int offset$1, ArrayBuffer buf$1, IndexedSeq curCharFeatures$1, Feature f1) {
        ((IterableLike)curCharFeatures$1.take(1)).foreach((Function1 & Serializable & scala.Serializable)fmid -> {
            MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$11(text$3, offset$1, buf$1, f1, fmid);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$featuresForEndPointDetection$13(String text$3, int offset$1, ArrayBuffer buf$1, Feature f1) {
        MODULE$.addCharFeatures(text$3, offset$1, 2).foreach((Function1 & Serializable & scala.Serializable)f2 -> buf$1.$plus$eq(new CrossProductFeature<Feature, Feature>(f1, (Feature)f2, CrossProductFeature$.MODULE$.apply$default$3())));
    }

    public static final /* synthetic */ boolean $anonfun$featuresForEndPointDetection$15(char x$2) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return !RichChar$.MODULE$.isLetterOrDigit$extension(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$featuresForEndPointDetection$16(char c) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (!RichChar$.MODULE$.isSpaceChar$extension(c)) {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (!RichChar$.MODULE$.isControl$extension(c)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$featuresForEndPointDetection$17(char c) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return !RichChar$.MODULE$.isLetterOrDigit$extension(c);
    }

    public static final /* synthetic */ boolean $anonfun$featuresForEndPointDetection$18(String text$3, int nextNotSpace$1, char c) {
        return Character.getType(c) != text$3.charAt(nextNotSpace$1);
    }

    public static final /* synthetic */ boolean $anonfun$featuresForEndPointDetection$19(char x$3) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return RichChar$.MODULE$.isLetterOrDigit$extension(x$3);
    }

    public static final /* synthetic */ Tuple2 $anonfun$adjustGoldSentenceBoundaries$1(long s) {
        return new Tuple2.mcII.sp(Span$.MODULE$.begin$extension(s), Span$.MODULE$.length$extension(s));
    }

    public static final /* synthetic */ boolean $anonfun$adjustGoldSentenceBoundaries$3(LongRef lastSpan$1, long x$6) {
        if (Span$.MODULE$.unapply(x$6).isEmpty()) {
            throw new MatchError((Object)new Span(x$6));
        }
        boolean bl = !Span$.MODULE$.crosses$extension(lastSpan$1.elem, x$6) && !Span$.MODULE$.contains$extension1(lastSpan$1.elem, x$6) && !Span$.MODULE$.contains$extension1(x$6, lastSpan$1.elem);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$adjustGoldSentenceBoundaries$5(char x$5) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return !RichChar$.MODULE$.isSpaceChar$extension(x$5);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$adjustGoldSentenceBoundaries$4(String text$4, LongRef lastSpan$1, long x$7) {
        void var5_4;
        Some<Tuple2<Object, Object>> some = Span$.MODULE$.unapply(x$7);
        if (!some.isEmpty()) {
            char ccp;
            int p = scala.math.package$.MODULE$.max(((Tuple2)some.get())._2$mcI$sp(), 0);
            int cp = text$4.codePointAt(p);
            if (p > 0 && !Character.isSpaceChar(cp) && !MODULE$.isPotentialSentenceBoundary(text$4, p, cp)) {
                p -= Character.charCount(cp);
                cp = text$4.codePointAt(p);
            }
            int earliestControlChar = p;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int n = IndexedSeqOptimized.indexWhere$((IndexedSeqOptimized)new StringOps(text$4), (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$adjustGoldSentenceBoundaries$5(BoxesRunTime.unboxToChar((Object)x$5))), (int)p);
            if (n > p && MODULE$.isControlChar(ccp = text$4.charAt(n))) {
                earliestControlChar = n;
            }
            while (p > 0 && (Character.isSpaceChar(cp) || MODULE$.isControl(cp))) {
                if (!Character.isSpaceChar(cp)) {
                    earliestControlChar = p;
                }
                cp = text$4.codePointAt(p -= Character.charCount(cp));
            }
            if (!MODULE$.isPotentialSentenceBoundary(text$4, p, cp)) {
                p += Character.charCount(cp);
                cp = text$4.codePointAt(p);
            }
            if (Character.isSpaceChar(cp) && p < text$4.length()) {
                p = earliestControlChar;
                text$4.codePointAt(p);
            }
            if (Span$.MODULE$.crosses$extension(lastSpan$1.elem, x$7) || Span$.MODULE$.contains$extension1(lastSpan$1.elem, x$7)) {
                Predef$.MODULE$.println((Object)text$4.substring(Span$.MODULE$.begin$extension(lastSpan$1.elem), Span$.MODULE$.end$extension(lastSpan$1.elem)));
                Predef$.MODULE$.println((Object)text$4.substring(Span$.MODULE$.begin$extension(x$7), Span$.MODULE$.end$extension(x$7)));
                Predef$.MODULE$.println((Object)BoxesRunTime.boxToCharacter((char)text$4.charAt(p)));
                Predef$.MODULE$.println((Object)BoxesRunTime.boxToCharacter((char)text$4.charAt(Span$.MODULE$.end$extension(x$7))));
                Predef$.MODULE$.println((Object)BoxesRunTime.boxToCharacter((char)text$4.charAt(Span$.MODULE$.end$extension(lastSpan$1.elem))));
                Predef$.MODULE$.println((Object)"====");
            }
        } else {
            throw new MatchError((Object)new Span(x$7));
        }
        lastSpan$1.elem = x$7;
        return (int)var5_4;
    }

    public static final /* synthetic */ boolean $anonfun$adjustGoldSentenceBoundaries$8(ObjectRef allBoundaries$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)x0$1);
        }
        boolean bl = !Character.isSpaceChar(x0$1._1$mcI$sp()) && !MODULE$.isControl(x0$1._1$mcI$sp()) || ((Set)allBoundaries$1.elem).apply((Object)BoxesRunTime.boxToInteger((int)x0$1._2$mcI$sp()));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$adjustGoldSentenceBoundaries$9(ObjectRef allBoundaries$1, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError((Object)x0$2);
        }
        boolean bl = !Character.isSpaceChar(x0$2._1$mcI$sp()) && !MODULE$.isControl(x0$2._1$mcI$sp()) || ((Set)allBoundaries$1.elem).apply((Object)BoxesRunTime.boxToInteger((int)x0$2._2$mcI$sp()));
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$adjustGoldSentenceBoundaries$7(Set annotated$1, ObjectRef allBoundaries$1, Tuple2[] codepoints$1, Tuple2 x$8) {
        if (x$8 != null) {
            if (x$8._1$mcI$sp() == 10 && !annotated$1.apply((Object)BoxesRunTime.boxToInteger((int)x$8._2$mcI$sp()))) {
                void var6_6;
                Tuple2 tuple2;
                int n = x$8._2$mcI$sp();
                ArrayOps.ofRef lastIndexWhere_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codepoints$1));
                for (int lastIndexWhere_i = scala.math.package$.MODULE$.min((int)lastIndexWhere_end, lastIndexWhere_this.length() - 1); lastIndexWhere_i >= 0 && !MLSentenceSegmenter$.$anonfun$adjustGoldSentenceBoundaries$8(allBoundaries$1, tuple2 = (Tuple2)lastIndexWhere_this.apply(lastIndexWhere_i)); --lastIndexWhere_i) {
                }
                int n2 = IndexedSeqOptimized.indexWhere$((IndexedSeqOptimized)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codepoints$1)), (Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$adjustGoldSentenceBoundaries$9(allBoundaries$1, x0$2)), (int)x$8._2$mcI$sp());
                if (var6_6 != -1 && !((Set)allBoundaries$1.elem).apply((Object)BoxesRunTime.boxToInteger((int)var6_6)) && n2 != -1 && !((Set)allBoundaries$1.elem).apply((Object)BoxesRunTime.boxToInteger((int)n2))) {
                    allBoundaries$1.elem = (Set)((Set)allBoundaries$1.elem).$plus((Object)BoxesRunTime.boxToInteger((int)x$8._2$mcI$sp()));
                    return;
                }
            }
        } else {
            throw new MatchError((Object)x$8);
        }
    }

    public static final /* synthetic */ boolean $anonfun$instancesAtPeriods$1(char x$9) {
        return x$9 == '.';
    }

    public static final /* synthetic */ long $anonfun$main$4(Tuple2 x$10) {
        return ((Span)x$10._1()).encoded();
    }

    public static final /* synthetic */ boolean $anonfun$main$6(char x$11) {
        return x$11 == '\n';
    }

    public static final /* synthetic */ boolean $anonfun$main$7(char x$12) {
        return x$12 == '\n';
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ MLSentenceSegmenter.SentenceDecisionInstance $anonfun$main$5(String text$5, boolean newlineIsDocBoundary$1, Set goldPoints$1, File f$2, int guess) {
        Tuple2 tuple2;
        if (newlineIsDocBoundary$1 && guess > 0) {
            int n;
            void var13_7;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int n2 = guess - 1;
            StringOps lastIndexWhere_this = new StringOps(text$5);
            for (int lastIndexWhere_i = scala.math.package$.MODULE$.min((int)lastIndexWhere_end, lastIndexWhere_this.length() - 1); lastIndexWhere_i >= 0 && !MLSentenceSegmenter$.$anonfun$main$6(BoxesRunTime.unboxToChar((Object)lastIndexWhere_this.apply(lastIndexWhere_i))); --lastIndexWhere_i) {
            }
            int mostRecentNewline = var13_7;
            if (var13_7 < false) {
                mostRecentNewline = 0;
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int nextNewline = n = IndexedSeqOptimized.indexWhere$((IndexedSeqOptimized)new StringOps(text$5), (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$main$7(BoxesRunTime.unboxToChar((Object)x$12))), (int)guess);
            if (n < 0) {
                nextNewline = text$5.length();
            }
            tuple2 = new Tuple2((Object)text$5.substring(mostRecentNewline, nextNewline), (Object)BoxesRunTime.boxToInteger((int)(guess - mostRecentNewline)));
        } else {
            tuple2 = new Tuple2((Object)text$5, (Object)BoxesRunTime.boxToInteger((int)guess));
        }
        Tuple2 tuple22 = tuple2;
        int n = tuple22._2$mcI$sp();
        String textForFeatures = (String)tuple22._1();
        String contextForFeatures = MODULE$.makeStringContext(textForFeatures, n);
        Feature[] features = MODULE$.featuresForEndPointDetection(textForFeatures, n);
        return new MLSentenceSegmenter.SentenceDecisionInstance(goldPoints$1.contains((Object)BoxesRunTime.boxToInteger((int)guess)), features, new StringBuilder(1).append(f$2.getName()).append(":").append(guess).toString(), contextForFeatures);
    }

    public static final /* synthetic */ MLSentenceSegmenter.SentenceDecisionInstance $anonfun$main$10(Tuple2 x1$1, int guess) {
        String context = MODULE$.makeStringContext((String)x1$1._1(), guess);
        Feature[] features = MODULE$.featuresForEndPointDetection((String)x1$1._1(), guess);
        return new MLSentenceSegmenter.SentenceDecisionInstance(((SeqLike)x1$1._2()).contains((Object)BoxesRunTime.boxToInteger((int)guess)), features, new StringBuilder(1).append(x1$1._1()).append(":").append(guess).toString(), context);
    }

    public static final /* synthetic */ void $anonfun$main$11(MutableIndex featureIndex$1, MLSentenceSegmenter.SentenceDecisionInstance inst) {
        ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inst.features()));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            Feature feature = (Feature)foreach_this.apply(foreach_i);
            featureIndex$1.index((Object)feature);
        }
    }

    public static final /* synthetic */ double $anonfun$evalDev$4(Tuple2 x$17) {
        double d = x$17._2$mcD$sp();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return -RichDouble$.MODULE$.abs$extension(d);
    }

    public static final /* synthetic */ void $anonfun$evalDev$1(MLSentenceSegmenter.ClassificationInference inf$1, Counter decoded$1, IntRef right$1, IntRef wrong$1, IntRef tN$1, IntRef fN$1, IntRef tP$1, IntRef fP$1, MLSentenceSegmenter.SentenceDecisionInstance inst) {
        if (inst.label() != inf$1.classify(inst.features())) {
            scala.collection.immutable.IndexedSeq weights = (scala.collection.immutable.IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inst.features())).toIndexedSeq().map((Function1 & Serializable & scala.Serializable)f -> {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                Object object = decoded$1.apply(f);
                Object object2 = Predef$.MODULE$.ArrowAssoc(f);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            }, IndexedSeq$.MODULE$.canBuildFrom());
            double sum = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)weights.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble((double)x$16._2$mcD$sp()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            Predef$.MODULE$.println((Object)"===========");
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("label: ").append(inst.label()).append(" id: ").append(inst.id()).append(" score: ").append(sum).toString());
            Predef$.MODULE$.println((Object)inst.context());
            Predef$.MODULE$.println((Object)new Tuple2(((IterableLike)((TraversableLike)weights.sortBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble((double)MLSentenceSegmenter$.$anonfun$evalDev$4(x$17)), (Ordering)Ordering.Double$.MODULE$)).scanLeft((Object)new Tuple3(null, (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), (Function2 & Serializable & scala.Serializable)(acc, z) -> new Tuple3(z._1(), (Object)BoxesRunTime.boxToDouble((double)z._2$mcD$sp()), (Object)BoxesRunTime.boxToDouble((double)(z._2$mcD$sp() + BoxesRunTime.unboxToDouble((Object)acc._3())))), IndexedSeq$.MODULE$.canBuildFrom())).drop(1), (Object)BoxesRunTime.boxToDouble((double)sum)));
            ++wrong$1.elem;
            if (inst.label()) {
                ++fN$1.elem;
                return;
            }
            ++fP$1.elem;
            return;
        }
        if (inst.label()) {
            ++tP$1.elem;
        } else {
            ++tN$1.elem;
        }
        ++right$1.elem;
    }

    public static final /* synthetic */ void $anonfun$printOutSentenceBoundaries$1(String text$6, Set guessPoints$1, Set goldPoints$2, int pos) {
        if (guessPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)pos)) && goldPoints$2.apply((Object)BoxesRunTime.boxToInteger((int)pos))) {
            Predef$.MODULE$.print((Object)"[=");
        } else if (goldPoints$2.apply((Object)BoxesRunTime.boxToInteger((int)pos))) {
            Predef$.MODULE$.print((Object)"[[");
        } else if (guessPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)pos))) {
            Predef$.MODULE$.print((Object)"{{");
        }
        Predef$.MODULE$.print((Object)BoxesRunTime.boxToCharacter((char)text$6.charAt(pos)));
        if (guessPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)pos)) && goldPoints$2.apply((Object)BoxesRunTime.boxToInteger((int)pos))) {
            Predef$.MODULE$.print((Object)"=]");
            return;
        }
        if (goldPoints$2.apply((Object)BoxesRunTime.boxToInteger((int)pos))) {
            Predef$.MODULE$.print((Object)"]]");
            return;
        }
        if (guessPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)pos))) {
            Predef$.MODULE$.print((Object)"}}");
        }
    }

    private MLSentenceSegmenter$() {
        MODULE$ = this;
        this.extraExamples = (IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.instancesAtPeriods("Hello to you.Let's go outside."), this.instancesAtPeriods("Among the items up for sale: the Singer sewing machine the embattled domestic diva used to sew her own wedding dress back in 1961. He also hocked the double boiler."), this.instancesAtPeriods("too expensive. do you have anything cheaper."), this.instancesAtPeriods("i'm planning a trip to san diego. flying from chicago on 1/3 returning 1/7.")}));
    }

    public static final /* synthetic */ Object $anonfun$stringForCharType$1$adapted(int ct$1, Object nonLocalReturnKey1$1, Field f) {
        MLSentenceSegmenter$.$anonfun$stringForCharType$1(ct$1, nonLocalReturnKey1$1, f);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$featuresForEndPointDetection$15$adapted(Object x$2) {
        return BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$featuresForEndPointDetection$15(BoxesRunTime.unboxToChar((Object)x$2)));
    }

    public static final /* synthetic */ Object $anonfun$adjustGoldSentenceBoundaries$8$adapted(ObjectRef allBoundaries$1, Tuple2 x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$adjustGoldSentenceBoundaries$8(allBoundaries$1, x0$1));
    }

    public static final /* synthetic */ Object $anonfun$main$6$adapted(Object x$11) {
        return BoxesRunTime.boxToBoolean((boolean)MLSentenceSegmenter$.$anonfun$main$6(BoxesRunTime.unboxToChar((Object)x$11)));
    }

    public static final /* synthetic */ Object $anonfun$main$12$adapted(MutableIndex featureIndex$1, Feature f) {
        return BoxesRunTime.boxToInteger((int)featureIndex$1.index((Object)f));
    }
}

