/*
 * Decompiled with CFR 0.152.
 */
package epic.trees;

import breeze.config.Help;
import epic.trees.AnnotatedLabel;
import epic.trees.AnnotatedLabel$;
import epic.trees.BinarizedTree;
import epic.trees.HeadFinder;
import epic.trees.HeadFinder$;
import epic.trees.ProcessedTreebank$;
import epic.trees.SimpleTreebank;
import epic.trees.SimpleTreebank$;
import epic.trees.StandardTreeProcessor;
import epic.trees.StandardTreeProcessor$;
import epic.trees.SupervisedHeadFinder$;
import epic.trees.Tree;
import epic.trees.TreeInstance;
import epic.trees.Treebank;
import epic.trees.Treebank$;
import epic.trees.UnaryChainCollapser$;
import epic.util.ArabicNormalization$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple10;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Help(text="Parameters for reading and processing a treebank.")
@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001B\u0001\u0003\u0001\u001e\u0011\u0011\u0003\u0015:pG\u0016\u001c8/\u001a3Ue\u0016,'-\u00198l\u0015\t\u0019A!A\u0003ue\u0016,7OC\u0001\u0006\u0003\u0011)\u0007/[2\u0004\u0001M!\u0001\u0001\u0003\b\u0012!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011\u0011bD\u0005\u0003!)\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\n%%\u00111C\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t+\u0001\u0011)\u001a!C\u0001-\u0005!\u0001/\u0019;i+\u00059\u0002C\u0001\r\u001e\u001b\u0005I\"B\u0001\u000e\u001c\u0003\tIwNC\u0001\u001d\u0003\u0011Q\u0017M^1\n\u0005yI\"\u0001\u0002$jY\u0016D\u0001\u0002\t\u0001\u0003\u0012\u0003\u0006IaF\u0001\u0006a\u0006$\b\u000e\t\u0005\tE\u0001\u0011)\u001a!C\u0001G\u0005IQ.\u0019=MK:<G\u000f[\u000b\u0002IA\u0011\u0011\"J\u0005\u0003M)\u00111!\u00138u\u0011!A\u0003A!E!\u0002\u0013!\u0013AC7bq2+gn\u001a;iA!A!\u0006\u0001BK\u0002\u0013\u00051&A\tj]\u000edW\u000fZ3EKZLe\u000e\u0016:bS:,\u0012\u0001\f\t\u0003\u00135J!A\f\u0006\u0003\u000f\t{w\u000e\\3b]\"A\u0001\u0007\u0001B\tB\u0003%A&\u0001\nj]\u000edW\u000fZ3EKZLe\u000e\u0016:bS:\u0004\u0003\u0002\u0003\u001a\u0001\u0005+\u0007I\u0011A\u001a\u0002\u0019\tLg.\u0019:ju\u0006$\u0018n\u001c8\u0016\u0003Q\u0002\"!\u000e\u001f\u000f\u0005YR\u0004CA\u001c\u000b\u001b\u0005A$BA\u001d\u0007\u0003\u0019a$o\\8u}%\u00111HC\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<\u0015!A\u0001\t\u0001B\tB\u0003%A'A\u0007cS:\f'/\u001b>bi&|g\u000e\t\u0005\t\u0005\u0002\u0011)\u001a!C\u0001g\u0005aAO]3fE\u0006t7\u000eV=qK\"AA\t\u0001B\tB\u0003%A'A\u0007ue\u0016,'-\u00198l)f\u0004X\r\t\u0005\t\r\u0002\u0011)\u001a!C\u0001G\u0005aa.^7TK:$XM\\2fg\"A\u0001\n\u0001B\tB\u0003%A%A\u0007ok6\u001cVM\u001c;f]\u000e,7\u000f\t\u0005\t\u0015\u0002\u0011)\u001a!C\u0001W\u0005A2.Z3q+:\f'/_\"iC&t7O\u0012:p[R\u0013\u0018-\u001b8\t\u00111\u0003!\u0011#Q\u0001\n1\n\u0011d[3faVs\u0017M]=DQ\u0006Lgn\u001d$s_6$&/Y5oA!Aa\n\u0001BK\u0002\u0013\u00051&A\beK\n,8m[<bYR,'/\u001b>f\u0011!\u0001\u0006A!E!\u0002\u0013a\u0013\u0001\u00053fEV\u001c7n^1mi\u0016\u0014\u0018N_3!\u0011!\u0011\u0006A!f\u0001\n\u0003\u0019\u0014aG:va\u0016\u0014h/[:fI\"+\u0017\r\u001a$j]\u0012,'\u000f\u0015;c!\u0006$\b\u000e\u0003\u0005U\u0001\tE\t\u0015!\u00035\u0003q\u0019X\u000f]3sm&\u001cX\r\u001a%fC\u00124\u0015N\u001c3feB#(\rU1uQ\u0002B\u0001B\u0016\u0001\u0003\u0016\u0004%\taM\u0001\u001egV\u0004XM\u001d<jg\u0016$\u0007*Z1e\r&tG-\u001a:D_:dG\u000eU1uQ\"A\u0001\f\u0001B\tB\u0003%A'\u0001\u0010tkB,'O^5tK\u0012DU-\u00193GS:$WM]\"p]2d\u0007+\u0019;iA!)!\f\u0001C\u00017\u00061A(\u001b8jiz\"2\u0002\u00180l_N<\b0\u001f>|yB\u0011Q\fA\u0007\u0002\u0005!)Q#\u0017a\u0001/!\"a\f\u00195j!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0004d_:4\u0017n\u001a\u0006\u0002K\u00061!M]3fu\u0016L!a\u001a2\u0003\t!+G\u000e]\u0001\u0005i\u0016DH/I\u0001k\u0003\tbunY1uS>t\u0007e\u001c4!i\",\u0007\u0005\u001e:fK\n\fgn\u001b\u0011eSJ,7\r^8ss\"9!%\u0017I\u0001\u0002\u0004!\u0003\u0006B6aQ6\f\u0013A\\\u0001\"\u001b\u0006D\b\u0005\\3oORD\u0007EZ8sAQ\u0014\u0018-\u001b8j]\u001e\u00043/\u001a8uK:\u001cWm\u001d\u0005\bUe\u0003\n\u00111\u0001-Q\u0011y\u0007\r[9\"\u0003I\fAi\u00155pk2$\u0007e^3!C\u0012$\u0007\u0005\u001e5fA\u0011,g\u000fI:fi\u00022wN\u001d\u0011ue\u0006Lg.\u001b8hY\u0001\"w\u000e\t;iSN\u0004sN\u001c7zA\u0019|'\u000f\t4j]\u0006d\u0007\u0005^3ti:BqAM-\u0011\u0002\u0003\u0007A\u0007\u000b\u0003tA\",\u0018%\u0001<\u0002\u0015^C\u0017\r\u001e\u0011lS:$\u0007e\u001c4!E&t\u0017M]5{CRLwN\u001c\u0011u_\u0002\"wN\f\u0011PaRLwN\\:;A1,g\r\u001e\u0017!e&<\u0007\u000e\u001e\u0017!Q\u0016\fGM\f\u0011IK\u0006$\u0007%[:!E\u0016\u001cHO\f\u0005\b\u0005f\u0003\n\u00111\u00015\u0011\u001d1\u0015\f%AA\u0002\u0011BqAS-\u0011\u0002\u0003\u0007A\u0006C\u0004O3B\u0005\t\u0019\u0001\u0017\t\u000fIK\u0006\u0013!a\u0001i!9a+\u0017I\u0001\u0002\u0004!\u0004\u0002\u0003@\u0001\u0011\u000b\u0007I\u0011A@\u0002\u0011Q\u0014X-\u001a2b].,\"!!\u0001\u0011\tu\u000b\u0019\u0001N\u0005\u0004\u0003\u000b\u0011!\u0001\u0003+sK\u0016\u0014\u0017M\\6\t\u0015\u0005%\u0001\u0001#b\u0001\n\u0003\tY!\u0001\u0006ue\u0006Lg\u000e\u0016:fKN,\"!!\u0004\u0011\r\u0005=\u0011\u0011DA\u0010\u001d\u0011\t\t\"!\u0006\u000f\u0007]\n\u0019\"C\u0001\f\u0013\r\t9BC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY\"!\b\u0003\u0015%sG-\u001a=fIN+\u0017OC\u0002\u0002\u0018)\u0001b!XA\u0011\u0003K!\u0014bAA\u0012\u0005\taAK]3f\u0013:\u001cH/\u00198dKB\u0019Q,a\n\n\u0007\u0005%\"A\u0001\bB]:|G/\u0019;fI2\u000b'-\u001a7\t\u0015\u00055\u0002\u0001#b\u0001\n\u0003\tY!\u0001\u0005eKZ$&/Z3t\u0011)\t\t\u0004\u0001EC\u0002\u0013\u0005\u00111B\u0001\ni\u0016\u001cH\u000f\u0016:fKNDq!!\u000e\u0001\t\u0003\t9$\u0001\bue\u0006t7OZ8s[R\u0013X-Z:\u0015\u0011\u00055\u0011\u0011HA$\u0003\u0017B\u0001\"a\u000f\u00024\u0001\u0007\u0011QH\u0001\ba>\u0014H/[8o!\u0011\ty$a\u0011\u000f\u0007\u0005\u0005S0D\u0001\u0001\u0013\u0011\t)%a\u0001\u0003\u000fA{'\u000f^5p]\"9\u0011\u0011JA\u001a\u0001\u0004!\u0013\u0001B7bq2C\u0011\"!\u0014\u00024A\u0005\t\u0019\u0001\u0017\u0002\u001f\r|G\u000e\\1qg\u0016,f.\u0019:jKNDq!!\u0015\u0001\t\u0003\t\u0019&\u0001\tnC.,GK]3f\u0013:\u001cH/\u00198dKRQ\u0011qDA+\u00033\n\u0019'!\u001b\t\u000f\u0005]\u0013q\na\u0001i\u0005!a.Y7f\u0011!\tY&a\u0014A\u0002\u0005u\u0013\u0001\u0002;sK\u0016\u0004B!XA0i%\u0019\u0011\u0011\r\u0002\u0003\tQ\u0013X-\u001a\u0005\t\u0003K\ny\u00051\u0001\u0002h\u0005)qo\u001c:egB)\u0011qBA\ri!9\u0011QJA(\u0001\u0004a\u0003bBA7\u0001\u0011\u0005\u0011qN\u0001\nQ\u0016\fGMU;mKN,\"!!\u001d\u0011\tu\u000b\u0019\bN\u0005\u0004\u0003k\u0012!A\u0003%fC\u00124\u0015N\u001c3fe\"I\u0011\u0011\u0010\u0001C\u0002\u0013\u0005\u00111P\u0001\baJ|7-Z:t+\t\ti\bE\u0002^\u0003\u007fJ1!!!\u0003\u0005U\u0019F/\u00198eCJ$GK]3f!J|7-Z:t_JD\u0001\"!\"\u0001A\u0003%\u0011QP\u0001\taJ|7-Z:tA!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111R\u0001\u0005G>\u0004\u0018\u0010F\u000b]\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0015qSAM\u00037\u000bi*a(\t\u0011U\t9\t%AA\u0002]A\u0001BIAD!\u0003\u0005\r\u0001\n\u0005\tU\u0005\u001d\u0005\u0013!a\u0001Y!A!'a\"\u0011\u0002\u0003\u0007A\u0007\u0003\u0005C\u0003\u000f\u0003\n\u00111\u00015\u0011!1\u0015q\u0011I\u0001\u0002\u0004!\u0003\u0002\u0003&\u0002\bB\u0005\t\u0019\u0001\u0017\t\u00119\u000b9\t%AA\u00021B\u0001BUAD!\u0003\u0005\r\u0001\u000e\u0005\t-\u0006\u001d\u0005\u0013!a\u0001i!I\u00111\u0015\u0001\u0012\u0002\u0013\u0005\u0011QU\u0001\u0019iJ\fgn\u001d4pe6$&/Z3tI\u0011,g-Y;mi\u0012\u001aTCAATU\ra\u0013\u0011V\u0016\u0003\u0003W\u0003B!!,\u000286\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0017\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002:\u0006=&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u0018\u0001\u0012\u0002\u0013\u0005\u0011qX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tMK\u0002\u0018\u0003SC\u0011\"!2\u0001#\u0003%\t!a2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001a\u0016\u0004I\u0005%\u0006\"CAg\u0001E\u0005I\u0011AAS\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!5\u0001#\u0003%\t!a5\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u001b\u0016\u0004i\u0005%\u0006\"CAm\u0001E\u0005I\u0011AAj\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIUB\u0011\"!8\u0001#\u0003%\t!a2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m!I\u0011\u0011\u001d\u0001\u0012\u0002\u0013\u0005\u0011QU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138\u0011%\t)\u000fAI\u0001\n\u0003\t)+\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\t\u0013\u0005%\b!%A\u0005\u0002\u0005M\u0017AD2paf$C-\u001a4bk2$H%\u000f\u0005\n\u0003[\u0004\u0011\u0013!C\u0001\u0003'\fqbY8qs\u0012\"WMZ1vYR$\u0013\u0007\r\u0005\n\u0003c\u0004\u0011\u0011!C!\u0003g\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA{!\u0011\t90!@\u000e\u0005\u0005e(bAA~7\u0005!A.\u00198h\u0013\ri\u0014\u0011 \u0005\t\u0005\u0003\u0001\u0011\u0011!C\u0001G\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I!Q\u0001\u0001\u0002\u0002\u0013\u0005!qA\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011IAa\u0004\u0011\u0007%\u0011Y!C\u0002\u0003\u000e)\u00111!\u00118z\u0011%\u0011\tBa\u0001\u0002\u0002\u0003\u0007A%A\u0002yIEB\u0011B!\u0006\u0001\u0003\u0003%\tEa\u0006\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0007\u0011\r\tm!\u0011\u0005B\u0005\u001b\t\u0011iBC\u0002\u0003 )\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019C!\b\u0003\u0011%#XM]1u_JD\u0011Ba\n\u0001\u0003\u0003%\tA!\u000b\u0002\u0011\r\fg.R9vC2$2\u0001\fB\u0016\u0011)\u0011\tB!\n\u0002\u0002\u0003\u0007!\u0011\u0002\u0005\n\u0005_\u0001\u0011\u0011!C!\u0005c\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002I!I!Q\u0007\u0001\u0002\u0002\u0013\u0005#qG\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u001f\u0005\n\u0005w\u0001\u0011\u0011!C!\u0005{\ta!Z9vC2\u001cHc\u0001\u0017\u0003@!Q!\u0011\u0003B\u001d\u0003\u0003\u0005\rA!\u0003)\u000b\u0001\u0001\u0007Na\u0011\"\u0005\t\u0015\u0013!\r)be\u0006lW\r^3sg\u00022wN\u001d\u0011sK\u0006$\u0017N\\4!C:$\u0007\u0005\u001d:pG\u0016\u001c8/\u001b8hA\u0005\u0004CO]3fE\u0006t7NL\u0004\n\u0005\u0013\u0012\u0011\u0011!E\u0001\u0005\u0017\n\u0011\u0003\u0015:pG\u0016\u001c8/\u001a3Ue\u0016,'-\u00198l!\ri&Q\n\u0004\t\u0003\t\t\t\u0011#\u0001\u0003PM)!Q\nB)#Ay!1\u000bB-/\u0011bC\u0007\u000e\u0013-YQ\"D,\u0004\u0002\u0003V)\u0019!q\u000b\u0006\u0002\u000fI,h\u000e^5nK&!!1\fB+\u0005I\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0019\t\u000fi\u0013i\u0005\"\u0001\u0003`Q\u0011!1\n\u0005\u000b\u0005k\u0011i%!A\u0005F\t]\u0002B\u0003B3\u0005\u001b\n\t\u0011\"!\u0003h\u0005)\u0011\r\u001d9msR)BL!\u001b\u0003l\t5$q\u000eB9\u0005g\u0012)Ha\u001e\u0003z\tm\u0004BB\u000b\u0003d\u0001\u0007q\u0003\u0003\u0005#\u0005G\u0002\n\u00111\u0001%\u0011!Q#1\rI\u0001\u0002\u0004a\u0003\u0002\u0003\u001a\u0003dA\u0005\t\u0019\u0001\u001b\t\u0011\t\u0013\u0019\u0007%AA\u0002QB\u0001B\u0012B2!\u0003\u0005\r\u0001\n\u0005\t\u0015\n\r\u0004\u0013!a\u0001Y!AaJa\u0019\u0011\u0002\u0003\u0007A\u0006\u0003\u0005S\u0005G\u0002\n\u00111\u00015\u0011!1&1\rI\u0001\u0002\u0004!\u0004B\u0003B@\u0005\u001b\n\t\u0011\"!\u0003\u0002\u00069QO\\1qa2LH\u0003\u0002BB\u0005\u001f\u0003R!\u0003BC\u0005\u0013K1Aa\"\u000b\u0005\u0019y\u0005\u000f^5p]Bi\u0011Ba#\u0018I1\"D\u0007\n\u0017-iQJ1A!$\u000b\u0005\u001d!V\u000f\u001d7fcAB\u0011B!%\u0003~\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u0016\n5\u0013\u0013!C\u0001\u0003\u000f\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003BM\u0005\u001b\n\n\u0011\"\u0001\u0002&\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB!B!(\u0003NE\u0005I\u0011AAj\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i!Q!\u0011\u0015B'#\u0003%\t!a5\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0011)\u0011)K!\u0014\u0012\u0002\u0013\u0005\u0011qY\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\t\u0015\t%&QJI\u0001\n\u0003\t)+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\u000e\u0005\u000b\u0005[\u0013i%%A\u0005\u0002\u0005\u0015\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003\b\u0003\u0006\u00032\n5\u0013\u0013!C\u0001\u0003'\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012J\u0004B\u0003B[\u0005\u001b\n\n\u0011\"\u0001\u0002T\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002\u0004B\u0003B]\u0005\u001b\n\n\u0011\"\u0001\u0002H\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0003>\n5\u0013\u0013!C\u0001\u0003K\u000bq\"\u00199qYf$C-\u001a4bk2$He\r\u0005\u000b\u0005\u0003\u0014i%%A\u0005\u0002\u0005M\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\t\u0015\t\u0015'QJI\u0001\n\u0003\t\u0019.A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0011)\u0011IM!\u0014\u0012\u0002\u0013\u0005\u0011qY\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%m!Q!Q\u001aB'#\u0003%\t!!*\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]B!B!5\u0003NE\u0005I\u0011AAS\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012B\u0004B\u0003Bk\u0005\u001b\n\n\u0011\"\u0001\u0002T\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013\b\u0003\u0006\u0003Z\n5\u0013\u0013!C\u0001\u0003'\f\u0001#\u00199qYf$C-\u001a4bk2$H%\r\u0019\t\u0015\tu'QJA\u0001\n\u0013\u0011y.A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bq!\u0011\t9Pa9\n\t\t\u0015\u0018\u0011 \u0002\u0007\u001f\nTWm\u0019;")
public class ProcessedTreebank
implements Product,
scala.Serializable {
    private Treebank<String> treebank;
    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> trainTrees;
    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> devTrees;
    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees;
    private final File path;
    private final int maxLength;
    private final boolean includeDevInTrain;
    private final String binarization;
    private final String treebankType;
    private final int numSentences;
    private final boolean keepUnaryChainsFromTrain;
    private final boolean debuckwalterize;
    private final String supervisedHeadFinderPtbPath;
    private final String supervisedHeadFinderConllPath;
    private final StandardTreeProcessor process;
    private volatile byte bitmap$0;

    public static /* bridge */ Object apply(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return ProcessedTreebank$.MODULE$.apply(object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    public static String apply$default$10() {
        return ProcessedTreebank$.MODULE$.apply$default$10();
    }

    public static String apply$default$9() {
        return ProcessedTreebank$.MODULE$.apply$default$9();
    }

    public static boolean apply$default$8() {
        return ProcessedTreebank$.MODULE$.apply$default$8();
    }

    public static boolean apply$default$7() {
        return ProcessedTreebank$.MODULE$.apply$default$7();
    }

    public static int apply$default$6() {
        return ProcessedTreebank$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return ProcessedTreebank$.MODULE$.apply$default$5();
    }

    public static String apply$default$4() {
        return ProcessedTreebank$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return ProcessedTreebank$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return ProcessedTreebank$.MODULE$.apply$default$2();
    }

    public static String $lessinit$greater$default$10() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$10();
    }

    public static String $lessinit$greater$default$9() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean $lessinit$greater$default$8() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$7() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$6() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return ProcessedTreebank$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple10<File, Object, Object, String, String, Object, Object, Object, String, String>> unapply(ProcessedTreebank processedTreebank) {
        return ProcessedTreebank$.MODULE$.unapply(processedTreebank);
    }

    public static ProcessedTreebank apply(File file, int n, boolean bl, String string, String string2, int n2, boolean bl2, boolean bl3, String string3, String string4) {
        return ProcessedTreebank$.MODULE$.apply(file, n, bl, string, string2, n2, bl2, bl3, string3, string4);
    }

    public static Function1<Tuple10<File, Object, Object, String, String, Object, Object, Object, String, String>, ProcessedTreebank> tupled() {
        return ProcessedTreebank$.MODULE$.tupled();
    }

    public static Function1<File, Function1<Object, Function1<Object, Function1<String, Function1<String, Function1<Object, Function1<Object, Function1<Object, Function1<String, Function1<String, ProcessedTreebank>>>>>>>>>> curried() {
        return ProcessedTreebank$.MODULE$.curried();
    }

    public File path() {
        return this.path;
    }

    public int maxLength() {
        return this.maxLength;
    }

    public boolean includeDevInTrain() {
        return this.includeDevInTrain;
    }

    public String binarization() {
        return this.binarization;
    }

    public String treebankType() {
        return this.treebankType;
    }

    public int numSentences() {
        return this.numSentences;
    }

    public boolean keepUnaryChainsFromTrain() {
        return this.keepUnaryChainsFromTrain;
    }

    public boolean debuckwalterize() {
        return this.debuckwalterize;
    }

    public String supervisedHeadFinderPtbPath() {
        return this.supervisedHeadFinderPtbPath;
    }

    public String supervisedHeadFinderConllPath() {
        return this.supervisedHeadFinderConllPath;
    }

    private Treebank<String> treebank$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Treebank<String> treebank;
                String string = this.treebankType().toLowerCase();
                if ("penn".equals(string)) {
                    treebank = Treebank$.MODULE$.fromPennTreebankDir(this.path());
                } else if ("chinese".equals(string)) {
                    treebank = Treebank$.MODULE$.fromChineseTreebankDir(this.path());
                } else if ("negra".equals(string)) {
                    treebank = Treebank$.MODULE$.fromGermanTreebank(this.path());
                } else if ("simple".equals(string)) {
                    treebank = new SimpleTreebank(new File(this.path(), "train.txt"), new File(this.path(), "dev.txt"), new File(this.path(), "test.txt"));
                } else if ("conllonto".equals(string)) {
                    treebank = Treebank$.MODULE$.fromOntonotesDirectory(this.path(), Treebank$.MODULE$.fromOntonotesDirectory$default$2());
                } else if ("spmrl".equals(string)) {
                    File trainPath = new File(this.path(), "train");
                    if (!trainPath.exists()) {
                        trainPath = new File(this.path(), "train5k");
                    }
                    File[] train = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trainPath.listFiles())).filterImpl((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProcessedTreebank.$anonfun$treebank$1(x$1)), false);
                    File[] dev = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "dev").listFiles())).filterImpl((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ProcessedTreebank.$anonfun$treebank$2(x$2)), false);
                    File[] test = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "test").listFiles())).filterImpl((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ProcessedTreebank.$anonfun$treebank$3(x$3)), false);
                    treebank = new SimpleTreebank((IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])train), (IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])dev), (IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])test));
                } else if ("spmrl5k".equals(string)) {
                    File[] train = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "train5k").listFiles())).filterImpl((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProcessedTreebank.$anonfun$treebank$4(x$4)), false);
                    File[] dev = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "dev").listFiles())).filterImpl((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ProcessedTreebank.$anonfun$treebank$5(x$5)), false);
                    File[] test = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.path(), "test").listFiles())).filterImpl((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ProcessedTreebank.$anonfun$treebank$6(x$6)), false);
                    treebank = new SimpleTreebank((IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])train), (IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])dev), (IndexedSeq<File>)Predef$.MODULE$.wrapRefArray((Object[])test));
                } else if ("meta".equals(string)) {
                    treebank = SimpleTreebank$.MODULE$.fromTrainDevTestDirs(this.path(), SimpleTreebank$.MODULE$.fromTrainDevTestDirs$default$2());
                } else {
                    throw new RuntimeException("Unknown Treebank type");
                }
                this.treebank = treebank;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.treebank;
    }

    public Treebank<String> treebank() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.treebank$lzycompute();
        }
        return this.treebank;
    }

    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> trainTrees$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                IndexedSeq train = this.transformTrees(this.treebank().train(), this.maxLength(), true);
                if (this.includeDevInTrain()) {
                    train = (IndexedSeq)train.$plus$plus(this.transformTrees(this.treebank().dev(), this.maxLength(), true), IndexedSeq$.MODULE$.canBuildFrom());
                }
                this.trainTrees = (IndexedSeq)train.take(this.numSentences());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.trainTrees;
    }

    public IndexedSeq<TreeInstance<AnnotatedLabel, String>> trainTrees() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.trainTrees$lzycompute();
        }
        return this.trainTrees;
    }

    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> devTrees$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.devTrees = this.transformTrees(this.treebank().dev(), 100000, this.transformTrees$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.devTrees;
    }

    public IndexedSeq<TreeInstance<AnnotatedLabel, String>> devTrees() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.devTrees$lzycompute();
        }
        return this.devTrees;
    }

    private IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.testTrees = this.transformTrees(this.treebank().test(), 1000000, this.transformTrees$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.testTrees;
    }

    public IndexedSeq<TreeInstance<AnnotatedLabel, String>> testTrees() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.testTrees$lzycompute();
        }
        return this.testTrees;
    }

    public IndexedSeq<TreeInstance<AnnotatedLabel, String>> transformTrees(Treebank.Portion portion, int maxL, boolean collapseUnaries) {
        return portion.trees().zipWithIndex().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null && check$ifrefutable$1._1() != null))).withFilter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProcessedTreebank.$anonfun$transformTrees$2(maxL, x$7))).map((Function1 & Serializable & scala.Serializable)x$9 -> {
            if (x$9 == null || x$9._1() == null) {
                throw new MatchError(x$9);
            }
            IndexedSeq w2 = this.debuckwalterize() ? (IndexedSeq)((TraversableLike)((Tuple2)x$9._1())._2()).map((Function1 & Serializable & scala.Serializable)buckwalter -> ArabicNormalization$.MODULE$.buckwalterToUnicode((String)buckwalter), IndexedSeq$.MODULE$.canBuildFrom()) : (IndexedSeq)((Tuple2)x$9._1())._2();
            Tuple2 tuple2 = new Tuple2(x$9, (Object)w2);
            return tuple2;
        }).map((Function1 & Serializable & scala.Serializable)x$10 -> {
            if (x$10 == null || x$10._1() == null || ((Tuple2)x$10._1())._1() == null) {
                throw new MatchError(x$10);
            }
            String name = new StringBuilder(1).append(portion.name()).append("-").append(((Tuple2)x$10._1())._2$mcI$sp()).toString();
            TreeInstance<AnnotatedLabel, String> treeInstance = this.makeTreeInstance(name, (Tree)((Tuple2)((Tuple2)x$10._1())._1())._1(), (IndexedSeq<String>)((IndexedSeq)x$10._2()), collapseUnaries);
            return treeInstance;
        }).toIndexedSeq();
    }

    public boolean transformTrees$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TreeInstance<AnnotatedLabel, String> makeTreeInstance(String name, Tree<String> tree, IndexedSeq<String> words, boolean collapseUnaries) {
        void assert_assertion;
        boolean bl;
        ObjectRef transformed = ObjectRef.create(this.process().apply(tree.map((Function1 & Serializable & scala.Serializable)label -> AnnotatedLabel$.MODULE$.parseTreebank((String)label))));
        if (collapseUnaries) {
            transformed.elem = UnaryChainCollapser$.MODULE$.collapseUnaryChains((BinarizedTree)transformed.elem, this.keepUnaryChainsFromTrain());
        }
        boolean bl2 = bl = ((BinarizedTree)transformed.elem).children().length() == 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (assert_assertion == false) {
            throw new AssertionError((Object)new StringBuilder(18).append("assertion failed: ").append((Object)ProcessedTreebank.$anonfun$makeTreeInstance$2(words, transformed)).toString());
        }
        return new TreeInstance<AnnotatedLabel, String>(name, (BinarizedTree)transformed.elem, words);
    }

    public HeadFinder<String> headRules() {
        boolean bl;
        String string = this.binarization();
        boolean bl2 = "xbar".equals(string) ? true : "right".equals(string);
        HeadFinder<Object> headFinder = bl2 ? HeadFinder$.MODULE$.right() : ((bl = "leftXbar".equals(string) ? true : "left".equals(string)) ? HeadFinder$.MODULE$.left() : ("head".equals(string) ? (this.treebankType().startsWith("spmrl") ? SupervisedHeadFinder$.MODULE$.trainHeadFinderFromFiles(this.supervisedHeadFinderPtbPath(), this.supervisedHeadFinderConllPath()) : HeadFinder$.MODULE$.collins()) : HeadFinder$.MODULE$.collins()));
        return headFinder;
    }

    public StandardTreeProcessor process() {
        return this.process;
    }

    public ProcessedTreebank copy(File path, int maxLength, boolean includeDevInTrain, String binarization, String treebankType, int numSentences, boolean keepUnaryChainsFromTrain, boolean debuckwalterize, String supervisedHeadFinderPtbPath, String supervisedHeadFinderConllPath) {
        return new ProcessedTreebank(path, maxLength, includeDevInTrain, binarization, treebankType, numSentences, keepUnaryChainsFromTrain, debuckwalterize, supervisedHeadFinderPtbPath, supervisedHeadFinderConllPath);
    }

    public File copy$default$1() {
        return this.path();
    }

    public String copy$default$10() {
        return this.supervisedHeadFinderConllPath();
    }

    public int copy$default$2() {
        return this.maxLength();
    }

    public boolean copy$default$3() {
        return this.includeDevInTrain();
    }

    public String copy$default$4() {
        return this.binarization();
    }

    public String copy$default$5() {
        return this.treebankType();
    }

    public int copy$default$6() {
        return this.numSentences();
    }

    public boolean copy$default$7() {
        return this.keepUnaryChainsFromTrain();
    }

    public boolean copy$default$8() {
        return this.debuckwalterize();
    }

    public String copy$default$9() {
        return this.supervisedHeadFinderPtbPath();
    }

    public String productPrefix() {
        return "ProcessedTreebank";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.path();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.maxLength());
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.includeDevInTrain());
            }
            case 3: {
                return this.binarization();
            }
            case 4: {
                return this.treebankType();
            }
            case 5: {
                return BoxesRunTime.boxToInteger((int)this.numSentences());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this.keepUnaryChainsFromTrain());
            }
            case 7: {
                return BoxesRunTime.boxToBoolean((boolean)this.debuckwalterize());
            }
            case 8: {
                return this.supervisedHeadFinderPtbPath();
            }
            case 9: {
                return this.supervisedHeadFinderConllPath();
            }
        }
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcessedTreebank;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.path())), (int)this.maxLength()), (int)(this.includeDevInTrain() ? 1231 : 1237)), (int)Statics.anyHash((Object)this.binarization())), (int)Statics.anyHash((Object)this.treebankType())), (int)this.numSentences()), (int)(this.keepUnaryChainsFromTrain() ? 1231 : 1237)), (int)(this.debuckwalterize() ? 1231 : 1237)), (int)Statics.anyHash((Object)this.supervisedHeadFinderPtbPath())), (int)Statics.anyHash((Object)this.supervisedHeadFinderConllPath())), (int)10);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof ProcessedTreebank)) return false;
        boolean bl = true;
        if (!bl) return false;
        ProcessedTreebank processedTreebank = (ProcessedTreebank)x$1;
        File file = this.path();
        File file2 = processedTreebank.path();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        if (this.maxLength() != processedTreebank.maxLength()) return false;
        if (this.includeDevInTrain() != processedTreebank.includeDevInTrain()) return false;
        String string = this.binarization();
        String string2 = processedTreebank.binarization();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.treebankType();
        String string4 = processedTreebank.treebankType();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (this.numSentences() != processedTreebank.numSentences()) return false;
        if (this.keepUnaryChainsFromTrain() != processedTreebank.keepUnaryChainsFromTrain()) return false;
        if (this.debuckwalterize() != processedTreebank.debuckwalterize()) return false;
        String string5 = this.supervisedHeadFinderPtbPath();
        String string6 = processedTreebank.supervisedHeadFinderPtbPath();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        String string7 = this.supervisedHeadFinderConllPath();
        String string8 = processedTreebank.supervisedHeadFinderConllPath();
        if (string7 == null) {
            if (string8 != null) {
                return false;
            }
        } else if (!string7.equals(string8)) return false;
        if (!processedTreebank.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$treebank$1(File x$1) {
        return x$1.getName().endsWith("ptb");
    }

    public static final /* synthetic */ boolean $anonfun$treebank$2(File x$2) {
        return x$2.getName().endsWith("ptb");
    }

    public static final /* synthetic */ boolean $anonfun$treebank$3(File x$3) {
        return x$3.getName().endsWith("ptb");
    }

    public static final /* synthetic */ boolean $anonfun$treebank$4(File x$4) {
        return x$4.getName().endsWith("ptb");
    }

    public static final /* synthetic */ boolean $anonfun$treebank$5(File x$5) {
        return x$5.getName().endsWith("ptb");
    }

    public static final /* synthetic */ boolean $anonfun$treebank$6(File x$6) {
        return x$6.getName().endsWith("ptb");
    }

    public static final /* synthetic */ boolean $anonfun$transformTrees$2(int maxL$1, Tuple2 x$7) {
        if (x$7 == null || x$7._1() == null) {
            throw new MatchError((Object)x$7);
        }
        boolean bl = ((SeqLike)((Tuple2)x$7._1())._2()).length() <= maxL$1;
        return bl;
    }

    public static final /* synthetic */ String $anonfun$makeTreeInstance$2(IndexedSeq words$1, ObjectRef transformed$1) {
        return new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)((BinarizedTree)transformed$1.elem)), " ")).append(words$1).toString();
    }

    public ProcessedTreebank(@Help(text="Location of the treebank directory") File path, @Help(text="Max length for training sentences") int maxLength, @Help(text="Should we add the dev set for training, do this only for final test.") boolean includeDevInTrain, @Help(text="What kind of binarization to do. Options: left, right, head. Head is best.") String binarization, String treebankType, int numSentences, boolean keepUnaryChainsFromTrain, boolean debuckwalterize, String supervisedHeadFinderPtbPath, String supervisedHeadFinderConllPath) {
        this.path = path;
        this.maxLength = maxLength;
        this.includeDevInTrain = includeDevInTrain;
        this.binarization = binarization;
        this.treebankType = treebankType;
        this.numSentences = numSentences;
        this.keepUnaryChainsFromTrain = keepUnaryChainsFromTrain;
        this.debuckwalterize = debuckwalterize;
        this.supervisedHeadFinderPtbPath = supervisedHeadFinderPtbPath;
        this.supervisedHeadFinderConllPath = supervisedHeadFinderConllPath;
        Product.$init$((Product)this);
        this.process = new StandardTreeProcessor(HeadFinder$.MODULE$.lensed(this.headRules(), AnnotatedLabel$.MODULE$.stringLens()), StandardTreeProcessor$.MODULE$.$lessinit$greater$default$2());
    }
}

