/*
 * Decompiled with CFR 0.152.
 */
package epic.features;

import epic.features.DistanceBinner;
import epic.features.DistanceBinner$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class SpanShapeGenerator$
implements Serializable {
    public static SpanShapeGenerator$ MODULE$;
    private final int MAX_LEN;
    private final DistanceBinner distanceBinner;

    static {
        new SpanShapeGenerator$();
    }

    public int MAX_LEN() {
        return this.MAX_LEN;
    }

    public String apply(IndexedSeq<String> v1, int begin, int end) {
        return this.signatureFor(v1, begin, end, this.signatureFor$default$4());
    }

    public String signatureFor(IndexedSeq<String> words, int begin, int end, boolean includeContext) {
        int i;
        StringBuilder result = new StringBuilder(end - begin);
        if (includeContext) {
            if (begin - 1 < 0) {
                result.$plus$eq('#');
            } else {
                String string = (String)words.apply(begin - 1);
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                result.$plus$eq(this.binCharacter(BoxesRunTime.unboxToChar((Object)new StringOps(string).head())));
            }
            result.$plus$eq('[');
        }
        for (i = begin; i < package$.MODULE$.min(begin + this.MAX_LEN() / 2 + 1, end); ++i) {
            this.appendWordShape(i, words, result);
        }
        if (i < end) {
            result.$plus$eq('~');
            i = end - this.MAX_LEN() / 2;
        }
        while (i < end) {
            this.appendWordShape(i, words, result);
            ++i;
        }
        if (includeContext) {
            result.$plus$eq(']');
            if (end >= words.length()) {
                result.$plus$eq('#');
            } else {
                String string = (String)words.apply(end);
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                result.$plus$eq(this.binCharacter(BoxesRunTime.unboxToChar((Object)new StringOps(string).head())));
            }
        }
        return result.toString();
    }

    public boolean signatureFor$default$4() {
        return true;
    }

    public String signatureAndContextFor(IndexedSeq<String> words, int begin, int end, int numContextWords, boolean richContext, Set<String> commonWords) {
        int i;
        StringBuilder result = new StringBuilder(end - begin);
        for (i = begin - numContextWords; i < begin; ++i) {
            if (i < 0) {
                result.$plus$eq('#');
                continue;
            }
            if (commonWords.apply(words.apply(i))) {
                result.$plus$plus$eq((String)words.apply(i));
                continue;
            }
            if (richContext) {
                this.appendWordShape(i, words, result);
                continue;
            }
            String string = (String)words.apply(i);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            result.$plus$eq(this.binCharacter(BoxesRunTime.unboxToChar((Object)new StringOps(string).head())));
        }
        result.$plus$eq('[');
        while (i < package$.MODULE$.min(begin + this.MAX_LEN() / 2 + 1, end)) {
            this.appendWordShape(i, words, result);
            ++i;
        }
        if (i < end) {
            result.$plus$eq('~');
            i = end - this.MAX_LEN() / 2;
        }
        while (i < end) {
            this.appendWordShape(i, words, result);
            ++i;
        }
        result.$plus$eq(']');
        while (i < end + numContextWords) {
            if (i >= words.length()) {
                result.$plus$eq('#');
            } else if (commonWords.apply(words.apply(i))) {
                result.$plus$plus$eq((String)words.apply(i));
            } else if (richContext) {
                this.appendWordShape(i, words, result);
            } else {
                String string = (String)words.apply(i);
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                result.$plus$eq(this.binCharacter(BoxesRunTime.unboxToChar((Object)new StringOps(string).head())));
            }
            ++i;
        }
        return result.toString();
    }

    public int signatureAndContextFor$default$4() {
        return 1;
    }

    public boolean signatureAndContextFor$default$5() {
        return false;
    }

    public Set<String> signatureAndContextFor$default$6() {
        return Predef$.MODULE$.Set().empty();
    }

    public void appendWordShape(int i, IndexedSeq<String> words, StringBuilder result) {
        String w;
        String string = w = i < 0 || i >= words.length() ? "#" : (String)words.apply(i);
        if (w.isEmpty()) {
            result.$plus$eq('\u03b5');
            return;
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int c = StringOps$.MODULE$.apply$extension(w, 0);
        if (c == 45) {
            int n = "-LRB-".equals(w) ? 40 : ("-RRB-".equals(w) ? 41 : ("-LSB-".equals(w) ? 91 : ("-RSB-".equals(w) ? 93 : ("-LCB-".equals(w) ? 123 : ("-RCB-".equals(w) ? 125 : c)))));
            c = n;
        }
        char x = this.binCharacter((char)c);
        if (result.length() > 1 && BoxesRunTime.unboxToChar((Object)result.last()) == x) {
            result.$plus$eq('e');
            return;
        }
        if (result.length() <= 2 || BoxesRunTime.unboxToChar((Object)result.last()) != 'e' || result.apply(result.length() - 2) != x) {
            result.$plus$eq(x);
        }
    }

    public char binCharacter(char c) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (RichChar$.MODULE$.isLetter$extension(c)) {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (RichChar$.MODULE$.isUpper$extension(c)) {
                return 'X';
            }
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (RichChar$.MODULE$.isLetter$extension(c)) {
            return 'x';
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (RichChar$.MODULE$.isDigit$extension(c)) {
            return 'd';
        }
        return c;
    }

    public DistanceBinner distanceBinner() {
        return this.distanceBinner;
    }

    public String splitShapeFor(IndexedSeq<String> words, int begin, int split, int end, int numContextWords, boolean richContext, Set<String> commonWords) {
        int i;
        StringBuilder result = new StringBuilder(end - begin);
        for (i = begin - numContextWords; i < begin; ++i) {
            if (i < 0) {
                result.$plus$eq('#');
                continue;
            }
            if (commonWords.apply(words.apply(i))) {
                result.$plus$plus$eq((String)words.apply(i));
                continue;
            }
            if (richContext) {
                this.appendWordShape(i, words, result);
                continue;
            }
            String string = (String)words.apply(i);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            result.$plus$eq(this.binCharacter(BoxesRunTime.unboxToChar((Object)new StringOps(string).head())));
        }
        result.$plus$eq('[');
        while (i < package$.MODULE$.min(begin + this.MAX_LEN() / 2 + 1, end)) {
            this.appendWordShape(i, words, result);
            ++i;
        }
        if (i <= split) {
            if (i < split) {
                result.$plus$eq('~');
            }
            this.appendWordShape(split, words, result);
            this.appendWordShape(split + 1, words, result);
            i = split + 2;
        }
        if (i < end) {
            result.$plus$eq('~');
            i = package$.MODULE$.min(split, end - this.MAX_LEN() / 2);
        }
        while (i < end) {
            this.appendWordShape(i, words, result);
            ++i;
        }
        result.$plus$eq(']');
        while (i < end + numContextWords) {
            if (i >= words.length()) {
                result.$plus$eq('#');
            } else if (commonWords.apply(words.apply(i))) {
                result.$plus$plus$eq((String)words.apply(i));
            } else if (richContext) {
                this.appendWordShape(i, words, result);
            } else {
                String string = (String)words.apply(i);
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                result.$plus$eq(this.binCharacter(BoxesRunTime.unboxToChar((Object)new StringOps(string).head())));
            }
            ++i;
        }
        return result.toString();
    }

    public int splitShapeFor$default$5() {
        return 1;
    }

    public boolean splitShapeFor$default$6() {
        return false;
    }

    public Set<String> splitShapeFor$default$7() {
        return Predef$.MODULE$.Set().empty();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SpanShapeGenerator$() {
        MODULE$ = this;
        this.MAX_LEN = 6;
        this.distanceBinner = DistanceBinner$.MODULE$.apply(DistanceBinner$.MODULE$.apply$default$1(), DistanceBinner$.MODULE$.apply$default$2());
    }
}

