/*
 * Decompiled with CFR 0.152.
 */
package junto.algorithm.parallel;

import gnu.trove.iterator.TObjectDoubleIterator;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import junto.config.ConfigReader;
import junto.util.CollectionUtil;
import junto.util.Constants;
import junto.util.Defaults;
import junto.util.ProbUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class AdsorptionHadoop {
    private static String _kDelim = "\t";

    public static void main(String[] stringArray) throws Exception {
        Hashtable<String, String> hashtable = ConfigReader.read_config(stringArray);
        String string = Defaults.GetValueOrDie(hashtable, "hdfs_input_pattern");
        String string2 = Defaults.GetValueOrDie(hashtable, "hdfs_output_base");
        int n = Integer.parseInt(Defaults.GetValueOrDie(hashtable, "iters"));
        String string3 = string;
        String string4 = "";
        for (int i = 1; i <= n; ++i) {
            JobConf jobConf = new JobConf(AdsorptionHadoop.class);
            jobConf.setJobName("adsorption_hadoop");
            jobConf.setOutputKeyClass(Text.class);
            jobConf.setOutputValueClass(Text.class);
            jobConf.setMapperClass(Map.class);
            jobConf.setReducerClass(Reduce.class);
            jobConf.setInputFormat(TextInputFormat.class);
            jobConf.setOutputFormat(TextOutputFormat.class);
            jobConf.set("mu1", Defaults.GetValueOrDie(hashtable, "mu1"));
            jobConf.set("mu2", Defaults.GetValueOrDie(hashtable, "mu2"));
            jobConf.set("mu3", Defaults.GetValueOrDie(hashtable, "mu3"));
            jobConf.set("keepTopKLabels", Defaults.GetValueOrDefault(hashtable.get("keep_top_k_labels"), Integer.toString(Integer.MAX_VALUE)));
            if (i > 1) {
                string3 = string4 + "/*";
            }
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{new Path(string3)});
            string4 = string2 + "_" + i;
            FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(string4));
            JobClient.runJob((JobConf)jobConf);
        }
    }

    public static class Reduce
    extends MapReduceBase
    implements Reducer<Text, Text, Text, Text> {
        private static double mu1;
        private static double mu2;
        private static double mu3;
        private static int keepTopKLabels;

        public void configure(JobConf jobConf) {
            mu1 = Double.parseDouble(jobConf.get("mu1"));
            mu2 = Double.parseDouble(jobConf.get("mu2"));
            mu3 = Double.parseDouble(jobConf.get("mu3"));
            keepTopKLabels = Integer.parseInt(jobConf.get("keepTopKLabels"));
        }

        public void reduce(Text text, Iterator<Text> iterator, OutputCollector<Text, Text> outputCollector, Reporter reporter) throws IOException {
            String[] stringArray3;
            String string;
            TObjectDoubleHashMap tObjectDoubleHashMap = new TObjectDoubleHashMap();
            boolean bl = false;
            String string2 = text.toString();
            String string3 = "";
            TObjectDoubleHashMap tObjectDoubleHashMap2 = null;
            TObjectDoubleHashMap tObjectDoubleHashMap3 = null;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            int n = 0;
            while (iterator.hasNext()) {
                ++n;
                string = iterator.next().toString();
                String[] stringArray2 = string.split(_kDelim);
                if (string2.equals(stringArray2[0])) {
                    bl = true;
                    string3 = string;
                    stringArray3 = CollectionUtil.String2Map((String)stringArray2[2]);
                    tObjectDoubleHashMap2 = CollectionUtil.String2Map(tObjectDoubleHashMap2, (String)stringArray2[4]);
                    tObjectDoubleHashMap3 = CollectionUtil.String2Map((String)stringArray2[5]);
                    if (stringArray3.size() <= 0) continue;
                    ProbUtil.AddScores(tObjectDoubleHashMap, mu1 * tObjectDoubleHashMap3.get((Object)Constants._kInjProb), (TObjectDoubleHashMap)stringArray3);
                    continue;
                }
                if (stringArray2.length <= 1) continue;
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
            if (!bl) {
                throw new RuntimeException("Self message not received for node " + string2);
            }
            string = new TObjectDoubleHashMap();
            for (String[] stringArray3 : hashMap.keySet()) {
                ProbUtil.AddScores((TObjectDoubleHashMap)string, mu2 * tObjectDoubleHashMap3.get((Object)Constants._kContProb) * tObjectDoubleHashMap2.get((Object)stringArray3), CollectionUtil.String2Map((String)hashMap.get(stringArray3)));
            }
            ProbUtil.Normalize((TObjectDoubleHashMap)string);
            ProbUtil.AddScores(tObjectDoubleHashMap, 1.0, (TObjectDoubleHashMap)string);
            ProbUtil.AddScores(tObjectDoubleHashMap, mu3 * tObjectDoubleHashMap3.get((Object)Constants._kTermProb), Constants.GetDummyLabelDist());
            ProbUtil.Normalize(tObjectDoubleHashMap, keepTopKLabels);
            stringArray3 = string3.split(_kDelim);
            String[] stringArray4 = new String[stringArray3.length - 1];
            for (int i = 1; i < stringArray3.length; ++i) {
                stringArray4[i - 1] = stringArray3[i];
            }
            stringArray4[2] = CollectionUtil.Map2String(tObjectDoubleHashMap);
            outputCollector.collect((Object)text, (Object)new Text(CollectionUtil.Join(stringArray4, _kDelim)));
        }
    }

    public static class Map
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, Text> {
        private Text word = new Text();

        public void map(LongWritable longWritable, Text text, OutputCollector<Text, Text> outputCollector, Reporter reporter) throws IOException {
            boolean bl;
            String string = text.toString();
            String[] stringArray = string.split(_kDelim);
            TObjectDoubleHashMap tObjectDoubleHashMap = CollectionUtil.String2Map(stringArray[4]);
            boolean bl2 = bl = stringArray[2].length() > 0;
            if (bl && stringArray[3].length() == 0) {
                stringArray[3] = stringArray[2];
            }
            outputCollector.collect((Object)new Text(stringArray[0]), (Object)new Text(string));
            TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
            while (tObjectDoubleIterator.hasNext()) {
                tObjectDoubleIterator.advance();
                outputCollector.collect((Object)new Text((String)tObjectDoubleIterator.key()), (Object)new Text(stringArray[0] + _kDelim + stringArray[3]));
            }
        }
    }
}

