/*
 * Decompiled with CFR 0.152.
 */
package junto.algorithm.parallel;

import gnu.trove.iterator.TObjectDoubleIterator;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import junto.config.ConfigReader;
import junto.util.CollectionUtil;
import junto.util.Defaults;
import junto.util.ProbUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class LP_ZGL_Hadoop {
    private static String _kDelim = "\t";

    public static void main(String[] stringArray) throws Exception {
        Hashtable<String, String> hashtable = ConfigReader.read_config(stringArray);
        String string = Defaults.GetValueOrDie(hashtable, "hdfs_input_pattern");
        String string2 = Defaults.GetValueOrDie(hashtable, "hdfs_output_base");
        int n = Integer.parseInt(Defaults.GetValueOrDie(hashtable, "iters"));
        String string3 = string;
        String string4 = "";
        for (int i = 1; i <= n; ++i) {
            JobConf jobConf = new JobConf(LP_ZGL_Hadoop.class);
            jobConf.setJobName("lp_zgl_hadoop");
            jobConf.setOutputKeyClass(Text.class);
            jobConf.setOutputValueClass(Text.class);
            jobConf.setMapperClass(LP_ZGL_Map.class);
            jobConf.setReducerClass(LP_ZGL_Reduce.class);
            jobConf.setInputFormat(TextInputFormat.class);
            jobConf.setOutputFormat(TextOutputFormat.class);
            jobConf.set("mu1", Defaults.GetValueOrDie(hashtable, "mu1"));
            jobConf.set("mu2", Defaults.GetValueOrDie(hashtable, "mu2"));
            jobConf.set("keepTopKLabels", Defaults.GetValueOrDefault(hashtable.get("keep_top_k_labels"), Integer.toString(Integer.MAX_VALUE)));
            if (i > 1) {
                string3 = string4 + "/*";
            }
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{new Path(string3)});
            string4 = string2 + "_" + i;
            FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(string4));
            JobClient.runJob((JobConf)jobConf);
        }
    }

    public static class LP_ZGL_Reduce
    extends MapReduceBase
    implements Reducer<Text, Text, Text, Text> {
        private static double mu1;
        private static double mu2;
        private static int keepTopKLabels;

        public void configure(JobConf jobConf) {
            mu1 = Double.parseDouble(jobConf.get("mu1"));
            mu2 = Double.parseDouble(jobConf.get("mu2"));
            keepTopKLabels = Integer.parseInt(jobConf.get("keepTopKLabels"));
        }

        public void reduce(Text text, Iterator<Text> iterator, OutputCollector<Text, Text> outputCollector, Reporter reporter) throws IOException {
            Object object;
            String[] stringArray;
            TObjectDoubleHashMap tObjectDoubleHashMap = new TObjectDoubleHashMap();
            boolean bl = false;
            String string = text.toString();
            String[] stringArray2 = "";
            TObjectDoubleHashMap tObjectDoubleHashMap2 = null;
            TObjectDoubleHashMap tObjectDoubleHashMap3 = null;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            int n = 0;
            boolean bl2 = false;
            while (iterator.hasNext()) {
                ++n;
                stringArray = iterator.next().toString();
                object = stringArray.split(_kDelim);
                if (string.equals(object[0])) {
                    bl = true;
                    stringArray2 = stringArray;
                    String string2 = CollectionUtil.String2Map((String)object[2]);
                    tObjectDoubleHashMap2 = CollectionUtil.String2Map(tObjectDoubleHashMap2, (String)object[4]);
                    tObjectDoubleHashMap3 = CollectionUtil.String2Map((String)object[5]);
                    if (string2.size() <= 0) continue;
                    bl2 = true;
                    ProbUtil.AddScores(tObjectDoubleHashMap, mu1, (TObjectDoubleHashMap)string2);
                    continue;
                }
                if (((Object)object).length <= 1) continue;
                hashMap.put(object[0], object[1]);
            }
            if (!bl) {
                throw new RuntimeException("Self message not received for node " + string);
            }
            if (!bl2) {
                stringArray = new TObjectDoubleHashMap();
                for (String string2 : hashMap.keySet()) {
                    ProbUtil.AddScores((TObjectDoubleHashMap)stringArray, mu2 * tObjectDoubleHashMap2.get((Object)string2), CollectionUtil.String2Map((String)hashMap.get(string2)));
                }
                ProbUtil.Normalize((TObjectDoubleHashMap)stringArray, keepTopKLabels);
                ProbUtil.AddScores(tObjectDoubleHashMap, 1.0, (TObjectDoubleHashMap)stringArray);
            }
            ProbUtil.Normalize(tObjectDoubleHashMap);
            stringArray = stringArray2.split(_kDelim);
            object = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                object[i - 1] = stringArray[i];
            }
            object[2] = CollectionUtil.Map2String(tObjectDoubleHashMap);
            outputCollector.collect((Object)text, (Object)new Text(CollectionUtil.Join((String[])object, _kDelim)));
        }
    }

    public static class LP_ZGL_Map
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, Text> {
        private Text word = new Text();

        public void map(LongWritable longWritable, Text text, OutputCollector<Text, Text> outputCollector, Reporter reporter) throws IOException {
            boolean bl;
            String string = text.toString();
            String[] stringArray = string.split(_kDelim);
            TObjectDoubleHashMap tObjectDoubleHashMap = CollectionUtil.String2Map(stringArray[4]);
            boolean bl2 = bl = stringArray[2].length() > 0;
            if (bl && stringArray[3].length() == 0) {
                stringArray[3] = stringArray[2];
            }
            outputCollector.collect((Object)new Text(stringArray[0]), (Object)new Text(string));
            TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
            while (tObjectDoubleIterator.hasNext()) {
                tObjectDoubleIterator.advance();
                outputCollector.collect((Object)new Text((String)tObjectDoubleIterator.key()), (Object)new Text(stringArray[0] + _kDelim + stringArray[3]));
            }
        }
    }
}

