/*
 * Decompiled with CFR 0.152.
 */
package junto.app;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import junto.app.JuntoConfigRunner;
import junto.config.ConfigReader;
import junto.util.CollectionUtil;
import junto.util.Constants;
import junto.util.Defaults;
import junto.util.MessagePrinter;

public class ConfigTuner {
    private static ArrayList<Hashtable> GetAllCombinations(Hashtable hashtable) {
        ArrayList<Hashtable> arrayList = new ArrayList<Hashtable>();
        for (String string : hashtable.keySet()) {
            String string2 = (String)hashtable.get(string);
            String[] stringArray = string2.split(",");
            int n = arrayList.size();
            for (int i = 0; i < stringArray.length; ++i) {
                if (arrayList.size() == 0) {
                    arrayList.add(new Hashtable());
                    ++n;
                }
                for (int j = 0; j < n; ++j) {
                    if (i == 0) {
                        arrayList.get(j).put(string, stringArray[i]);
                        continue;
                    }
                    Hashtable hashtable2 = (Hashtable)arrayList.get(j).clone();
                    hashtable2.put(string, stringArray[i]);
                    arrayList.add(hashtable2);
                }
            }
        }
        System.out.println("Total config (non-unique) combinations: " + arrayList.size());
        return arrayList;
    }

    private static void Run(Hashtable hashtable) {
        Hashtable<String, String> hashtable2;
        String string = Defaults.GetValueOrDie(hashtable, "iden_str");
        String string2 = Defaults.GetValueOrDie(hashtable, "log_output_dir");
        String string3 = Defaults.GetValueOrDefault((String)hashtable.get("output_dir"), null);
        boolean bl = Defaults.GetValueOrDefault((String)hashtable.get("skip_existing_config"), false);
        String string4 = (String)hashtable.get("final_config_file");
        hashtable.remove("final_config_file");
        ArrayList<Hashtable> arrayList = ConfigTuner.GetAllCombinations(hashtable);
        ArrayList arrayList2 = new ArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Hashtable> hashMap = new HashMap<String, Hashtable>();
        TObjectDoubleHashMap tObjectDoubleHashMap = new TObjectDoubleHashMap();
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object = arrayList.get(i);
            if (Defaults.GetValueOrDefault((String)((Hashtable)object).get("is_final_run"), false)) {
                hashtable2 = Defaults.GetValueOrDie((Hashtable)object, "split_id");
                ((Hashtable)object).put("seed_file", ((Hashtable)object).remove("seed_base") + "." + (String)((Object)hashtable2) + ".train");
                ((Hashtable)object).put("test_file", ((Hashtable)object).remove("test_base") + "." + (String)((Object)hashtable2) + ".test");
            }
            if (hashSet.contains(hashtable2 = ConfigTuner.GetOutputFileName((Hashtable)object, string3, string))) continue;
            hashSet.add((String)((Object)hashtable2));
            if (string3 != null) {
                ((Hashtable)object).put("output_file", hashtable2);
            }
            System.out.println("Working with config: " + ((Hashtable)object).toString());
            try {
                String string5 = ConfigTuner.GetLogFileName((Hashtable)object, string2, string);
                File file = new File(string5);
                if (bl && file.exists()) continue;
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string5));
                PrintStream printStream3 = new PrintStream(fileOutputStream);
                System.setOut(printStream3);
                System.setErr(printStream3);
                arrayList2.add(new ArrayList());
                JuntoConfigRunner.apply((Hashtable<String, String>)object, (ArrayList)arrayList2.get(arrayList2.size() - 1));
                ConfigTuner.UpdateBestConfig((String)((Hashtable)object).get("algo"), tObjectDoubleHashMap, hashMap, (Hashtable)object, (ArrayList)arrayList2.get(arrayList2.size() - 1));
                System.setOut(printStream);
                System.setErr(printStream2);
                fileOutputStream.close();
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        for (Object object : hashMap.keySet()) {
            System.out.println("\n#################\nBEST_CONFIG_FOR " + (String)object + " " + tObjectDoubleHashMap.get(object) + "\n" + CollectionUtil.Map2StringPrettyPrint((Hashtable)hashMap.get(object)));
            if (string4 == null) continue;
            hashtable2 = (Hashtable)((Hashtable)hashMap.get(object)).clone();
            hashtable2 = ConfigReader.read_config(hashtable2, string4);
            JuntoConfigRunner.apply(hashtable2, null);
        }
    }

    private static String GetOutputFileName(Hashtable hashtable, String string, String string2) {
        String string3 = " ";
        if (hashtable.get("algo").equals("mad") || hashtable.get("algo").equals("lgc") || hashtable.get("algo").equals("am") || hashtable.get("algo").equals("lclp")) {
            string3 = string + "/" + ConfigTuner.GetBaseName2(hashtable, string2);
        } else if (hashtable.get("algo").equals("maddl")) {
            string3 = string + "/" + ConfigTuner.GetBaseName2(hashtable, string2) + ".mu4_" + hashtable.get("mu4");
        } else if (hashtable.get("algo").equals("adsorption") || hashtable.get("algo").equals("lp_zgl")) {
            string3 = string + "/" + ConfigTuner.GetBaseName(hashtable, string2);
        } else {
            MessagePrinter.PrintAndDie("output_1 file can't be empty!");
        }
        return string3;
    }

    private static String GetLogFileName(Hashtable hashtable, String string, String string2) {
        String string3 = "";
        if (hashtable.get("algo").equals("mad") || hashtable.get("algo").equals("lgc") || hashtable.get("algo").equals("am") || hashtable.get("algo").equals("lclp")) {
            string3 = string + "/" + "log." + ConfigTuner.GetBaseName2(hashtable, string2);
        } else if (hashtable.get("algo").equals("maddl")) {
            string3 = string + "/" + "log." + ConfigTuner.GetBaseName2(hashtable, string2) + ".mu4_" + hashtable.get("mu4");
        } else if (hashtable.get("algo").equals("adsorption") || hashtable.get("algo").equals("lp_zgl")) {
            string3 = string + "/" + "log." + ConfigTuner.GetBaseName(hashtable, string2);
        } else {
            MessagePrinter.PrintAndDie("output_2 file can't be empty!");
        }
        return string3;
    }

    private static String GetBaseName(Hashtable hashtable, String string) {
        double d;
        String string2 = string;
        if (hashtable.containsKey("max_seeds_per_class")) {
            string2 = string2 + ".spc_" + hashtable.get("max_seeds_per_class");
        }
        string2 = string2 + "." + hashtable.get("algo");
        if (hashtable.containsKey("use_bipartite_optimization")) {
            string2 = string2 + ".bipart_opt_" + hashtable.get("use_bipartite_optimization");
        }
        if (hashtable.containsKey("top_k_neighbors")) {
            string2 = string2 + ".K_" + hashtable.get("top_k_neighbors");
        }
        if (hashtable.containsKey("prune_threshold")) {
            string2 = string2 + ".P_" + hashtable.get("prune_threshold");
        }
        if (hashtable.containsKey("high_prune_thresh")) {
            string2 = string2 + ".feat_prune_high_" + hashtable.get("high_prune_thresh");
        }
        if (hashtable.containsKey("keep_top_k_labels")) {
            string2 = string2 + ".top_labels_" + hashtable.get("keep_top_k_labels");
        }
        if (hashtable.containsKey("train_fract")) {
            string2 = string2 + ".train_fract_" + hashtable.get("train_fract");
        }
        if (Defaults.GetValueOrDefault((String)hashtable.get("set_gaussian_kernel_weights"), false)) {
            d = Double.parseDouble(Defaults.GetValueOrDie(hashtable, "gauss_sigma_factor"));
            string2 = string2 + ".gk_sig_" + d;
        }
        if (hashtable.containsKey("algo") && (hashtable.get("algo").equals("adsorption") || hashtable.get("algo").equals("mad") || hashtable.get("algo").equals("maddl"))) {
            d = Defaults.GetValueOrDefault((String)hashtable.get("beta"), 2.0);
            string2 = string2 + ".beta_" + d;
        }
        if (Defaults.GetValueOrDefault((String)hashtable.get("is_final_run"), false)) {
            string2 = string2 + ".split_id_" + Defaults.GetValueOrDie(hashtable, "split_id");
        }
        return string2;
    }

    private static String GetBaseName2(Hashtable hashtable, String string) {
        String string2 = ConfigTuner.GetBaseName(hashtable, string) + ".mu1_" + hashtable.get("mu1") + ".mu2_" + hashtable.get("mu2") + ".mu3_" + hashtable.get("mu3") + ".norm_" + hashtable.get("norm");
        return string2;
    }

    private static void UpdateBestConfig(String string, TObjectDoubleHashMap tObjectDoubleHashMap, HashMap<String, Hashtable> hashMap, Hashtable hashtable, ArrayList arrayList) {
        int n;
        TDoubleArrayList tDoubleArrayList = new TDoubleArrayList();
        for (n = 1; n < arrayList.size(); ++n) {
            TObjectDoubleHashMap tObjectDoubleHashMap2 = (TObjectDoubleHashMap)arrayList.get(n);
            tDoubleArrayList.add(tObjectDoubleHashMap2.get((Object)Constants.GetMRRString()));
        }
        if (tDoubleArrayList.size() > 0) {
            n = 0;
            for (int i = 1; i < tDoubleArrayList.size(); ++i) {
                if (!(tDoubleArrayList.get(i) > tDoubleArrayList.get(n))) continue;
                n = i;
            }
            double d = tDoubleArrayList.get(n);
            if (tObjectDoubleHashMap.size() == 0 || tObjectDoubleHashMap.get((Object)string) < d) {
                int n2 = tDoubleArrayList.indexOf(d) + 1;
                tObjectDoubleHashMap.put((Object)string, d);
                hashMap.put(string, (Hashtable)hashtable.clone());
                hashMap.get(string).put("iters", n2);
            }
        }
    }

    public static void main(String[] stringArray) {
        Hashtable<String, String> hashtable = ConfigReader.read_config(stringArray);
        ConfigTuner.Run(hashtable);
    }
}

