/*
 * Decompiled with CFR 0.152.
 */
package junto.app;

import com.typesafe.scalalogging.log4j.Logger;
import com.typesafe.scalalogging.log4j.Logging;
import java.util.ArrayList;
import java.util.Hashtable;
import junto.app.JuntoRunner$;
import junto.config.ConfigReader;
import junto.config.GraphConfigLoader$;
import junto.graph.Graph;
import junto.graph.GraphIo$;
import junto.util.CollectionUtil;
import junto.util.Defaults;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class JuntoConfigRunner$
implements Logging {
    public static final JuntoConfigRunner$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JuntoConfigRunner$();
    }

    private Logger logger$lzycompute() {
        JuntoConfigRunner$ juntoConfigRunner$ = this;
        synchronized (juntoConfigRunner$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void apply(Hashtable<String, String> config, ArrayList<Map<String, Object>> resultList) {
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(CollectionUtil.Map2StringPrettyPrint(config));
        }
        Graph graph = GraphConfigLoader$.MODULE$.apply(config);
        int maxIters = Integer.parseInt(config.get("iters"));
        boolean verbose = true;
        if (config.containsKey("verbose")) {
            verbose = new StringOps(Predef$.MODULE$.augmentString(config.get("verbose"))).toBoolean();
        }
        double mu1 = Defaults.GetValueOrDefault(config.get("mu1"), 1.0);
        double mu2 = Defaults.GetValueOrDefault(config.get("mu2"), 1.0);
        double mu3 = Defaults.GetValueOrDefault(config.get("mu3"), 1.0);
        int keepTopKLabels = Defaults.GetValueOrDefault(config.get("keep_top_k_labels"), Integer.MAX_VALUE);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Using keep_top_k_labels value: ").append((Object)BoxesRunTime.boxToInteger((int)keepTopKLabels)).toString());
        }
        boolean useBipartiteOptimization = Defaults.GetValueOrDefault(config.get("use_bipartite_optimization"), false);
        String algo = Defaults.GetValueOrDefault(config.get("algo"), "adsorption");
        JuntoRunner$.MODULE$.apply(algo, graph, maxIters, mu1, mu2, mu3, keepTopKLabels, useBipartiteOptimization, verbose, resultList);
        if (config.containsKey("output_file") && config.get("output_file").length() > 0) {
            GraphIo$.MODULE$.saveEstimatedScores(graph, config.get("output_file"));
        } else if (config.containsKey("output_base") && config.get("output_base").length() > 0) {
            GraphIo$.MODULE$.saveEstimatedScores(graph, new StringBuilder().append((Object)config.get("output_base")).append((Object)".mu2_").append((Object)BoxesRunTime.boxToDouble((double)mu2)).append((Object)".mu3_").append((Object)BoxesRunTime.boxToDouble((double)mu3)).toString());
        }
    }

    public void main(String[] args) {
        this.apply(ConfigReader.read_config(args), new ArrayList<Map<String, Object>>());
    }

    private JuntoConfigRunner$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

