/*
 * Decompiled with CFR 0.152.
 */
package junto.config;

import com.typesafe.scalalogging.log4j.Logger;
import com.typesafe.scalalogging.log4j.Logging;
import gnu.trove.map.hash.TObjectIntHashMap;
import junto.config.Edge;
import junto.config.Label;
import junto.graph.Graph;
import junto.graph.Vertex;
import junto.util.Constants;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class GraphBuilder$
implements Logging {
    public static final GraphBuilder$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GraphBuilder$();
    }

    private Logger logger$lzycompute() {
        GraphBuilder$ graphBuilder$ = this;
        synchronized (graphBuilder$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Graph apply(TraversableOnce<Edge> edges, TraversableOnce<Label> seeds) {
        return this.apply(edges, seeds, (TraversableOnce<Label>)Nil$.MODULE$);
    }

    public Graph apply(TraversableOnce<Edge> edges, TraversableOnce<Label> seeds, TraversableOnce<Label> testLabels) {
        return this.apply(edges, seeds, testLabels, 2.0, Integer.MAX_VALUE, Integer.MAX_VALUE, false, 0.0, null, false);
    }

    public Graph apply(TraversableOnce<Edge> edges, TraversableOnce<Label> seeds, TraversableOnce<Label> testLabels, double beta, int maxNeighbors, int maxSeedsPerClass, boolean setGaussianWeights, double sigmaFactor, String pruneThreshold, boolean isDirected) {
        Graph graph = new Graph();
        IntRef cnt = new IntRef(0);
        edges.foreach((Function1)new Serializable(isDirected, graph, cnt){
            public static final long serialVersionUID = 0L;
            private final boolean isDirected$1;
            private final Graph graph$1;
            private final IntRef cnt$1;

            public final Object apply(Edge edge) {
                Object object;
                ++this.cnt$1.elem;
                if (this.cnt$1.elem % 1000000 == 0 && GraphBuilder$.MODULE$.logger().underlying().isInfoEnabled()) {
                    GraphBuilder$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"Edges Processed: ").append((Object)BoxesRunTime.boxToInteger((int)this.cnt$1.elem)).toString());
                }
                Vertex dv = this.graph$1.AddVertex(edge.source(), Constants.GetDummyLabel(), this.graph$1.AddVertex$default$3());
                dv.setNeighbor(edge.target(), edge.weight());
                if (this.isDirected$1) {
                    object = BoxedUnit.UNIT;
                } else {
                    Vertex fv = this.graph$1.AddVertex(edge.target(), Constants.GetDummyLabel(), this.graph$1.AddVertex$default$3());
                    object = BoxesRunTime.boxToDouble((double)fv.setNeighbor(edge.source(), edge.weight()));
                }
                return object;
            }
            {
                this.isDirected$1 = isDirected$1;
                this.graph$1 = graph$1;
                this.cnt$1 = cnt$1;
            }
        });
        if (seeds.nonEmpty()) {
            graph.isSeedInjected_$eq(true);
            TObjectIntHashMap currSeedsPerClassCount = new TObjectIntHashMap();
            seeds.foreach((Function1)new Serializable(maxSeedsPerClass, graph, currSeedsPerClassCount){
                public static final long serialVersionUID = 0L;
                private final int maxSeedsPerClass$1;
                private final Graph graph$1;
                private final TObjectIntHashMap currSeedsPerClassCount$1;

                public final Object apply(Label seed) {
                    Object object;
                    Object object2 = this.currSeedsPerClassCount$1.containsKey((Object)seed.label()) ? BoxedUnit.UNIT : BoxesRunTime.boxToInteger((int)this.currSeedsPerClassCount$1.put((Object)seed.label(), 0));
                    Vertex vertex = this.graph$1.vertices().get(seed.vertex());
                    if (vertex == null) {
                        object = BoxedUnit.UNIT;
                    } else {
                        vertex.setGoldLabel(seed.label(), seed.score());
                        if (this.currSeedsPerClassCount$1.get((Object)seed.label()) < this.maxSeedsPerClass$1 && !vertex.injectedLabels().containsKey((Object)seed.label())) {
                            vertex.SetInjectedLabelScore(seed.label(), seed.score());
                            vertex.isSeedNode_$eq(true);
                            object = BoxesRunTime.boxToBoolean((boolean)this.currSeedsPerClassCount$1.increment((Object)seed.label()));
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    }
                    return object;
                }
                {
                    this.maxSeedsPerClass$1 = maxSeedsPerClass$1;
                    this.graph$1 = graph$1;
                    this.currSeedsPerClassCount$1 = currSeedsPerClassCount$1;
                }
            });
            graph.CalculateRandomWalkProbabilities(beta);
        }
        if (testLabels.nonEmpty()) {
            testLabels.foreach((Function1)new Serializable(graph){
                public static final long serialVersionUID = 0L;
                private final Graph graph$1;

                public final void apply(Label node) {
                    Vertex vertex = this.graph$1.vertices().get(node.vertex());
                    Predef$.MODULE$.assert(vertex != null);
                    vertex.setGoldLabel(node.label(), node.score());
                    vertex.isTestNode_$eq(true);
                }
                {
                    this.graph$1 = graph$1;
                }
            });
        }
        if (setGaussianWeights) {
            graph.SetGaussianWeights(sigmaFactor);
        }
        graph.KeepTopKNeighbors(maxNeighbors);
        if (pruneThreshold != null) {
            graph.PruneLowDegreeNodes(new StringOps(Predef$.MODULE$.augmentString(pruneThreshold)).toInt());
        }
        return graph;
    }

    private GraphBuilder$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

