/*
 * Decompiled with CFR 0.152.
 */
package junto.config;

import com.typesafe.scalalogging.log4j.Logger;
import com.typesafe.scalalogging.log4j.Logging;
import java.util.Hashtable;
import junto.config.Edge;
import junto.config.EdgeFileReader$;
import junto.config.GraphBuilder$;
import junto.config.Label;
import junto.config.LabelFileReader$;
import junto.graph.Graph;
import junto.util.Defaults;
import junto.util.GraphStats;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public final class GraphConfigLoader$
implements Logging {
    public static final GraphConfigLoader$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GraphConfigLoader$();
    }

    private Logger logger$lzycompute() {
        GraphConfigLoader$ graphConfigLoader$ = this;
        synchronized (graphConfigLoader$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Graph apply(Hashtable<String, String> config) {
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Going to build graph ...");
        }
        int maxSeedsPerClass = Defaults.GetValueOrDefault(config.get("max_seeds_per_class"), Integer.MAX_VALUE);
        double beta = Defaults.GetValueOrDefault(config.get("beta"), 2.0);
        boolean isDirected = Defaults.GetValueOrDefault(config.get("is_directed"), false);
        String edgeFilelist = Defaults.GetValueOrDie(config, "graph_file");
        List edges = (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])edgeFilelist.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Edge> apply(String x$1) {
                return EdgeFileReader$.MODULE$.apply(x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class)))).toList().flatten((Function1)Predef$.MODULE$.conforms());
        String seedFilelist = Defaults.GetValueOrDie(config, "seed_file");
        List seeds = (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])seedFilelist.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Label> apply(String x$2) {
                return LabelFileReader$.MODULE$.apply(x$2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class)))).toList().flatten((Function1)Predef$.MODULE$.conforms());
        List<Label> testLabels = config.containsKey("test_file") ? LabelFileReader$.MODULE$.apply(config.get("test_file")) : Nil$.MODULE$;
        boolean setGaussianWeights = Defaults.GetValueOrDefault(config.get("set_gaussian_kernel_weights"), false);
        double sigmaFactor = Defaults.GetValueOrDefault(config.get("gauss_sigma_factor"), 0.0);
        int maxNeighbors = Defaults.GetValueOrDefault(config.get("top_k_neighbors"), Integer.MAX_VALUE);
        Graph graph = GraphBuilder$.MODULE$.apply((TraversableOnce<Edge>)edges, (TraversableOnce<Label>)seeds, (TraversableOnce<Label>)testLabels, beta, maxNeighbors, maxSeedsPerClass, setGaussianWeights, sigmaFactor, config.get("prune_threshold"), isDirected);
        if (config.containsKey("gold_labels_file")) {
            graph.SetGoldLabels(config.get("gold_labels_file"));
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(GraphStats.PrintStats(graph));
        }
        return graph;
    }

    private GraphConfigLoader$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

