/*
 * Decompiled with CFR 0.152.
 */
package junto.graph;

import gnu.trove.iterator.TObjectDoubleIterator;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import junto.graph.Graph;
import junto.graph.Vertex;
import junto.util.CollectionUtil;
import junto.util.Constants;
import junto.util.ObjectDoublePair;

public class CrossValidationGenerator {
    static long _kDeterministicSeed = 100L;

    public static void Split(Graph graph, double d) {
        Object object;
        Random random = new Random(_kDeterministicSeed);
        TObjectDoubleHashMap tObjectDoubleHashMap = new TObjectDoubleHashMap();
        Iterator<String> iterator = graph.vertices().keySet().iterator();
        while (iterator.hasNext()) {
            object = graph.vertices().get(iterator.next());
            if (((Vertex)object).name().startsWith(Constants.GetFeatPrefix()) || ((Vertex)object).goldLabels().size() <= 0) continue;
            tObjectDoubleHashMap.put(object, random.nextDouble());
        }
        object = CollectionUtil.ReverseSortMap(tObjectDoubleHashMap);
        int n = ((ArrayList)object).size();
        double d2 = Math.ceil((double)n * d);
        for (int i = 0; i < n; ++i) {
            Vertex vertex = (Vertex)((ObjectDoublePair)((ArrayList)object).get(i)).GetLabel();
            if ((double)i < d2) {
                vertex.setIsSeedNode(true);
                TObjectDoubleIterator tObjectDoubleIterator = vertex.goldLabels().iterator();
                while (tObjectDoubleIterator.hasNext()) {
                    tObjectDoubleIterator.advance();
                    vertex.SetInjectedLabelScore((String)tObjectDoubleIterator.key(), tObjectDoubleIterator.value());
                }
                continue;
            }
            vertex.setIsTestNode(true);
        }
    }
}

