/*
 * Decompiled with CFR 0.152.
 */
package junto.graph;

import com.typesafe.scalalogging.log4j.Logger;
import com.typesafe.scalalogging.log4j.Logging;
import gnu.trove.iterator.TObjectDoubleIterator;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import junto.graph.Graph$;
import junto.graph.Vertex;
import junto.graph.Vertex$;
import junto.util.CollectionUtil;
import junto.util.ObjectDoublePair;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001\u001d\u0011Qa\u0012:ba\"T!a\u0001\u0003\u0002\u000b\u001d\u0014\u0018\r\u001d5\u000b\u0003\u0015\tQA[;oi>\u001c\u0001aE\u0002\u0001\u0011A\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#ii\u0011A\u0005\u0006\u0003'Q\tQ\u0001\\8hi)T!!\u0006\f\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005]A\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003e\t1aY8n\u0013\tY\"CA\u0004M_\u001e<\u0017N\\4\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001b\u0002\u0012\u0001\u0005\u0004%\taI\u0001\tm\u0016\u0014H/[2fgV\tA\u0005\u0005\u0003&Q)\"T\"\u0001\u0014\u000b\u0005\u001db\u0011\u0001B;uS2L!!\u000b\u0014\u0003\u000f!\u000b7\u000f['baB\u00111&\r\b\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'L\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021[A\u0011\u0001%N\u0005\u0003m\t\u0011aAV3si\u0016D\bB\u0002\u001d\u0001A\u0003%A%A\u0005wKJ$\u0018nY3tA!9!\b\u0001b\u0001\n\u0003Y\u0014A\u00027bE\u0016d7/F\u0001=!\ridIK\u0007\u0002})\u0011q\bQ\u0001\u0005Q\u0006\u001c\bN\u0003\u0002B\u0005\u0006\u0019Q.\u00199\u000b\u0005\r#\u0015!\u0002;s_Z,'\"A#\u0002\u0007\u001dtW/\u0003\u0002H}\t!Bk\u00142kK\u000e$Hi\\;cY\u0016D\u0015m\u001d5NCBDa!\u0013\u0001!\u0002\u0013a\u0014a\u00027bE\u0016d7\u000f\t\u0005\b\u0017\u0002\u0001\r\u0011\"\u0001M\u00039I7oU3fI&s'.Z2uK\u0012,\u0012!\u0014\t\u0003Y9K!aT\u0017\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u000b\u0001a\u0001\n\u0003\u0011\u0016AE5t'\u0016,G-\u00138kK\u000e$X\rZ0%KF$\"a\u0015,\u0011\u00051\"\u0016BA+.\u0005\u0011)f.\u001b;\t\u000f]\u0003\u0016\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010J\u0019\t\re\u0003\u0001\u0015)\u0003N\u0003=I7oU3fI&s'.Z2uK\u0012\u0004\u0003\"B.\u0001\t\u0003a\u0016!C!eIZ+'\u000f^3y)\u0011!TlX1\t\u000byS\u0006\u0019\u0001\u0016\u0002\t9\fW.\u001a\u0005\u0006Aj\u0003\rAK\u0001\u0006Y\u0006\u0014W\r\u001c\u0005\bEj\u0003\n\u00111\u0001d\u0003\u00199X-[4iiB\u0011A\u0006Z\u0005\u0003K6\u0012a\u0001R8vE2,\u0007\"B4\u0001\t\u0003A\u0017!C$fiZ+'\u000f^3y)\t!\u0014\u000eC\u0003_M\u0002\u0007!\u0006C\u0003l\u0001\u0011\u0005A.A\nQeVtW\rT8x\t\u0016<'/Z3O_\u0012,7\u000f\u0006\u0002T[\")aN\u001ba\u0001_\u0006\u0001R.\u001b8OK&<\u0007NY8s\u0007>,h\u000e\u001e\t\u0003YAL!!]\u0017\u0003\u0007%sG\u000fC\u0003t\u0001\u0011\u0005A/A\tLK\u0016\u0004Hk\u001c9L\u001d\u0016Lw\r\u001b2peN$\"aU;\t\u000bY\u0014\b\u0019A8\u0002\r-4\u0016\r\\;f\u0011\u0015A\b\u0001\"\u0001z\u0003I\u0019V\r^$bkN\u001c\u0018.\u00198XK&<\u0007\u000e^:\u0015\u0005MS\b\"B>x\u0001\u0004\u0019\u0017aC:jO6\fg)Y2u_JDQ! \u0001\u0005\ny\f\u0001dR3u\u0003Z,'/Y4f\u000b\u0012<WmV3jO\"$8+\u001d:u+\u0005\u0019\u0007bBA\u0001\u0001\u0011\u0005\u00111A\u0001\u000e'\u0016$xi\u001c7e\u0019\u0006\u0014W\r\\:\u0015\u0007M\u000b)\u0001\u0003\u0004\u0002\b}\u0004\rAK\u0001\u000fO>dG\rT1cK2\u001ch)\u001b7f\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\t\u0001eQ1mGVd\u0017\r^3SC:$w.\\,bY.\u0004&o\u001c2bE&d\u0017\u000e^5fgR\u00191+a\u0004\t\u000f\u0005E\u0011\u0011\u0002a\u0001G\u0006!!-\u001a;b\u0011%\t)\u0002AI\u0001\n\u0003\t9\"A\nBI\u00124VM\u001d;fq\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u001a)\u001a1-a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\n.\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class Graph
implements Logging {
    private final HashMap<String, Vertex> vertices;
    private final TObjectDoubleHashMap<String> labels;
    private boolean isSeedInjected;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Graph graph = this;
        synchronized (graph) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public HashMap<String, Vertex> vertices() {
        return this.vertices;
    }

    public TObjectDoubleHashMap<String> labels() {
        return this.labels;
    }

    public boolean isSeedInjected() {
        return this.isSeedInjected;
    }

    public void isSeedInjected_$eq(boolean x$1) {
        this.isSeedInjected = x$1;
    }

    public Vertex AddVertex(String name, String label, double weight) {
        Object object;
        Vertex v = this.vertices().get(name);
        if (v == null) {
            object = this.vertices().put(name, Vertex$.MODULE$.apply(name, label, weight));
        } else {
            v.setGoldLabel(label, weight);
            object = BoxedUnit.UNIT;
        }
        return this.vertices().get(name);
    }

    public double AddVertex$default$3() {
        return 1.0;
    }

    public Vertex GetVertex(String name) {
        Object object = this.vertices().containsKey(name) ? BoxedUnit.UNIT : new RuntimeException(new StringBuilder().append((Object)"Node ").append((Object)name).append((Object)" doesn't exist!").toString());
        return this.vertices().get(name);
    }

    public void PruneLowDegreeNodes(int minNeighborCount) {
        int totalPruned = 0;
        Iterator<String> vIter = this.vertices().keySet().iterator();
        while (vIter.hasNext()) {
            Vertex v = this.vertices().get(vIter.next());
            if (v.neighbors().keySet().size() > minNeighborCount) continue;
            Predef$.MODULE$.refArrayOps((Object[])v.GetNeighborNames()).foreach((Function1)new Serializable(this, v){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Graph $outer;
                private final Vertex v$1;

                public final double apply(String neighName) {
                    this.v$1.neighbors().remove((Object)neighName);
                    return this.$outer.vertices().get(neighName).neighbors().remove((Object)this.v$1.name());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.v$1 = v$1;
                }
            });
            vIter.remove();
            ++totalPruned;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Total nodes pruned: ").append((Object)BoxesRunTime.boxToInteger((int)totalPruned)).toString());
        }
    }

    public void KeepTopKNeighbors(int kValue) {
        IntRef totalEdges = new IntRef(0);
        JavaConversions$.MODULE$.asScalaSet(this.vertices().keySet()).foreach((Function1)new Serializable(this, kValue, totalEdges){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Graph $outer;
            private final int kValue$1;
            private final IntRef totalEdges$1;

            public final void apply(String vName) {
                Vertex v = this.$outer.vertices().get(vName);
                TObjectDoubleHashMap neighWeights = new TObjectDoubleHashMap();
                Predef$.MODULE$.refArrayOps((Object[])v.GetNeighborNames()).foreach((Function1)new Serializable(this, v, neighWeights){
                    public static final long serialVersionUID = 0L;
                    private final Vertex v$2;
                    private final TObjectDoubleHashMap neighWeights$1;

                    public final double apply(String neighName) {
                        return this.neighWeights$1.put((Object)neighName, this.v$2.GetNeighborWeight(neighName));
                    }
                    {
                        this.v$2 = v$2;
                        this.neighWeights$1 = neighWeights$1;
                    }
                });
                ArrayList<ObjectDoublePair> sortedNeighList = CollectionUtil.ReverseSortMap(neighWeights);
                ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(sortedNeighList).drop(this.kValue$1)).foreach((Function1)new Serializable(this, v){
                    public static final long serialVersionUID = 0L;
                    private final Vertex v$2;

                    public final double apply(ObjectDoublePair neighLabelScore) {
                        return this.v$2.neighbors().remove(neighLabelScore.GetLabel());
                    }
                    {
                        this.v$2 = v$2;
                    }
                });
                this.totalEdges$1.elem += v.neighbors().keySet().size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.kValue$1 = kValue$1;
                this.totalEdges$1 = totalEdges$1;
            }
        });
        JavaConversions$.MODULE$.asScalaSet(this.vertices().keySet()).foreach((Function1)new Serializable(this, totalEdges){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Graph $outer;
            public final IntRef totalEdges$1;

            public final void apply(String vName) {
                Vertex v = this.$outer.vertices().get(vName);
                Predef$.MODULE$.refArrayOps((Object[])v.GetNeighborNames()).foreach((Function1)new Serializable(this, v){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$KeepTopKNeighbors$2 $outer;
                    private final Vertex v$3;

                    public final void apply(String neighName) {
                        Vertex neigh = this.$outer.junto$graph$Graph$$anonfun$$$outer().vertices().get(neighName);
                        if (neigh.GetNeighborWeight(this.v$3.name()) == 0.0) {
                            neigh.setNeighbor(this.v$3.name(), this.v$3.GetNeighborWeight(neighName));
                            ++this.$outer.totalEdges$1.elem;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.v$3 = v$3;
                    }
                });
            }

            public /* synthetic */ Graph junto$graph$Graph$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.totalEdges$1 = totalEdges$1;
            }
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Total edges: ").append((Object)BoxesRunTime.boxToInteger((int)totalEdges.elem)).toString());
        }
    }

    public void SetGaussianWeights(double sigmaFactor) {
        double avgEdgeWeight = this.GetAverageEdgeWeightSqrt();
        JavaConversions$.MODULE$.asScalaSet(this.vertices().keySet()).foreach((Function1)new Serializable(this, sigmaFactor, avgEdgeWeight){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Graph $outer;
            private final double sigmaFactor$1;
            private final double avgEdgeWeight$1;

            public final void apply(String vName) {
                Vertex v = this.$outer.vertices().get(vName);
                TObjectDoubleIterator nIter = v.neighbors().iterator();
                while (nIter.hasNext()) {
                    nIter.advance();
                    String nName = (String)nIter.key();
                    double currWeight = nIter.value();
                    double sigmaSquarred = package$.MODULE$.pow(this.sigmaFactor$1 * this.avgEdgeWeight$1, 2.0);
                    double newWeight = package$.MODULE$.exp(-1.0 * currWeight / ((double)2 * sigmaSquarred));
                    v.neighbors().put((Object)nName, newWeight);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sigmaFactor$1 = sigmaFactor$1;
                this.avgEdgeWeight$1 = avgEdgeWeight$1;
            }
        });
    }

    private double GetAverageEdgeWeightSqrt() {
        IntRef totalEdges = new IntRef(0);
        DoubleRef totalDistance = new DoubleRef(0.0);
        JavaConversions$.MODULE$.asScalaSet(this.vertices().keySet()).foreach((Function1)new Serializable(this, totalEdges, totalDistance){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Graph $outer;
            private final IntRef totalEdges$2;
            private final DoubleRef totalDistance$1;

            public final void apply(String vName) {
                Vertex v = this.$outer.vertices().get(vName);
                TObjectDoubleIterator nIter = v.neighbors().iterator();
                while (nIter.hasNext()) {
                    nIter.advance();
                    ++this.totalEdges$2.elem;
                    this.totalDistance$1.elem += package$.MODULE$.sqrt(v.GetNeighborWeight((String)nIter.key()));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.totalEdges$2 = totalEdges$2;
                this.totalDistance$1 = totalDistance$1;
            }
        });
        return totalDistance.elem / (double)totalEdges.elem;
    }

    public void SetGoldLabels(String goldLabelsFile) {
        Source$.MODULE$.fromFile(goldLabelsFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Graph $outer;

            public final void apply(String line) {
                Vertex v;
                String[] fields = line.split("\t");
                Predef$.MODULE$.assert(fields.length == 3);
                if (this.$outer.logger().underlying().isInfoEnabled()) {
                    this.$outer.logger().underlying().info(line);
                }
                if ((v = this.$outer.vertices().get(fields[0])) != null) {
                    v.setGoldLabel(fields[1], new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble());
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void CalculateRandomWalkProbabilities(double beta) {
        IntRef totalZeroEntropyNeighborhoodNodes = new IntRef(0);
        JavaConversions$.MODULE$.asScalaSet(this.vertices().keySet()).foreach((Function1)new Serializable(this, beta, totalZeroEntropyNeighborhoodNodes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Graph $outer;
            private final double beta$1;
            private final IntRef totalZeroEntropyNeighborhoodNodes$1;

            public final void apply(String vName) {
                boolean isZeroEntropy = this.$outer.GetVertex(vName).CalculateRWProbabilities(this.beta$1);
                if (isZeroEntropy) {
                    ++this.totalZeroEntropyNeighborhoodNodes$1.elem;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.beta$1 = beta$1;
                this.totalZeroEntropyNeighborhoodNodes$1 = totalZeroEntropyNeighborhoodNodes$1;
            }
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"ZERO ENTROPY NEIGHBORHOOD Heuristic adjustment used for ").append((Object)BoxesRunTime.boxToInteger((int)totalZeroEntropyNeighborhoodNodes.elem)).append((Object)" nodes!").toString());
        }
    }

    public Graph() {
        Logging.class.$init$((Logging)this);
        this.vertices = new HashMap();
        this.labels = new TObjectDoubleHashMap();
        this.isSeedInjected = false;
    }
}

