/*
 * Decompiled with CFR 0.152.
 */
package junto.graph;

import com.typesafe.scalalogging.log4j.Logger;
import com.typesafe.scalalogging.log4j.Logging;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import junto.graph.Graph;
import junto.graph.Vertex;
import junto.graph.Vertex$;
import junto.util.CollectionUtil;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class GraphIo$
implements Logging {
    public static final GraphIo$ MODULE$;
    private final String kDelim_;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GraphIo$();
    }

    private Logger logger$lzycompute() {
        GraphIo$ graphIo$ = this;
        synchronized (graphIo$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String kDelim_() {
        return this.kDelim_;
    }

    public void saveEstimatedScores(Graph graph, String outputFile) {
        DoubleRef doc_mrr_sum = new DoubleRef(0.0);
        IntRef correct_doc_cnt = new IntRef(0);
        IntRef total_doc_cnt = new IntRef(0);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
        JavaConversions$.MODULE$.asScalaSet(graph.vertices().keySet()).foreach((Function1)new Serializable(graph, doc_mrr_sum, correct_doc_cnt, total_doc_cnt, bw){
            public static final long serialVersionUID = 0L;
            private final Graph graph$1;
            private final DoubleRef doc_mrr_sum$1;
            private final IntRef correct_doc_cnt$1;
            private final IntRef total_doc_cnt$1;
            private final BufferedWriter bw$1;

            public final void apply(String vName) {
                Vertex v = this.graph$1.vertices().get(vName);
                if (v.isTestNode()) {
                    double mrr = v.GetMRR();
                    ++this.total_doc_cnt$1.elem;
                    this.doc_mrr_sum$1.elem += mrr;
                    if (mrr == 1.0) {
                        ++this.correct_doc_cnt$1.elem;
                    }
                }
                this.bw$1.write(new StringBuilder().append((Object)v.name()).append((Object)GraphIo$.MODULE$.kDelim_()).append((Object)CollectionUtil.Map2String(v.goldLabels())).append((Object)GraphIo$.MODULE$.kDelim_()).append((Object)Vertex$.MODULE$.getPrettyPrintMap(v.injectedLabels())).append((Object)GraphIo$.MODULE$.kDelim_()).append((Object)Vertex$.MODULE$.getPrettyPrintMap(v.estimatedLabels())).append((Object)GraphIo$.MODULE$.kDelim_()).append((Object)BoxesRunTime.boxToBoolean((boolean)v.isTestNode())).append((Object)GraphIo$.MODULE$.kDelim_()).append((Object)BoxesRunTime.boxToDouble((double)v.GetMRR())).append((Object)"\n").toString());
            }
            {
                this.graph$1 = graph$1;
                this.doc_mrr_sum$1 = doc_mrr_sum$1;
                this.correct_doc_cnt$1 = correct_doc_cnt$1;
                this.total_doc_cnt$1 = total_doc_cnt$1;
                this.bw$1 = bw$1;
            }
        });
        bw.close();
        if (total_doc_cnt.elem > 0) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"PRECISION ").append((Object)BoxesRunTime.boxToDouble((double)((double)correct_doc_cnt.elem / (double)total_doc_cnt.elem))).append((Object)" (").append((Object)BoxesRunTime.boxToInteger((int)correct_doc_cnt.elem)).append((Object)" correct out of ").append((Object)BoxesRunTime.boxToInteger((int)total_doc_cnt.elem)).append((Object)")").toString());
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"MRR ").append((Object)BoxesRunTime.boxToDouble((double)(doc_mrr_sum.elem / (double)total_doc_cnt.elem))).toString());
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Total test instances evaluated: ").append((Object)BoxesRunTime.boxToInteger((int)total_doc_cnt.elem)).toString());
        }
    }

    private GraphIo$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.kDelim_ = "\t";
    }
}

