/*
 * Decompiled with CFR 0.152.
 */
package junto.graph.parallel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import junto.graph.Vertex;
import junto.util.CollectionUtil;
import junto.util.Constants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class Edge2NodeFactoredHadoop {
    private static String _kDelim = "\t";
    private static int kMaxNeighorsPerLine_ = 1000;
    private static double _kBeta = 2.0;
    private static String neighMsgType = "-NEIGH-";
    private static String goldLabMsgType = "-GOLD-";
    private static String injLabMsgType = "-INJ-";

    public static void main(String[] stringArray) throws Exception {
        JobConf jobConf = new JobConf(Edge2NodeFactoredHadoop.class);
        jobConf.setJobName("edge2node_hadoop");
        jobConf.setOutputKeyClass(Text.class);
        jobConf.setOutputValueClass(Text.class);
        jobConf.setMapperClass(Map.class);
        jobConf.setReducerClass(Reduce.class);
        jobConf.setInputFormat(TextInputFormat.class);
        jobConf.setOutputFormat(TextOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{new Path(stringArray[0])});
        jobConf.set("gold_label_file", stringArray[1]);
        jobConf.set("seed_label_file", stringArray[2]);
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(stringArray[3]));
        JobClient.runJob((JobConf)jobConf);
    }

    public static class Reduce
    extends MapReduceBase
    implements Reducer<Text, Text, Text, Text> {
        public void reduce(Text text, Iterator<Text> iterator, OutputCollector<Text, Text> outputCollector, Reporter reporter) throws IOException {
            String string;
            String[] stringArray;
            String string2;
            String string3 = text.toString();
            Vertex vertex = new Vertex(string3);
            while (iterator.hasNext()) {
                string2 = iterator.next().toString();
                stringArray = string2.split(_kDelim);
                string = stringArray[0];
                String string4 = stringArray[1];
                if (string.equals(neighMsgType)) {
                    vertex.setNeighbor(string4, Double.parseDouble(stringArray[2]));
                    continue;
                }
                if (string.equals(goldLabMsgType)) {
                    vertex.setGoldLabel(string4, Double.parseDouble(stringArray[2]));
                    continue;
                }
                if (!string.equals(injLabMsgType)) continue;
                vertex.SetInjectedLabelScore(string4, Double.parseDouble(stringArray[2]));
            }
            vertex.NormalizeTransitionProbability();
            vertex.SetInjectedLabelScore(Constants.GetDummyLabel(), 0.0);
            vertex.SetEstimatedLabelScore(Constants.GetDummyLabel(), 0.0);
            vertex.CalculateRWProbabilities(_kBeta);
            string2 = Constants._kInjProb + " " + vertex.pinject() + " " + Constants._kContProb + " " + vertex.pcontinue() + " " + Constants._kTermProb + " " + vertex.pabandon();
            stringArray = vertex.GetNeighborNames();
            string = "";
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (string.length() > 0 && i % kMaxNeighorsPerLine_ == 0) {
                    outputCollector.collect((Object)text, (Object)new Text(CollectionUtil.Map2String(vertex.goldLabels()) + _kDelim + CollectionUtil.Map2String(vertex.injectedLabels()) + _kDelim + CollectionUtil.Map2String(vertex.estimatedLabels()) + _kDelim + string.trim() + _kDelim + string2));
                    string = "";
                }
                string = string + stringArray[i] + " " + vertex.GetNeighborWeight(stringArray[i]) + " ";
            }
            if (string.length() > 0) {
                outputCollector.collect((Object)text, (Object)new Text(CollectionUtil.Map2String(vertex.goldLabels()) + _kDelim + CollectionUtil.Map2String(vertex.injectedLabels()) + _kDelim + CollectionUtil.Map2String(vertex.estimatedLabels()) + _kDelim + string.trim() + _kDelim + string2));
            }
        }
    }

    public static class Map
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, Text> {
        private HashMap<String, String> goldLabels;
        private HashMap<String, String> seedLabels;

        public void configure(JobConf jobConf) {
            this.goldLabels = this.LoadLabels(jobConf.get("gold_label_file"));
            this.seedLabels = this.LoadLabels(jobConf.get("seed_label_file"));
        }

        private HashMap<String, String> LoadLabels(String string) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                String string2;
                Path path = new Path(string);
                FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(path)));
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string2.split(_kDelim);
                    if (hashMap.containsKey(stringArray[0])) continue;
                    hashMap.put(stringArray[0], stringArray[1] + _kDelim + stringArray[2]);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return hashMap;
        }

        public void map(LongWritable longWritable, Text text, OutputCollector<Text, Text> outputCollector, Reporter reporter) throws IOException {
            String string = text.toString();
            String[] stringArray = string.split(_kDelim);
            outputCollector.collect((Object)new Text(stringArray[0]), (Object)new Text(neighMsgType + _kDelim + stringArray[1] + _kDelim + stringArray[2]));
            if (this.goldLabels.containsKey(stringArray[0])) {
                outputCollector.collect((Object)new Text(stringArray[0]), (Object)new Text(goldLabMsgType + _kDelim + this.goldLabels.get(stringArray[0])));
            }
            if (this.seedLabels.containsKey(stringArray[0])) {
                outputCollector.collect((Object)new Text(stringArray[0]), (Object)new Text(injLabMsgType + _kDelim + this.seedLabels.get(stringArray[0])));
            }
            if (!stringArray[0].equals(stringArray[1])) {
                outputCollector.collect((Object)new Text(stringArray[1]), (Object)new Text(neighMsgType + _kDelim + stringArray[0] + _kDelim + stringArray[2]));
                if (this.goldLabels.containsKey(stringArray[1])) {
                    outputCollector.collect((Object)new Text(stringArray[1]), (Object)new Text(goldLabMsgType + _kDelim + this.goldLabels.get(stringArray[1])));
                }
                if (this.seedLabels.containsKey(stringArray[1])) {
                    outputCollector.collect((Object)new Text(stringArray[1]), (Object)new Text(injLabMsgType + _kDelim + this.seedLabels.get(stringArray[1])));
                }
            }
        }
    }
}

