/*
 * Decompiled with CFR 0.152.
 */
package junto.graph.parallel;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import junto.config.ConfigReader;
import junto.config.GraphConfigLoader;
import junto.graph.Graph;
import junto.graph.Vertex;
import junto.util.CollectionUtil;
import junto.util.Constants;

public class EdgeFactored2NodeFactored {
    private static String kDelim_ = "\t";
    private static int kMaxNeighorsPerLine_ = 100;

    public static void main(String[] stringArray) {
        Hashtable<String, String> hashtable = ConfigReader.read_config(stringArray);
        Graph graph = GraphConfigLoader.apply(hashtable);
        if (hashtable.containsKey("hadoop_graph_file")) {
            EdgeFactored2NodeFactored.WriteToFile(graph, hashtable.get("hadoop_graph_file"));
        }
    }

    public static void WriteToFile(Graph graph, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (String string2 : graph.vertices().keySet()) {
                Vertex vertex = graph.vertices().get(string2);
                vertex.setGoldLabel(Constants.GetDummyLabel(), 0.0);
                vertex.SetEstimatedLabelScore(Constants.GetDummyLabel(), 0.0);
                String string3 = Constants._kInjProb + " " + vertex.pinject() + " " + Constants._kContProb + " " + vertex.pcontinue() + " " + Constants._kTermProb + " " + vertex.pabandon();
                String[] stringArray = vertex.GetNeighborNames();
                String string4 = "";
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (string4.length() > 0 && i % kMaxNeighorsPerLine_ == 0) {
                        bufferedWriter.write(vertex.name() + kDelim_ + CollectionUtil.Map2String(vertex.goldLabels()) + kDelim_ + CollectionUtil.Map2String(vertex.injectedLabels()) + kDelim_ + CollectionUtil.Map2String(vertex.estimatedLabels()) + kDelim_ + string4.trim() + kDelim_ + string3 + "\n");
                        string4 = "";
                    }
                    Vertex vertex2 = graph.vertices().get(stringArray[i]);
                    string4 = string4 + stringArray[i] + " " + vertex.GetNeighborWeight(stringArray[i]) + " ";
                }
                if (string4.length() <= 0) continue;
                bufferedWriter.write(vertex.name() + kDelim_ + CollectionUtil.Map2String(vertex.goldLabels()) + kDelim_ + CollectionUtil.Map2String(vertex.injectedLabels()) + kDelim_ + CollectionUtil.Map2String(vertex.estimatedLabels()) + kDelim_ + string4.trim() + kDelim_ + string3 + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

