/*
 * Decompiled with CFR 0.152.
 */
package junto.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import junto.config.ConfigReader;
import junto.config.GraphConfigLoader;
import junto.graph.Graph;
import junto.graph.Vertex;
import junto.util.MessagePrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class GraphStats {
    private static Logger logger = LogManager.getLogger(GraphStats.class);
    private static int _kPrime = -1;

    public static void PrintStats(Graph graph, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(GraphStats.PrintStats(graph));
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String PrintStats(Graph graph) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MAX_VALUE;
        for (String string : graph.vertices().keySet()) {
            Vertex vertex = graph.vertices().get(string);
            ++n5;
            int n8 = vertex.GetNeighborNames().length;
            if (n8 > n6) {
                n6 = n8;
            }
            if (n8 < n7) {
                n7 = n8;
            }
            n4 += vertex.neighbors().size();
            if (vertex.isSeedNode()) {
                ++n;
            }
            if (vertex.isTestNode()) {
                ++n2;
            }
            if (!vertex.isSeedNode() || !vertex.isTestNode()) continue;
            ++n3;
        }
        Object object = "Total seed vertices: " + n + "\n";
        object = (String)object + "Total test vertices: " + n2 + "\n";
        object = (String)object + "Total seed vertices which are also test vertices: " + n3 + "\n";
        object = (String)object + "Total vertices: " + n5 + "\n";
        object = (String)object + "Total edges: " + n4 + "\n";
        object = (String)object + "Average degree: " + 1.0 * (double)n4 / (double)n5 + "\n";
        object = (String)object + "Min degree: " + n7 + "\n";
        object = (String)object + "Max degree: " + n6 + "\n";
        return object;
    }

    private static String GetDiameter(DefaultDirectedWeightedGraph<Vertex, DefaultWeightedEdge> defaultDirectedWeightedGraph) {
        String string = "";
        boolean bl = true;
        int n = -1;
        int n2 = 0;
        for (Vertex vertex : defaultDirectedWeightedGraph.vertexSet()) {
            if (!vertex.isSeedNode()) continue;
            if (++n2 % 1000 == 0) {
                logger.info("Processed: " + n2 + " curr_dia: " + n);
            }
            KShortestPaths kShortestPaths = new KShortestPaths(defaultDirectedWeightedGraph, (Object)vertex, 1);
            for (Vertex vertex2 : defaultDirectedWeightedGraph.vertexSet()) {
                if (vertex.equals(vertex2)) continue;
                List list = kShortestPaths.getPaths((Object)vertex2);
                if (list == null) {
                    bl = false;
                    continue;
                }
                if (((GraphPath)list.get(0)).getEdgeList().size() <= n) continue;
                n = ((GraphPath)list.get(0)).getEdgeList().size();
            }
        }
        string = string + "Connected(from_seed_nodes): " + (bl ? "true" : "false") + "\n";
        string = string + "Diameter(from_seed_nodes): " + n + "\n";
        return string;
    }

    public static void main(String[] stringArray) {
        Hashtable<String, String> hashtable = ConfigReader.read_config(stringArray);
        Graph graph = GraphConfigLoader.apply(hashtable);
        MessagePrinter.Print(GraphStats.PrintStats(graph));
    }
}

