/*
 * Decompiled with CFR 0.152.
 */
package junto.util;

import gnu.trove.iterator.TObjectDoubleIterator;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import junto.util.CollectionUtil;
import junto.util.Constants;
import junto.util.ObjectDoublePair;

public class ProbUtil {
    public static TObjectDoubleHashMap GetUniformPrior(ArrayList<String> arrayList) {
        int n = arrayList.size();
        assert (n > 0);
        double d = 1.0 / (double)n;
        assert (d > 0.0);
        TObjectDoubleHashMap tObjectDoubleHashMap = new TObjectDoubleHashMap();
        for (int i = 0; i < n; ++i) {
            tObjectDoubleHashMap.put((Object)arrayList.get(i), d);
        }
        return tObjectDoubleHashMap;
    }

    public static void AddScores(TObjectDoubleHashMap tObjectDoubleHashMap, double d, TObjectDoubleHashMap tObjectDoubleHashMap2) {
        assert (tObjectDoubleHashMap != null);
        assert (tObjectDoubleHashMap2 != null);
        TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap2.iterator();
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            double d2 = d * tObjectDoubleIterator.value();
            tObjectDoubleHashMap.adjustOrPutValue(tObjectDoubleIterator.key(), d2, d2);
        }
    }

    public static void DivScores(TObjectDoubleHashMap tObjectDoubleHashMap, double d) {
        assert (tObjectDoubleHashMap != null);
        assert (d > 0.0);
        TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            double d2 = 1.0 * tObjectDoubleIterator.value() / d;
            tObjectDoubleHashMap.put(tObjectDoubleIterator.key(), d2);
        }
    }

    public static void KeepTopScoringKeys(TObjectDoubleHashMap tObjectDoubleHashMap, int n) {
        ArrayList<ObjectDoublePair> arrayList = CollectionUtil.ReverseSortMap(tObjectDoubleHashMap);
        tObjectDoubleHashMap.clear();
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < n3 && n2 < n; ++i) {
            ++n2;
            if (!(arrayList.get(i).GetScore() > 0.0)) continue;
            tObjectDoubleHashMap.put(arrayList.get(i).GetLabel(), arrayList.get(i).GetScore());
        }
        assert (tObjectDoubleHashMap.size() <= n);
    }

    public static void Normalize(TObjectDoubleHashMap tObjectDoubleHashMap) {
        ProbUtil.Normalize(tObjectDoubleHashMap, Integer.MAX_VALUE);
    }

    public static void Normalize(TObjectDoubleHashMap tObjectDoubleHashMap, int n) {
        if (n != Integer.MAX_VALUE) {
            ProbUtil.KeepTopScoringKeys(tObjectDoubleHashMap, n);
        }
        TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
        double d = 0.0;
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            d += tObjectDoubleIterator.value();
        }
        if (d > 0.0) {
            tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
            while (tObjectDoubleIterator.hasNext()) {
                tObjectDoubleIterator.advance();
                double d2 = tObjectDoubleIterator.value() / d;
                tObjectDoubleIterator.setValue(d2);
            }
        }
    }

    public static double GetSum(TObjectDoubleHashMap tObjectDoubleHashMap) {
        TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
        double d = 0.0;
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            d += tObjectDoubleIterator.value();
        }
        return d;
    }

    public static double GetDifferenceNorm2Squarred(TObjectDoubleHashMap tObjectDoubleHashMap, double d, TObjectDoubleHashMap tObjectDoubleHashMap2, double d2) {
        TObjectDoubleHashMap tObjectDoubleHashMap3 = new TObjectDoubleHashMap();
        TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            tObjectDoubleHashMap3.put(tObjectDoubleIterator.key(), d * tObjectDoubleIterator.value());
        }
        tObjectDoubleIterator = tObjectDoubleHashMap2.iterator();
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            tObjectDoubleHashMap3.adjustOrPutValue(tObjectDoubleIterator.key(), -1.0 * d2 * tObjectDoubleIterator.value(), -1.0 * d2 * tObjectDoubleIterator.value());
        }
        double d3 = 0.0;
        tObjectDoubleIterator = tObjectDoubleHashMap3.iterator();
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            d3 += tObjectDoubleIterator.value() * tObjectDoubleIterator.value();
        }
        return Math.sqrt(d3);
    }

    public static double GetKLDifference(TObjectDoubleHashMap tObjectDoubleHashMap, TObjectDoubleHashMap tObjectDoubleHashMap2) {
        double d = 0.0;
        TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            if (!(tObjectDoubleIterator.value() > 0.0)) continue;
            d += tObjectDoubleIterator.value() * Math.log((tObjectDoubleIterator.value() + Constants.GetSmallConstant()) / (tObjectDoubleHashMap2.get(tObjectDoubleIterator.key()) + Constants.GetSmallConstant()));
        }
        return d;
    }

    public static double GetEntropy(TObjectDoubleHashMap tObjectDoubleHashMap) {
        double d = 0.0;
        TObjectDoubleIterator tObjectDoubleIterator = tObjectDoubleHashMap.iterator();
        while (tObjectDoubleIterator.hasNext()) {
            tObjectDoubleIterator.advance();
            if (!(tObjectDoubleIterator.value() > 0.0)) continue;
            d += -1.0 * tObjectDoubleIterator.value() * Math.log(tObjectDoubleIterator.value());
        }
        return d;
    }
}

