/*
 * Decompiled with CFR 0.152.
 */
package junto.util;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class RyanAlphabet
implements Serializable {
    TObjectIntHashMap map;
    ArrayList entries;
    boolean growthStopped = false;
    Class entryClass = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public RyanAlphabet(int n, Class clazz) {
        this.map = new TObjectIntHashMap(n);
        this.entries = new ArrayList(n);
        this.entryClass = clazz;
    }

    public RyanAlphabet(Class clazz) {
        this(8, clazz);
    }

    public RyanAlphabet(int n) {
        this(n, null);
    }

    public RyanAlphabet() {
        this(8, null);
    }

    public Object clone() {
        RyanAlphabet ryanAlphabet = new RyanAlphabet();
        ryanAlphabet.map = new TObjectIntHashMap((TObjectIntMap)this.map);
        ryanAlphabet.entries = (ArrayList)this.entries.clone();
        ryanAlphabet.growthStopped = this.growthStopped;
        ryanAlphabet.entryClass = this.entryClass;
        return ryanAlphabet;
    }

    public int lookupIndex(Object object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an RyanAlphabet.");
        }
        if (this.entryClass == null) {
            this.entryClass = object.getClass();
        } else if (object.getClass() != this.entryClass) {
            throw new IllegalArgumentException("Non-matching entry class, " + object.getClass() + ", was " + this.entryClass);
        }
        int n = this.map.get(object);
        if (!this.map.containsKey(object) && !this.growthStopped && bl) {
            n = this.entries.size();
            this.map.put(object, this.entries.size());
            this.entries.add(object);
        }
        return n;
    }

    public int lookupIndex(Object object) {
        return this.lookupIndex(object, true);
    }

    public Object lookupObject(int n) {
        return this.entries.get(n);
    }

    public Object[] toArray() {
        return this.entries.toArray();
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public Object[] lookupObjects(int[] nArray) {
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.entries.get(nArray[i]);
        }
        return objectArray;
    }

    public int[] lookupIndices(Object[] objectArray, boolean bl) {
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = this.lookupIndex(objectArray[i], bl);
        }
        return nArray;
    }

    public boolean contains(Object object) {
        return this.map.contains(object);
    }

    public int size() {
        return this.entries.size();
    }

    public void stopGrowth() {
        this.growthStopped = true;
    }

    public void allowGrowth() {
        this.growthStopped = false;
    }

    public boolean growthStopped() {
        return this.growthStopped;
    }

    public Class entryClass() {
        return this.entryClass;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.entries.size(); ++i) {
            stringBuffer.append(this.entries.get(i).toString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream printStream) {
        for (int i = 0; i < this.entries.size(); ++i) {
            printStream.println(i + " => " + this.entries.get(i));
        }
    }

    public void dump(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < this.entries.size(); ++i) {
                bufferedWriter.write(this.entries.get(i) + "\t" + this.map.get(this.entries.get(i)) + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeInt(this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            objectOutputStream.writeObject(this.entries.get(i));
        }
        objectOutputStream.writeBoolean(this.growthStopped);
        objectOutputStream.writeObject(this.entryClass);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        this.entries = new ArrayList(n2);
        this.map = new TObjectIntHashMap(n2);
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            this.map.put(object, i);
            this.entries.add(object);
        }
        this.growthStopped = objectInputStream.readBoolean();
        this.entryClass = (Class)objectInputStream.readObject();
    }
}

