/*
 * Decompiled with CFR 0.152.
 */
package junto.util;

import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.map.hash.TIntDoubleHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import junto.util.RyanAlphabet;

public class RyanFeatureVector
implements Comparable,
Serializable {
    public int index;
    public double value;
    public RyanFeatureVector next;

    public RyanFeatureVector(int n, double d, RyanFeatureVector ryanFeatureVector) {
        this.index = n;
        this.value = d;
        this.next = ryanFeatureVector;
    }

    public RyanFeatureVector add(String string, double d, RyanAlphabet ryanAlphabet) {
        int n = ryanAlphabet.lookupIndex(string);
        if (n >= 0) {
            return new RyanFeatureVector(n, d, this);
        }
        return this;
    }

    public void add(int n, double d) {
        RyanFeatureVector ryanFeatureVector = new RyanFeatureVector(this.index, this.value, this.next);
        this.index = n;
        this.value = d;
        this.next = ryanFeatureVector;
    }

    public static RyanFeatureVector cat(RyanFeatureVector ryanFeatureVector, RyanFeatureVector ryanFeatureVector2) {
        RyanFeatureVector ryanFeatureVector3 = new RyanFeatureVector(-1, -1.0, null);
        RyanFeatureVector ryanFeatureVector4 = ryanFeatureVector;
        while (ryanFeatureVector4.next != null) {
            if (ryanFeatureVector4.index >= 0) {
                ryanFeatureVector3 = new RyanFeatureVector(ryanFeatureVector4.index, ryanFeatureVector4.value, ryanFeatureVector3);
            }
            ryanFeatureVector4 = ryanFeatureVector4.next;
        }
        ryanFeatureVector4 = ryanFeatureVector2;
        while (ryanFeatureVector4.next != null) {
            if (ryanFeatureVector4.index >= 0) {
                ryanFeatureVector3 = new RyanFeatureVector(ryanFeatureVector4.index, ryanFeatureVector4.value, ryanFeatureVector3);
            }
            ryanFeatureVector4 = ryanFeatureVector4.next;
        }
        return ryanFeatureVector3;
    }

    public static RyanFeatureVector getDistVector(RyanFeatureVector ryanFeatureVector, RyanFeatureVector ryanFeatureVector2) {
        RyanFeatureVector ryanFeatureVector3 = new RyanFeatureVector(-1, -1.0, null);
        RyanFeatureVector ryanFeatureVector4 = ryanFeatureVector;
        while (ryanFeatureVector4.next != null) {
            if (ryanFeatureVector4.index >= 0) {
                ryanFeatureVector3 = new RyanFeatureVector(ryanFeatureVector4.index, ryanFeatureVector4.value, ryanFeatureVector3);
            }
            ryanFeatureVector4 = ryanFeatureVector4.next;
        }
        ryanFeatureVector4 = ryanFeatureVector2;
        while (ryanFeatureVector4.next != null) {
            if (ryanFeatureVector4.index >= 0) {
                ryanFeatureVector3 = new RyanFeatureVector(ryanFeatureVector4.index, -ryanFeatureVector4.value, ryanFeatureVector3);
            }
            ryanFeatureVector4 = ryanFeatureVector4.next;
        }
        return ryanFeatureVector3;
    }

    public static RyanFeatureVector getAddedVector(RyanFeatureVector ryanFeatureVector, RyanFeatureVector ryanFeatureVector2, double d) {
        TIntDoubleHashMap tIntDoubleHashMap = new TIntDoubleHashMap();
        RyanFeatureVector ryanFeatureVector3 = ryanFeatureVector;
        while (ryanFeatureVector3.next != null) {
            if (ryanFeatureVector3.index >= 0) {
                tIntDoubleHashMap.put(ryanFeatureVector3.index, (tIntDoubleHashMap.containsKey(ryanFeatureVector3.index) ? tIntDoubleHashMap.get(ryanFeatureVector3.index) : 0.0) + ryanFeatureVector3.value);
            }
            ryanFeatureVector3 = ryanFeatureVector3.next;
        }
        ryanFeatureVector3 = ryanFeatureVector2;
        while (ryanFeatureVector3.next != null) {
            if (ryanFeatureVector3.index >= 0) {
                tIntDoubleHashMap.put(ryanFeatureVector3.index, (tIntDoubleHashMap.containsKey(ryanFeatureVector3.index) ? tIntDoubleHashMap.get(ryanFeatureVector3.index) : 0.0) + d * ryanFeatureVector3.value);
            }
            ryanFeatureVector3 = ryanFeatureVector3.next;
        }
        ryanFeatureVector3 = new RyanFeatureVector(-1, -1.0, null);
        TIntDoubleIterator tIntDoubleIterator = tIntDoubleHashMap.iterator();
        while (tIntDoubleIterator.hasNext()) {
            tIntDoubleIterator.advance();
            ryanFeatureVector3 = new RyanFeatureVector(tIntDoubleIterator.key(), tIntDoubleIterator.value(), ryanFeatureVector3);
        }
        return ryanFeatureVector3;
    }

    public static double dotProduct(RyanFeatureVector ryanFeatureVector, RyanFeatureVector ryanFeatureVector2) {
        double d = 0.0;
        TIntDoubleHashMap tIntDoubleHashMap = new TIntDoubleHashMap();
        TIntDoubleHashMap tIntDoubleHashMap2 = new TIntDoubleHashMap();
        Object object = ryanFeatureVector;
        while (((RyanFeatureVector)object).next != null) {
            if (((RyanFeatureVector)object).index >= 0) {
                tIntDoubleHashMap.put(((RyanFeatureVector)object).index, tIntDoubleHashMap.get(((RyanFeatureVector)object).index) + ((RyanFeatureVector)object).value);
            }
            object = ((RyanFeatureVector)object).next;
        }
        object = ryanFeatureVector2;
        while (((RyanFeatureVector)object).next != null) {
            if (((RyanFeatureVector)object).index >= 0) {
                tIntDoubleHashMap2.put(((RyanFeatureVector)object).index, tIntDoubleHashMap2.get(((RyanFeatureVector)object).index) + ((RyanFeatureVector)object).value);
            }
            object = ((RyanFeatureVector)object).next;
        }
        object = tIntDoubleHashMap.keys();
        for (int i = 0; i < ((Object)object).length; ++i) {
            double d2 = tIntDoubleHashMap.get((int)object[i]);
            double d3 = tIntDoubleHashMap2.get((int)object[i]);
            d += d2 * d3;
        }
        return d;
    }

    public static double oneNorm(RyanFeatureVector ryanFeatureVector) {
        double d = 0.0;
        RyanFeatureVector ryanFeatureVector2 = ryanFeatureVector;
        while (ryanFeatureVector2.next != null) {
            if (ryanFeatureVector2.index >= 0) {
                d += ryanFeatureVector2.value;
            }
            ryanFeatureVector2 = ryanFeatureVector2.next;
        }
        return d;
    }

    public static int size(RyanFeatureVector ryanFeatureVector) {
        int n = 0;
        RyanFeatureVector ryanFeatureVector2 = ryanFeatureVector;
        while (ryanFeatureVector2.next != null) {
            if (ryanFeatureVector2.index >= 0) {
                ++n;
            }
            ryanFeatureVector2 = ryanFeatureVector2.next;
        }
        return n;
    }

    public static double twoNorm(RyanFeatureVector ryanFeatureVector) {
        TIntDoubleHashMap tIntDoubleHashMap = new TIntDoubleHashMap();
        double d = 0.0;
        Object object = ryanFeatureVector;
        while (((RyanFeatureVector)object).next != null) {
            if (((RyanFeatureVector)object).index >= 0) {
                tIntDoubleHashMap.put(((RyanFeatureVector)object).index, tIntDoubleHashMap.get(((RyanFeatureVector)object).index) + ((RyanFeatureVector)object).value);
            }
            object = ((RyanFeatureVector)object).next;
        }
        object = tIntDoubleHashMap.keys();
        for (int i = 0; i < ((Object)object).length; ++i) {
            d += Math.pow(tIntDoubleHashMap.get((int)object[i]), 2.0);
        }
        return Math.sqrt(d);
    }

    public static RyanFeatureVector twoNormalize(RyanFeatureVector ryanFeatureVector) {
        return RyanFeatureVector.normalize(ryanFeatureVector, RyanFeatureVector.twoNorm(ryanFeatureVector));
    }

    public static RyanFeatureVector oneNormalize(RyanFeatureVector ryanFeatureVector) {
        return RyanFeatureVector.normalize(ryanFeatureVector, RyanFeatureVector.oneNorm(ryanFeatureVector));
    }

    public static RyanFeatureVector normalize(RyanFeatureVector ryanFeatureVector, double d) {
        RyanFeatureVector ryanFeatureVector2 = new RyanFeatureVector(-1, -1.0, null);
        RyanFeatureVector ryanFeatureVector3 = ryanFeatureVector;
        while (ryanFeatureVector3.next != null) {
            if (ryanFeatureVector3.index >= 0) {
                ryanFeatureVector2 = new RyanFeatureVector(ryanFeatureVector3.index, ryanFeatureVector3.value / d, ryanFeatureVector2);
            }
            ryanFeatureVector3 = ryanFeatureVector3.next;
        }
        return ryanFeatureVector2;
    }

    public String toString() {
        if (this.next == null) {
            return "" + this.index + ":" + this.value;
        }
        return this.index + ":" + this.value + " " + this.next.toString();
    }

    public void sort() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object object = this;
        while (object != null) {
            if (object.index >= 0) {
                arrayList.add((Object[])object);
            }
            object = object.next;
        }
        object = arrayList.toArray();
        Arrays.sort(object);
        RyanFeatureVector ryanFeatureVector = new RyanFeatureVector(-1, -1.0, null);
        for (int i = ((Object[])object).length - 1; i >= 0; --i) {
            RyanFeatureVector ryanFeatureVector2 = (RyanFeatureVector)object[i];
            ryanFeatureVector = new RyanFeatureVector(ryanFeatureVector2.index, ryanFeatureVector2.value, ryanFeatureVector);
        }
        this.index = ryanFeatureVector.index;
        this.value = ryanFeatureVector.value;
        this.next = ryanFeatureVector.next;
    }

    public int compareTo(Object object) {
        RyanFeatureVector ryanFeatureVector = (RyanFeatureVector)object;
        if (this.index < ryanFeatureVector.index) {
            return -1;
        }
        if (this.index > ryanFeatureVector.index) {
            return 1;
        }
        return 0;
    }

    public double dotProdoct(double[] dArray) {
        double d = 0.0;
        RyanFeatureVector ryanFeatureVector = this;
        while (ryanFeatureVector != null) {
            if (ryanFeatureVector.index >= 0) {
                d += dArray[ryanFeatureVector.index] * ryanFeatureVector.value;
            }
            ryanFeatureVector = ryanFeatureVector.next;
        }
        return d;
    }
}

