/*
 * Decompiled with CFR 0.152.
 */
package nak.io;

import java.io.File;
import java.io.IOException;
import nak.maxent.GISModel;
import nak.model.AbstractModel;
import nak.model.AbstractModelReader;
import nak.model.Context;
import nak.model.DataReader;

public class GISModelReader
extends AbstractModelReader {
    public GISModelReader(File file) throws IOException {
        super(file);
    }

    public GISModelReader(DataReader dataReader) {
        super(dataReader);
    }

    @Override
    public AbstractModel constructModel() throws IOException {
        int n = this.getCorrectionConstant();
        double d = this.getCorrectionParameter();
        String[] stringArray = this.getOutcomes();
        int[][] nArray = this.getOutcomePatterns();
        String[] stringArray2 = this.getPredicates();
        Context[] contextArray = this.getParameters(nArray);
        return new GISModel(contextArray, stringArray2, stringArray, n, d);
    }

    @Override
    public void checkModelType() throws IOException {
        String string = this.readUTF();
        if (!string.equals("GIS")) {
            System.out.println("Error: attempting to load a " + string + " model as a GIS model." + " You should expect problems.");
        }
    }

    protected int getCorrectionConstant() throws IOException {
        return this.readInt();
    }

    protected double getCorrectionParameter() throws IOException {
        return this.readDouble();
    }
}

