/*
 * Decompiled with CFR 0.152.
 */
package nak.io;

import java.io.File;
import java.io.IOException;
import nak.model.AbstractModel;
import nak.model.AbstractModelReader;
import nak.model.Context;
import nak.model.DataReader;
import nak.quasinewton.QNModel;

public class QNModelReader
extends AbstractModelReader {
    public QNModelReader(DataReader dataReader) {
        super(dataReader);
    }

    public QNModelReader(File file) throws IOException {
        super(file);
    }

    @Override
    public void checkModelType() throws IOException {
        String string = this.readUTF();
        if (!string.equals("QN")) {
            System.out.println("Error: attempting to load a " + string + " model as a MAXENT_QN model." + " You should expect problems.");
        }
    }

    @Override
    public AbstractModel constructModel() throws IOException {
        String[] stringArray = this.getPredicates();
        String[] stringArray2 = this.getOutcomes();
        Context[] contextArray = this.getParameters();
        double[] dArray = this.getDoubleArrayParams();
        return new QNModel(stringArray, stringArray2, contextArray, dArray);
    }

    private double[] getDoubleArrayParams() throws IOException {
        int n = this.readInt();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.readDouble();
        }
        return dArray;
    }

    private int[] getIntArrayParams() throws IOException {
        int n = this.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readInt();
        }
        return nArray;
    }

    protected Context[] getParameters() throws IOException {
        int n = this.readInt();
        Context[] contextArray = new Context[n];
        for (int i = 0; i < n; ++i) {
            int[] nArray = this.getIntArrayParams();
            double[] dArray = this.getDoubleArrayParams();
            contextArray[i] = new Context(nArray, dArray);
        }
        return contextArray;
    }
}

