/*
 * Decompiled with CFR 0.152.
 */
package nak.io;

import java.io.IOException;
import nak.model.AbstractModel;
import nak.model.AbstractModelWriter;
import nak.model.Context;
import nak.model.IndexHashTable;
import nak.quasinewton.QNModel;

public abstract class QNModelWriter
extends AbstractModelWriter {
    protected String[] outcomeNames;
    protected String[] predNames;
    protected Context[] params;
    protected double[] predParams;
    protected IndexHashTable<String> pmap;
    protected double[] parameters;

    public QNModelWriter(AbstractModel abstractModel) {
        Object[] objectArray = abstractModel.getDataStructures();
        this.params = (Context[])objectArray[0];
        this.pmap = (IndexHashTable)objectArray[1];
        this.outcomeNames = (String[])objectArray[2];
        QNModel qNModel = (QNModel)abstractModel;
        this.parameters = qNModel.getParameters();
    }

    @Override
    public void persist() throws IOException {
        int n;
        this.writeUTF("QN");
        this.predNames = new String[this.pmap.size()];
        this.pmap.toArray((String[])this.predNames);
        this.writeInt(this.predNames.length);
        for (n = 0; n < this.predNames.length; ++n) {
            this.writeUTF(this.predNames[n]);
        }
        this.writeInt(this.outcomeNames.length);
        for (n = 0; n < this.outcomeNames.length; ++n) {
            this.writeUTF(this.outcomeNames[n]);
        }
        this.writeInt(this.params.length);
        for (Context context : this.params) {
            int n2;
            this.writeInt(context.getOutcomes().length);
            for (n2 = 0; n2 < context.getOutcomes().length; ++n2) {
                this.writeInt(context.getOutcomes()[n2]);
            }
            this.writeInt(context.getParameters().length);
            for (n2 = 0; n2 < context.getParameters().length; ++n2) {
                this.writeDouble(context.getParameters()[n2]);
            }
        }
        this.writeInt(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.writeDouble(this.parameters[i]);
        }
        this.close();
    }
}

