/*
 * Decompiled with CFR 0.152.
 */
package nak.maxent;

import java.io.IOException;
import nak.maxent.GISModel;
import nak.maxent.GISTrainer;
import nak.model.DataIndexer;
import nak.model.EventStream;
import nak.model.Prior;
import nak.model.UniformPrior;

public class GIS {
    public static boolean PRINT_MESSAGES = true;
    public static double SMOOTHING_OBSERVATION = 0.1;

    public static GISModel trainModel(EventStream eventStream) throws IOException {
        return GIS.trainModel(eventStream, 100, 0, false, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, boolean bl) throws IOException {
        return GIS.trainModel(eventStream, 100, 0, bl, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, int n, int n2) throws IOException {
        return GIS.trainModel(eventStream, n, n2, false, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, int n, int n2, boolean bl, boolean bl2) throws IOException {
        GISTrainer gISTrainer = new GISTrainer(bl2);
        gISTrainer.setSmoothing(bl);
        gISTrainer.setSmoothingObservation(SMOOTHING_OBSERVATION);
        return gISTrainer.trainModel(eventStream, n, n2);
    }

    public static GISModel trainModel(EventStream eventStream, int n, int n2, double d) throws IOException {
        GISTrainer gISTrainer = new GISTrainer(PRINT_MESSAGES);
        if (d > 0.0) {
            gISTrainer.setGaussianSigma(d);
        }
        return gISTrainer.trainModel(eventStream, n, n2);
    }

    public static GISModel trainModel(int n, DataIndexer dataIndexer, boolean bl) {
        return GIS.trainModel(n, dataIndexer, true, bl, null, 0);
    }

    public static GISModel trainModel(int n, DataIndexer dataIndexer) {
        return GIS.trainModel(n, dataIndexer, true, false, null, 0);
    }

    public static GISModel trainModel(int n, DataIndexer dataIndexer, Prior prior, int n2) {
        return GIS.trainModel(n, dataIndexer, true, false, prior, n2);
    }

    public static GISModel trainModel(int n, DataIndexer dataIndexer, boolean bl, boolean bl2, Prior prior, int n2) {
        return GIS.trainModel(n, dataIndexer, bl, bl2, prior, n2, 1);
    }

    public static GISModel trainModel(int n, DataIndexer dataIndexer, boolean bl, boolean bl2, Prior prior, int n2, int n3) {
        GISTrainer gISTrainer = new GISTrainer(bl);
        gISTrainer.setSmoothing(bl2);
        gISTrainer.setSmoothingObservation(SMOOTHING_OBSERVATION);
        if (prior == null) {
            prior = new UniformPrior();
        }
        return gISTrainer.trainModel(n, dataIndexer, prior, n2, n3);
    }
}

