/*
 * Decompiled with CFR 0.152.
 */
package nak.maxent;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import nak.io.SuffixSensitiveGISModelReader;
import nak.model.AbstractModel;
import nak.model.Context;
import nak.model.EvalParameters;
import nak.model.Prior;
import nak.model.UniformPrior;

public final class GISModel
extends AbstractModel {
    public GISModel(Context[] contextArray, String[] stringArray, String[] stringArray2, int n, double d) {
        this(contextArray, stringArray, stringArray2, n, d, new UniformPrior());
    }

    public GISModel(Context[] contextArray, String[] stringArray, String[] stringArray2, int n, double d, Prior prior) {
        super(contextArray, stringArray, stringArray2, n, d);
        this.prior = prior;
        prior.setLabels(stringArray2, stringArray);
        this.modelType = AbstractModel.ModelType.Maxent;
    }

    @Override
    public final double[] eval(String[] stringArray) {
        return this.eval(stringArray, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public final double[] eval(String[] stringArray, float[] fArray) {
        return this.eval(stringArray, fArray, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public final double[] eval(String[] stringArray, double[] dArray) {
        return this.eval(stringArray, null, dArray);
    }

    public final double[] eval(String[] stringArray, float[] fArray, double[] dArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = this.pmap.get(stringArray[i]);
            nArray[i] = n == null ? -1 : n;
        }
        this.prior.logPrior(dArray, nArray, fArray);
        return GISModel.eval(nArray, fArray, dArray, this.evalParams);
    }

    public static double[] eval(int[] nArray, double[] dArray, EvalParameters evalParameters) {
        return GISModel.eval(nArray, null, dArray, evalParameters);
    }

    public static double[] eval(int[] nArray, float[] fArray, double[] dArray, EvalParameters evalParameters) {
        int n;
        Context[] contextArray = evalParameters.getParams();
        int[] nArray2 = new int[evalParameters.getNumOutcomes()];
        double d = 1.0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) continue;
            Context context = contextArray[nArray[i]];
            int[] nArray3 = context.getOutcomes();
            double[] dArray2 = context.getParameters();
            if (fArray != null) {
                d = fArray[i];
            }
            for (n = 0; n < nArray3.length; ++n) {
                int n2;
                int n3 = n2 = nArray3[n];
                nArray2[n3] = nArray2[n3] + 1;
                int n4 = n2;
                dArray[n4] = dArray[n4] + dArray2[n] * d;
            }
        }
        double d2 = 0.0;
        for (n = 0; n < evalParameters.getNumOutcomes(); ++n) {
            dArray[n] = evalParameters.getCorrectionParam() != 0.0 ? Math.exp(dArray[n] * evalParameters.getConstantInverse() + (1.0 - (double)nArray2[n] / evalParameters.getCorrectionConstant()) * evalParameters.getCorrectionParam()) : Math.exp(dArray[n] * evalParameters.getConstantInverse());
            d2 += dArray[n];
        }
        n = 0;
        while (n < evalParameters.getNumOutcomes()) {
            int n5 = n++;
            dArray[n5] = dArray[n5] / d2;
        }
        return dArray;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: GISModel modelname < contexts");
            System.exit(1);
        }
        AbstractModel abstractModel = new SuffixSensitiveGISModelReader(new File(stringArray[0])).getModel();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        DecimalFormat decimalFormat = new DecimalFormat(".###");
        String string = bufferedReader.readLine();
        while (string != null) {
            String[] stringArray2 = string.split(" ");
            double[] dArray = abstractModel.eval(stringArray2);
            for (int i = 0; i < dArray.length; ++i) {
                System.out.print("[" + abstractModel.getOutcome(i) + " " + decimalFormat.format(dArray[i]) + "] ");
            }
            System.out.println();
            string = bufferedReader.readLine();
        }
    }
}

