/*
 * Decompiled with CFR 0.152.
 */
package nak.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nak.model.ComparableEvent;
import nak.model.DataIndexer;

public abstract class AbstractDataIndexer
implements DataIndexer {
    private int numEvents;
    protected int[][] contexts;
    protected int[] outcomeList;
    protected int[] numTimesEventsSeen;
    protected String[] predLabels;
    protected String[] outcomeLabels;
    protected int[] predCounts;

    @Override
    public int[][] getContexts() {
        return this.contexts;
    }

    @Override
    public int[] getNumTimesEventsSeen() {
        return this.numTimesEventsSeen;
    }

    @Override
    public int[] getOutcomeList() {
        return this.outcomeList;
    }

    @Override
    public String[] getPredLabels() {
        return this.predLabels;
    }

    @Override
    public String[] getOutcomeLabels() {
        return this.outcomeLabels;
    }

    @Override
    public int[] getPredCounts() {
        return this.predCounts;
    }

    protected int sortAndMerge(List<ComparableEvent> list, boolean bl) {
        ComparableEvent comparableEvent;
        int n;
        int n2 = 1;
        this.numEvents = list.size();
        if (bl) {
            Collections.sort(list);
            if (this.numEvents <= 1) {
                return n2;
            }
            ComparableEvent comparableEvent2 = list.get(0);
            for (n = 1; n < this.numEvents; ++n) {
                comparableEvent = list.get(n);
                if (comparableEvent2.compareTo(comparableEvent) == 0) {
                    ++comparableEvent2.seen;
                    list.set(n, null);
                    continue;
                }
                comparableEvent2 = comparableEvent;
                ++n2;
            }
        } else {
            n2 = list.size();
        }
        if (bl) {
            System.out.println("done. Reduced " + this.numEvents + " events to " + n2 + ".");
        }
        this.contexts = new int[n2][];
        this.outcomeList = new int[n2];
        this.numTimesEventsSeen = new int[n2];
        n = 0;
        for (int i = 0; i < this.numEvents; ++i) {
            comparableEvent = list.get(i);
            if (null == comparableEvent) continue;
            this.numTimesEventsSeen[n] = comparableEvent.seen;
            this.outcomeList[n] = comparableEvent.outcome;
            this.contexts[n] = comparableEvent.predIndexes;
            ++n;
        }
        return n2;
    }

    @Override
    public int getNumEvents() {
        return this.numEvents;
    }

    protected static void update(String[] stringArray, Set<String> set, Map<String, Integer> map, int n) {
        for (String string : stringArray) {
            Integer n2 = map.get(string);
            if (n2 == null) {
                map.put(string, 1);
            } else {
                map.put(string, n2 + 1);
            }
            if (set.contains(string) || map.get(string) < n) continue;
            set.add(string);
        }
    }

    protected static String[] toIndexedStringArray(Map<String, Integer> map) {
        String[] stringArray = new String[map.size()];
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[map.get((Object)string).intValue()] = string = iterator.next();
        }
        return stringArray;
    }

    @Override
    public float[][] getValues() {
        return null;
    }
}

