/*
 * Decompiled with CFR 0.152.
 */
package nak.model;

import java.text.DecimalFormat;
import nak.model.Context;
import nak.model.EvalParameters;
import nak.model.IndexHashTable;
import nak.model.MaxentModel;
import nak.model.Prior;

public abstract class AbstractModel
implements MaxentModel {
    protected IndexHashTable<String> pmap;
    protected String[] outcomeNames;
    protected EvalParameters evalParams;
    protected Prior prior;
    protected ModelType modelType;

    public AbstractModel(Context[] contextArray, String[] stringArray, IndexHashTable<String> indexHashTable, String[] stringArray2) {
        this.pmap = indexHashTable;
        this.outcomeNames = stringArray2;
        this.evalParams = new EvalParameters(contextArray, stringArray2.length);
    }

    public AbstractModel(Context[] contextArray, String[] stringArray, String[] stringArray2) {
        this.init(stringArray, stringArray2);
        this.evalParams = new EvalParameters(contextArray, stringArray2.length);
    }

    public AbstractModel(Context[] contextArray, String[] stringArray, String[] stringArray2, int n, double d) {
        this.init(stringArray, stringArray2);
        this.evalParams = new EvalParameters(contextArray, d, n, stringArray2.length);
    }

    private void init(String[] stringArray, String[] stringArray2) {
        this.pmap = new IndexHashTable<String>(stringArray, 0.7);
        this.outcomeNames = stringArray2;
    }

    @Override
    public final String getBestOutcome(double[] dArray) {
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        return this.outcomeNames[n];
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public final String getAllOutcomes(double[] dArray) {
        if (dArray.length != this.outcomeNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0000");
        StringBuilder stringBuilder = new StringBuilder(dArray.length * 2);
        stringBuilder.append(this.outcomeNames[0]).append("[").append(decimalFormat.format(dArray[0])).append("]");
        for (int i = 1; i < dArray.length; ++i) {
            stringBuilder.append("  ").append(this.outcomeNames[i]).append("[").append(decimalFormat.format(dArray[i])).append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public final String getOutcome(int n) {
        return this.outcomeNames[n];
    }

    @Override
    public int getIndex(String string) {
        for (int i = 0; i < this.outcomeNames.length; ++i) {
            if (!this.outcomeNames[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNumOutcomes() {
        return this.evalParams.getNumOutcomes();
    }

    @Override
    public final Object[] getDataStructures() {
        Object[] objectArray = new Object[]{this.evalParams.getParams(), this.pmap, this.outcomeNames, (int)this.evalParams.getCorrectionConstant(), this.evalParams.getCorrectionParam()};
        return objectArray;
    }

    public static enum ModelType {
        Maxent,
        Perceptron,
        MaxentQn;

    }
}

