/*
 * Decompiled with CFR 0.152.
 */
package nak.perceptron;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import nak.model.AbstractModel;
import nak.perceptron.PerceptronModelWriter;

public class BinaryPerceptronModelWriter
extends PerceptronModelWriter {
    DataOutputStream output;

    public BinaryPerceptronModelWriter(AbstractModel abstractModel, File file) throws IOException {
        super(abstractModel);
        this.output = file.getName().endsWith(".gz") ? new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file))) : new DataOutputStream(new FileOutputStream(file));
    }

    public BinaryPerceptronModelWriter(AbstractModel abstractModel, DataOutputStream dataOutputStream) {
        super(abstractModel);
        this.output = dataOutputStream;
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.output.writeUTF(string);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.output.writeInt(n);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.output.writeDouble(d);
    }

    @Override
    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

