/*
 * Decompiled with CFR 0.152.
 */
package nak.perceptron;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nak.model.AbstractModel;
import nak.model.AbstractModelWriter;
import nak.model.ComparablePredicate;
import nak.model.Context;
import nak.model.IndexHashTable;

public abstract class PerceptronModelWriter
extends AbstractModelWriter {
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected String[] PRED_LABELS;
    int numOutcomes;

    public PerceptronModelWriter(AbstractModel abstractModel) {
        Object[] objectArray = abstractModel.getDataStructures();
        this.numOutcomes = abstractModel.getNumOutcomes();
        this.PARAMS = (Context[])objectArray[0];
        IndexHashTable indexHashTable = (IndexHashTable)objectArray[1];
        this.OUTCOME_LABELS = (String[])objectArray[2];
        this.PRED_LABELS = new String[indexHashTable.size()];
        indexHashTable.toArray(this.PRED_LABELS);
    }

    protected ComparablePredicate[] sortValues() {
        ComparablePredicate[] comparablePredicateArray = new ComparablePredicate[this.PARAMS.length];
        int[] nArray = new int[this.numOutcomes];
        double[] dArray = new double[this.numOutcomes];
        int n = 0;
        for (int i = 0; i < this.PARAMS.length; ++i) {
            int n2 = 0;
            double[] dArray2 = this.PARAMS[i].getParameters();
            int[] nArray2 = this.PARAMS[i].getOutcomes();
            for (int j = 0; j < dArray2.length; ++j) {
                if (dArray2[j] == 0.0) continue;
                nArray[n2] = nArray2[j];
                dArray[n2] = dArray2[j];
                ++n2;
            }
            int[] nArray3 = new int[n2];
            double[] dArray3 = new double[n2];
            for (int j = 0; j < n2; ++j) {
                nArray3[j] = nArray[j];
                dArray3[j] = dArray[j];
            }
            if (n2 == 0) continue;
            comparablePredicateArray[n] = new ComparablePredicate(this.PRED_LABELS[i], nArray3, dArray3);
            ++n;
        }
        System.err.println("Compressed " + this.PARAMS.length + " parameters to " + n);
        Object[] objectArray = new ComparablePredicate[n];
        System.arraycopy(comparablePredicateArray, 0, objectArray, 0, n);
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected List<List<ComparablePredicate>> computeOutcomePatterns(ComparablePredicate[] comparablePredicateArray) {
        ComparablePredicate comparablePredicate = comparablePredicateArray[0];
        ArrayList<List<ComparablePredicate>> arrayList = new ArrayList<List<ComparablePredicate>>();
        ArrayList<ComparablePredicate> arrayList2 = new ArrayList<ComparablePredicate>();
        for (ComparablePredicate comparablePredicate2 : comparablePredicateArray) {
            if (comparablePredicate.compareTo(comparablePredicate2) == 0) {
                arrayList2.add(comparablePredicate2);
                continue;
            }
            comparablePredicate = comparablePredicate2;
            arrayList.add(arrayList2);
            arrayList2 = new ArrayList();
            arrayList2.add(comparablePredicate2);
        }
        arrayList.add(arrayList2);
        System.err.println(arrayList.size() + " outcome patterns");
        return arrayList;
    }

    @Override
    public void persist() throws IOException {
        this.writeUTF("Perceptron");
        this.writeInt(this.OUTCOME_LABELS.length);
        for (String object : this.OUTCOME_LABELS) {
            this.writeUTF(object);
        }
        Object[] objectArray = this.sortValues();
        List<List<ComparablePredicate>> list = this.computeOutcomePatterns((ComparablePredicate[])objectArray);
        this.writeInt(list.size());
        for (List<ComparablePredicate> list2 : list) {
            this.writeUTF(list2.size() + list2.get(0).toString());
        }
        this.writeInt(objectArray.length);
        for (Object object : objectArray) {
            this.writeUTF(((ComparablePredicate)object).name);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < ((ComparablePredicate)objectArray[i]).params.length; ++j) {
                this.writeDouble(((ComparablePredicate)objectArray[i]).params[j]);
            }
        }
        this.close();
    }
}

