/*
 * Decompiled with CFR 0.152.
 */
package nak.quasinewton;

import nak.model.AbstractModel;
import nak.model.Context;
import nak.model.EvalParameters;
import nak.model.UniformPrior;
import nak.quasinewton.LogLikelihoodFunction;

public class QNModel
extends AbstractModel {
    private static final double SMOOTHING_VALUE = 0.1;
    private double[] parameters;

    public QNModel(LogLikelihoodFunction logLikelihoodFunction, double[] dArray) {
        super(null, logLikelihoodFunction.getPredLabels(), logLikelihoodFunction.getOutcomeLabels());
        int[][] nArray = logLikelihoodFunction.getOutcomePatterns();
        Context[] contextArray = new Context[logLikelihoodFunction.getPredLabels().length];
        for (int i = 0; i < contextArray.length; ++i) {
            int[] nArray2 = nArray[i];
            double[] dArray2 = new double[nArray2.length];
            for (int j = 0; j < nArray2.length; ++j) {
                dArray2[j] = dArray[i + nArray2[j] * logLikelihoodFunction.getPredLabels().length];
            }
            contextArray[i] = new Context(nArray2, dArray2);
        }
        this.evalParams = new EvalParameters(contextArray, logLikelihoodFunction.getOutcomeLabels().length);
        this.prior = new UniformPrior();
        this.modelType = AbstractModel.ModelType.MaxentQn;
        this.parameters = dArray;
    }

    public QNModel(String[] stringArray, String[] stringArray2, Context[] contextArray, double[] dArray) {
        super(contextArray, stringArray, stringArray2);
        this.prior = new UniformPrior();
        this.modelType = AbstractModel.ModelType.MaxentQn;
        this.parameters = dArray;
    }

    @Override
    public double[] eval(String[] stringArray) {
        return this.eval(stringArray, new double[this.evalParams.getNumOutcomes()]);
    }

    private int getPredIndex(String string) {
        return this.pmap.get(string);
    }

    @Override
    public double[] eval(String[] stringArray, double[] dArray) {
        return this.eval(stringArray, null, dArray);
    }

    @Override
    public double[] eval(String[] stringArray, float[] fArray) {
        return this.eval(stringArray, fArray, new double[this.evalParams.getNumOutcomes()]);
    }

    private double[] eval(String[] stringArray, float[] fArray, double[] dArray) {
        int n;
        double[] dArray2 = new double[this.outcomeNames.length];
        double[] dArray3 = new double[this.outcomeNames.length + 1];
        for (n = 0; n < stringArray.length; ++n) {
            int n2 = this.getPredIndex(stringArray[n]);
            for (int i = 0; i < this.outcomeNames.length; ++i) {
                int n3 = i * this.pmap.size() + n2;
                double d = 1.0;
                if (fArray != null) {
                    d = fArray[n];
                }
                if (n3 < 0) {
                    int n4 = i;
                    dArray3[n4] = dArray3[n4] + d * 0.1;
                    continue;
                }
                int n5 = i;
                dArray3[n5] = dArray3[n5] + d * this.parameters[n3];
            }
        }
        for (n = 0; n < this.outcomeNames.length; ++n) {
            dArray3[n] = Math.exp(dArray3[n]);
            int n6 = this.outcomeNames.length;
            dArray3[n6] = dArray3[n6] + dArray3[n];
        }
        for (n = 0; n < this.outcomeNames.length; ++n) {
            dArray2[n] = dArray3[n] / dArray3[this.outcomeNames.length];
        }
        return dArray2;
    }

    @Override
    public int getNumOutcomes() {
        return this.outcomeNames.length;
    }

    public double[] getParameters() {
        return this.parameters;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QNModel)) {
            return false;
        }
        QNModel qNModel = (QNModel)object;
        if (this.outcomeNames.length != qNModel.outcomeNames.length) {
            return false;
        }
        for (int i = 0; i < this.outcomeNames.length; ++i) {
            if (this.outcomeNames[i].equals(qNModel.outcomeNames[i])) continue;
            return false;
        }
        if (this.pmap.size() != qNModel.pmap.size()) {
            return false;
        }
        String[] stringArray = new String[this.pmap.size()];
        this.pmap.toArray(stringArray);
        for (int i = 0; i < this.pmap.size(); ++i) {
            if (i == qNModel.pmap.get(stringArray[i])) continue;
            return false;
        }
        Context[] contextArray = qNModel.evalParams.getParams();
        if (this.evalParams.getParams().length != contextArray.length) {
            return false;
        }
        for (int i = 0; i < this.evalParams.getParams().length; ++i) {
            if (this.evalParams.getParams()[i].getOutcomes().length != contextArray[i].getOutcomes().length) {
                return false;
            }
            int n = 0;
            while (i < this.evalParams.getParams()[i].getOutcomes().length) {
                if (this.evalParams.getParams()[i].getOutcomes()[n] != contextArray[i].getOutcomes()[n]) {
                    return false;
                }
                ++i;
            }
            if (this.evalParams.getParams()[i].getParameters().length != contextArray[i].getParameters().length) {
                return false;
            }
            n = 0;
            while (i < this.evalParams.getParams()[i].getParameters().length) {
                if (this.evalParams.getParams()[i].getParameters()[n] != contextArray[i].getParameters()[n]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

